/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.NewObject;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.MapMethods;
import apex.jorje.semantic.bcl.NewObjectHelperEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.SObjectEmitMethods;
import apex.jorje.semantic.common.iterable.CaseInsensitiveSet;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.member.variable.VariableValidateStoreVisitor;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.VfComponentTypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.I18nSupport;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NewKeyValueObjectExpression
extends Expression {
    private final Location loc;
    private final TypeRef typeRef;
    private final List<NameValueParameter> parameters;

    public NewKeyValueObjectExpression(AstNode definingNode, Expr.NewExpr expr, NewObject.NewKeyValue x) {
        super(definingNode);
        this.loc = expr.loc;
        this.typeRef = x.type;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (apex.jorje.data.ast.NameValueParameter parameter : AstNodes.filterNotNull(x.keyValues)) {
            Expression expression = AstNodes.get().create((AstNode)this, parameter.value);
            builder.add(new NameValueParameter(parameter.name, expression));
        }
        this.parameters = builder.build();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (NameValueParameter parameter : this.parameters) {
                parameter.expression.traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        Errors errors = scope.getErrors();
        if (this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        TypeInfo type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        if (!type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(type));
            return;
        }
        type.accept(new Validator(symbols, scope, this));
        this.setType(type);
    }

    @Override
    public void emit(final Emitter emitter) {
        this.getType().accept(new TypeInfoVisitor.Default<Void>(){

            @Override
            protected Void _default(TypeInfo type) {
                emitter.emitType(NewKeyValueObjectExpression.this.loc, 187, type);
                emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                emitter.emitType(NewKeyValueObjectExpression.this.loc, 187, ReifiedTypeInfos.STRING_TO_OBJECT_MAP);
                emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                emitter.emit(NewKeyValueObjectExpression.this.loc, ObjectEmitMethods.constructor(ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
                for (NameValueParameter parameter : NewKeyValueObjectExpression.this.parameters) {
                    emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                    emitter.push(NewKeyValueObjectExpression.this.loc, parameter.field.getName());
                    parameter.expression.emit(emitter);
                    emitter.emit(NewKeyValueObjectExpression.this.loc, MapMethods.put(ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
                    emitter.emit(NewKeyValueObjectExpression.this.loc, 87);
                }
                emitter.emit(NewKeyValueObjectExpression.this.loc, ObjectEmitMethods.constructor(type, ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
                return null;
            }

            @Override
            public Void visit(SObjectTypeInfo type) {
                boolean isNewCodeGen = emitter.enforceNewEmitBehavior();
                if (isNewCodeGen) {
                    emitter.push(NewKeyValueObjectExpression.this.loc, type.getSubEntityBytecodeNameForCreation());
                    emitter.emit(NewKeyValueObjectExpression.this.loc, NewObjectHelperEmitMethods.newSObject());
                    emitter.emitType(NewKeyValueObjectExpression.this.loc, 192, type.getBytecodeName());
                    this.emitKeyValueParameters(type, isNewCodeGen);
                    emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                    emitter.emit(NewKeyValueObjectExpression.this.loc, SObjectEmitMethods.initializationCompleted(SObjectTypeInfoUtil.getUnionEntityEmitType(type)));
                    return null;
                }
                emitter.emitType(NewKeyValueObjectExpression.this.loc, 187, type);
                emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                emitter.emit(NewKeyValueObjectExpression.this.loc, ObjectEmitMethods.constructor(type));
                this.emitKeyValueParameters(type, isNewCodeGen);
                emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                emitter.emit(NewKeyValueObjectExpression.this.loc, SObjectEmitMethods.initializationCompleted(type));
                return null;
            }

            private void emitKeyValueParameters(SObjectTypeInfo type, boolean isNewCodeGen) {
                for (NameValueParameter parameter : NewKeyValueObjectExpression.this.parameters) {
                    emitter.emit(NewKeyValueObjectExpression.this.loc, 89);
                    parameter.expression.emit(emitter);
                    TypeConversion.emit(NewKeyValueObjectExpression.this.loc, emitter, parameter.expression.getType(), parameter.field.getType());
                    emitter.push(NewKeyValueObjectExpression.this.loc, parameter.field.getBytecodeName());
                    emitter.emit(NewKeyValueObjectExpression.this.loc, SObjectTypeInfoUtil.getMethodsForEmit(isNewCodeGen ? SObjectTypeInfoUtil.getUnionEntityEmitType(type) : type).setValueMethod());
                }
            }
        });
        if (this.isTopLevel()) {
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public List<NameValueParameter> getParameters() {
        return this.parameters;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    private class Validator
    extends TypeInfoVisitor.Default<Void> {
        private final SymbolResolver symbols;
        private final ValidationScope scope;
        private final AstNode node;

        private Validator(SymbolResolver symbols, ValidationScope scope, AstNode node) {
            this.symbols = symbols;
            this.scope = scope;
            this.node = node;
        }

        private void validateParameter(VariableValidateStoreVisitor visitor, VariableVisitor.Context context, Set<String> duplicateParameters, NameValueParameter parameter) {
            TypeInfo expressionType;
            if (!duplicateParameters.add(parameter.name.getValue().toLowerCase())) {
                this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("duplicate.field.init", parameter.field.getName()));
                return;
            }
            parameter.context = context;
            if (!parameter.field.accept(visitor, parameter.context).booleanValue()) {
                return;
            }
            parameter.expression.validate(this.symbols, this.scope);
            if (this.scope.getErrors().isInvalid(parameter.expression)) {
                this.scope.getErrors().markInvalid(this.node);
                return;
            }
            TypeInfo typeInfo = expressionType = parameter.getSObjectField().getCategory() == SObjectFieldInfo.Category.FOREIGN_KEY && SObjectTypeInfoUtil.isConcreteSObjectList(parameter.expression.getType()) ? CollectionTypeInfoUtil.getElementType(parameter.expression.getType()) : parameter.expression.getType();
            assert (parameter.getSObjectField().getCategory() != SObjectFieldInfo.Category.AGGREGATE) : "cannot use aggregate path for new sobject";
            if (!Distance.get().canAssign(NewKeyValueObjectExpression.this.getDefiningType(), expressionType, parameter.field.getType())) {
                this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("illegal.assignment", expressionType, parameter.field.getType()));
            }
        }

        @Override
        protected Void _default(TypeInfo type) {
            this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("invalid.name.value.pair.constructor", type));
            return null;
        }

        @Override
        public Void visit(VfComponentTypeInfo type) {
            CaseInsensitiveSet duplicateParameters = new CaseInsensitiveSet();
            for (NameValueParameter parameter : NewKeyValueObjectExpression.this.parameters) {
                parameter.field = type.fields().get(this.symbols, NewKeyValueObjectExpression.this.getDefiningType(), parameter.name.getValue(), FieldTable.LookupMode.INSTANCE_VARIABLE);
                if (parameter.field == null) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("field.does.not.exist", parameter.name.getValue(), type));
                    continue;
                }
                if (!duplicateParameters.add(parameter.field.getName())) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("duplicate.field.init", parameter.field.getName()));
                }
                parameter.expression.validate(this.symbols, this.scope);
                if (!this.scope.getErrors().isInvalid(parameter.expression)) continue;
                this.scope.getErrors().markInvalid(this.node);
            }
            return null;
        }

        @Override
        public Void visit(SObjectTypeInfo type) {
            VariableValidateStoreVisitor visitor = VariableValidateStoreVisitor.create(this.symbols, this.scope, this.node);
            VariableVisitor.Context context = new VariableVisitor.Context(NewKeyValueObjectExpression.this.loc);
            context.isSObjectConstruction = true;
            context.isLast = true;
            context.previous = IdentifierContext.OBJECT;
            context.referenceType = ReferenceType.STORE;
            for (NameValueParameter parameter : NewKeyValueObjectExpression.this.parameters) {
                parameter.field = type.fields().get(this.symbols, NewKeyValueObjectExpression.this.getDefiningType(), parameter.name.getValue(), FieldTable.LookupMode.INSTANCE_VARIABLE);
                if (parameter.field == null) {
                    this.scope.getErrors().markInvalid(this.node, I18nSupport.getLabel("field.does.not.exist", parameter.name.getValue(), type));
                    continue;
                }
                context.hasSObjectPrimaryKeyInit |= parameter.getSObjectField().isPrimaryKey();
            }
            HashSet duplicateParameters = new HashSet();
            NewKeyValueObjectExpression.this.parameters.stream().filter(p -> ((NameValueParameter)p).field != null).forEach(p -> this.validateParameter(visitor, context, duplicateParameters, (NameValueParameter)p));
            return null;
        }
    }

    public static class NameValueParameter {
        private static final VariableVisitor<SObjectFieldInfo, Scope> GET_SOBJECT_FIELD = new VariableVisitor.Default<SObjectFieldInfo, Scope>(){

            @Override
            protected SObjectFieldInfo _default(Variable info, Scope context) {
                return null;
            }

            @Override
            public SObjectFieldInfo visit(SObjectFieldInfo info, Scope context) {
                return info;
            }
        };
        private final Identifier name;
        private final Expression expression;
        private FieldInfo field;
        private VariableVisitor.Context context;

        NameValueParameter(Identifier name, Expression expression) {
            this.name = name;
            this.expression = expression;
        }

        public SObjectFieldInfo getSObjectField() {
            return this.field.accept(GET_SOBJECT_FIELD, NoopScope.get());
        }
    }
}

