/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.IdEmitMethods;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import org.objectweb.asm.Label;

interface Comparison {
    public void emitUnbox(Emitter var1, TypeInfo var2);

    public void emitComparison(Location var1, Emitter var2, Label var3);

    public static final class ReferenceComparison
    implements Comparison {
        private final int opcode;

        ReferenceComparison(int opcode) {
            this.opcode = opcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Location loc, Emitter emitter, Label falseLabel) {
            emitter.emitJump(loc, this.opcode, falseLabel);
        }
    }

    public static final class IdComparison
    implements Comparison {
        private final BooleanOp op;
        private final int unaryOpcode;

        IdComparison(BooleanOp op, int unaryOpcode) {
            this.op = op;
            this.unaryOpcode = unaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Location loc, Emitter emitter, Label falseLabel) {
            boolean value = !this.op.isEquality();
            emitter.push(loc, value);
            emitter.box(TypeInfos.BOOLEAN);
            emitter.emit(loc, IdEmitMethods.COMPARE_TO);
            emitter.unbox(TypeInfos.INTEGER);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class StaticComparison
    implements Comparison {
        private final int unaryOpcode;
        private final AsmMethod method;

        StaticComparison(int unaryOpcode, AsmMethod method) {
            this.unaryOpcode = unaryOpcode;
            this.method = method;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
        }

        @Override
        public void emitComparison(Location loc, Emitter emitter, Label falseLabel) {
            emitter.emit(loc, this.method);
            emitter.unbox(TypeInfos.INTEGER);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class BinaryComparison
    implements Comparison {
        private final int unaryOpcode;
        private final int binaryOpcode;

        BinaryComparison(int unaryOpcode, int binaryOpcode) {
            this.unaryOpcode = unaryOpcode;
            this.binaryOpcode = binaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
            emitter.unbox(type);
        }

        @Override
        public void emitComparison(Location loc, Emitter emitter, Label falseLabel) {
            emitter.emit(loc, this.binaryOpcode);
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }

    public static final class UnaryComparison
    implements Comparison {
        private final int unaryOpcode;

        UnaryComparison(int unaryOpcode) {
            this.unaryOpcode = unaryOpcode;
        }

        @Override
        public void emitUnbox(Emitter emitter, TypeInfo type) {
            emitter.unbox(type);
        }

        @Override
        public void emitComparison(Location loc, Emitter emitter, Label falseLabel) {
            emitter.emitJump(loc, this.unaryOpcode, falseLabel);
        }
    }
}

