/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.BindExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ReifiedTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.printers.PrintContext;
import com.google.common.collect.MoreLists;
import java.util.List;

public class BindExpressions
implements AstNode {
    private static final AsmMethod PUT_BYTECODE = AsmMethod.builder().invokeVirtual().setDefiningTypeAsBytecodeMethodName(ReifiedTypeInfos.STRING_TO_OBJECT_MAP).setFunction("putBytecode").setSignature((TypeInfo)TypeInfos.OBJECT, TypeInfos.OBJECT, TypeInfos.OBJECT).build();
    private final TypeInfo definingType;
    private final Location loc;
    private final List<BindExpression> bindExpressions;
    private String query;

    public BindExpressions(AstNode definingNode, List<PrintContext.BindExpr> bindExprs) {
        this.definingType = definingNode.getDefiningType();
        this.loc = definingNode.getLoc();
        this.bindExpressions = bindExprs.stream().map(bindExpr -> new BindExpression(bindExpr.name, AstNodes.get().create((AstNode)this, bindExpr.expr))).collect(MoreLists.toImmutableList(bindExprs.size()));
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            for (BindExpression bindExpression : this.bindExpressions) {
                bindExpression.getExpression().traverse(visitor, scope);
            }
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        for (BindExpression bindExpression : this.bindExpressions) {
            bindExpression.getExpression().validate(symbols, scope);
            if (!scope.getErrors().isInvalid(bindExpression.getExpression())) continue;
            scope.getErrors().markInvalid(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        assert (this.query != null) : "query never set";
        emitter.push(this.loc, this.query);
        emitter.emitType(this.loc, 187, ReifiedTypeInfos.STRING_TO_OBJECT_MAP);
        emitter.emit(this.loc, 89);
        emitter.emit(this.loc, ObjectEmitMethods.constructor(ReifiedTypeInfos.STRING_TO_OBJECT_MAP));
        for (BindExpression bindExpression : this.bindExpressions) {
            emitter.emit(this.loc, 89);
            emitter.push(this.loc, bindExpression.getName());
            bindExpression.getExpression().emit(emitter);
            emitter.emit(this.loc, PUT_BYTECODE);
            emitter.emit(this.loc, 87);
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.definingType;
    }

    @Override
    public Location getLoc() {
        return null;
    }

    public void setQuery(String query) {
        assert (this.query == null) : "query already set";
        this.query = query;
    }

    public List<BindExpression> getBindExpressions() {
        return this.bindExpressions;
    }
}

