/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.workspace;

import apex.jorje.lsp.api.workspace.WorkspaceChangeListener;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;

@Singleton
public class WorkspaceChangeListenerDispatcher
implements WorkspaceChangeListener {
    private final Set<WorkspaceChangeListener> listeners;
    private final Provider<ExecutorService> executorProvider;

    @Inject
    public WorkspaceChangeListenerDispatcher(Set<WorkspaceChangeListener> listeners, Provider<ExecutorService> executorProvider) {
        this.listeners = listeners;
        this.executorProvider = executorProvider;
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.listeners.forEach(listener -> executor.submit(() -> listener.didChangeConfiguration(params)));
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        ExecutorService executor = (ExecutorService)this.executorProvider.get();
        this.listeners.forEach(listener -> executor.submit(() -> listener.didChangeWatchedFiles(params)));
    }
}

