/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.index.SfdxProjectPOJO;
import apex.jorje.lsp.impl.workspace.RootPath;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SfdxProjectUtil {
    private static final Logger logger = LoggerFactory.getLogger(SfdxProjectUtil.class);
    private final Provider<RootPath> rootPathProvider;

    @Inject
    public SfdxProjectUtil(Provider<RootPath> rootPathProvider) {
        this.rootPathProvider = rootPathProvider;
    }

    public synchronized ImmutablePair<Optional<SfdxProject>, Set<URI>> getSfdxFiles(Set<URI> results, SimpleFileVisitor<Path> visitor) {
        Optional<SfdxProject> sfdxProject = this.constructSfdxProject(results, visitor);
        return new ImmutablePair(sfdxProject, results);
    }

    public synchronized Optional<SfdxProject> constructSfdxProject(Set<URI> results, SimpleFileVisitor<Path> visitor) {
        SfdxProject sfdxProject = null;
        Path sfdxProjectFilePath = Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), "sfdx-project.json");
        if (Files.exists(sfdxProjectFilePath, new LinkOption[0])) {
            results.clear();
            try {
                sfdxProject = SfdxProject.from(new String(Files.readAllBytes(sfdxProjectFilePath)), (RootPath)this.rootPathProvider.get());
                if (sfdxProject.packageDirectories != null) {
                    for (SfdxProjectPOJO.PackageDirectoriesPOJO pkg : sfdxProject.packageDirectories) {
                        if (pkg.path == null) continue;
                        Path pkgPath = Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), pkg.path);
                        Files.walkFileTree(pkgPath, visitor);
                    }
                }
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve contents of {}", (Object)sfdxProjectFilePath, (Object)ioe);
            }
            catch (JsonSyntaxException jse) {
                logger.error("Contents of {} is invalid json", (Object)sfdxProjectFilePath, (Object)jse);
            }
        }
        return Optional.ofNullable(sfdxProject);
    }
}

