/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.utils;

import apex.jorje.data.Location;
import java.net.URI;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class Locations {
    private Locations() {
    }

    public static org.eclipse.lsp4j.Location from(URI doc, Location jorjeLoc) {
        return new org.eclipse.lsp4j.Location(doc.toString(), Ranges.from(jorjeLoc));
    }

    public static class Ranges {
        private Ranges() {
        }

        public static Range from(Location loc) {
            assert (loc.getStartIndex() > -1) : "Negative start index provided";
            assert (loc.getEndIndex() > -1) : "Negative end index provided";
            assert (loc.getEndIndex() >= loc.getStartIndex()) : "End index greater than start index";
            int normalizedLine = loc.getLine() >= 1 ? loc.getLine() - 1 : 0;
            int tokenStartCol = loc.getColumn() >= 1 ? loc.getColumn() - 1 : 0;
            int tokenLength = loc.getEndIndex() - loc.getStartIndex();
            int tokenEndCol = tokenStartCol + tokenLength;
            return new Range(new Position(normalizedLine, tokenStartCol), new Position(normalizedLine, tokenEndCol));
        }
    }
}

