/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.services;

import apex.jorje.lsp.api.debug.DebuggerService;
import apex.jorje.lsp.impl.workspace.RootPath;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexLanguageServer
implements LanguageServer,
Provider<RootPath> {
    private static final Logger logger = LoggerFactory.getLogger(ApexLanguageServer.class);
    private final TextDocumentService textDocumentService;
    private final WorkspaceService workspaceService;
    private final DebuggerService debuggerService;
    private final Provider<ServiceManager> serviceManagerProvider;
    private RootPath rootPath;

    @Inject
    public ApexLanguageServer(TextDocumentService textDocumentService, WorkspaceService workspaceService, DebuggerService debuggerService, Provider<ServiceManager> serviceManagerProvider) {
        this.textDocumentService = textDocumentService;
        this.workspaceService = workspaceService;
        this.debuggerService = debuggerService;
        this.serviceManagerProvider = serviceManagerProvider;
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        InitializeResult result = new InitializeResult();
        try {
            this.rootPath = new RootPath(params.getRootPath());
            ServiceManager serviceManager = (ServiceManager)this.serviceManagerProvider.get();
            serviceManager.startAsync();
            ServerCapabilities capabilities = new ServerCapabilities();
            capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
            capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
            capabilities.setCompletionProvider(new CompletionOptions(Boolean.valueOf(false), Collections.singletonList(".")));
            capabilities.setDefinitionProvider(Boolean.valueOf(true));
            result.setCapabilities(capabilities);
        }
        catch (Exception e) {
            logger.error("Error trying to initialize the language server", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<Object> shutdown() {
        logger.info("Shutting down...");
        try {
            ServiceManager serviceManager = (ServiceManager)this.serviceManagerProvider.get();
            serviceManager.stopAsync();
            serviceManager.awaitStopped(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException te) {
            logger.error("Failed to stop some services within time limit, proceeding to shutdown anyway", (Throwable)te);
        }
        return CompletableFuture.completedFuture(new Object());
    }

    public void exit() {
        logger.info("Exiting...");
        System.exit(0);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    @JsonDelegate
    public DebuggerService getDebuggerService() {
        return this.debuggerService;
    }

    public RootPath get() {
        return this.rootPath;
    }
}

