/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.Initializers;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.Modifiers;
import apex.jorje.lsp.impl.index.symbol.VirtualCodeUnitDetails;
import apex.jorje.lsp.impl.index.symbol.VirtualFieldTableInitializer;
import apex.jorje.lsp.impl.index.symbol.VirtualMethodTableInitializer;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.inject.Provider;
import org.eclipse.jdt.internal.core.nd.IReader;

public class VirtualStandardTypeInfo
extends AbstractTypeInfo
implements StandardTypeInfo {
    private final VirtualCodeUnitDetails codeUnit;

    private VirtualStandardTypeInfo(Builder builder) {
        super(builder);
        this.codeUnit = new VirtualCodeUnitDetails(this, new SourceFile.Builder().setKnownName(builder.uri).build());
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CodeUnitDetails getCodeUnitDetails() {
        return this.codeUnit;
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, VirtualStandardTypeInfo> {
        private final Provider<ApexIndex> apexIndexProvider;
        private final SymbolResolver symbolResolver;
        private ApexTypeId typeId;
        private String uri;

        public Builder(SymbolResolver symbolResolver, Provider<ApexIndex> apexIndexProvider) {
            this.symbolResolver = symbolResolver;
            this.apexIndexProvider = apexIndexProvider;
        }

        public Builder setApexTypeId(ApexTypeId typeId) {
            this.typeId = typeId;
            return this;
        }

        @Override
        public VirtualStandardTypeInfo build() {
            try (IReader ignored = ((ApexIndex)this.apexIndexProvider.get()).getNd().acquireReadLock();){
                this.uri = this.typeId.getType().getFile().getFilename().getString();
                this.setApexName(this.typeId.getApexName().getString());
                this.setBytecodeName(this.typeId.getBytecodeName().getString());
                this.setUnitType(this.unitTypeFrom(this.typeId.getType().getUnitType().getString()));
                this.setNamespace(Namespaces.create(this.typeId.getApexNamespace().getString()));
                this.setModifiers(Modifiers.toModifierGroup(this.typeId.getType().getModifiers().getString()));
                this.setParents(new StandardParentTable());
                this.setFields(Initializers.memoize(new VirtualFieldTableInitializer(this.symbolResolver, this.apexIndexProvider, this.typeId.getType())));
                this.setMethods(Initializers.memoize(new VirtualMethodTableInitializer(this.symbolResolver, this.apexIndexProvider, this.typeId.getType())));
                VirtualStandardTypeInfo virtualStandardTypeInfo = new VirtualStandardTypeInfo(this);
                return virtualStandardTypeInfo;
            }
        }

        private UnitType unitTypeFrom(String unitType) {
            return UnitType.valueOf(unitType);
        }
    }
}

