/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.Initializers;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.Modifiers;
import apex.jorje.lsp.impl.index.symbol.VirtualCodeUnitDetails;
import apex.jorje.lsp.impl.index.symbol.VirtualFieldTableInitializer;
import apex.jorje.semantic.bcl.SObjectMethods;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.SObjectMetadata;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import com.google.inject.Provider;
import org.eclipse.jdt.internal.core.nd.IReader;

public class VirtualSObjectTypeInfo
extends SObjectTypeInfo {
    private final VirtualCodeUnitDetails codeUnit;

    private VirtualSObjectTypeInfo(Builder builder) {
        super((AbstractTypeInfo.Builder)builder);
        this.metadata = builder.metadata;
        this.codeUnit = new VirtualCodeUnitDetails(this, new SourceFile.Builder().setKnownName(builder.uri).build());
    }

    @Override
    public CodeUnitDetails getCodeUnitDetails() {
        return this.codeUnit;
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, VirtualSObjectTypeInfo> {
        private final Provider<ApexIndex> apexIndexProvider;
        private final SymbolResolver symbolResolver;
        private ApexTypeId typeId;
        private SObjectMetadata metadata;
        private String uri;

        public Builder(SymbolResolver symbolResolver, Provider<ApexIndex> apexIndexProvider) {
            this.symbolResolver = symbolResolver;
            this.apexIndexProvider = apexIndexProvider;
        }

        public Builder setApexTypeId(ApexTypeId typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder setMetadata(SObjectMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public VirtualSObjectTypeInfo build() {
            try (IReader ignored = ((ApexIndex)this.apexIndexProvider.get()).getNd().acquireReadLock();){
                this.uri = this.typeId.getType().getFile().getFilename().getString();
                this.setApexName(this.typeId.getApexName().getString());
                this.setBytecodeName(this.typeId.getBytecodeName().getString());
                this.setUnitType(this.unitTypeFrom(this.typeId.getType().getUnitType().getString()));
                this.setNamespace(Namespaces.create(this.typeId.getApexNamespace().getString()));
                this.setModifiers(Modifiers.toModifierGroup(this.typeId.getType().getModifiers().getString()));
                this.setParents(SObjectTypeInfo.SHARED_PARENT_TABLE);
                this.setFields(Initializers.memoize(new VirtualFieldTableInitializer(this.symbolResolver, this.apexIndexProvider, this.typeId.getType())));
                this.setMethods(SObjectMethods.get());
                this.setBasicType(BasicType.SOBJECT);
                VirtualSObjectTypeInfo virtualSObjectTypeInfo = new VirtualSObjectTypeInfo(this);
                return virtualSObjectTypeInfo;
            }
        }

        private UnitType unitTypeFrom(String unitType) {
            return UnitType.valueOf(unitType);
        }
    }
}

