/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.index.converter.ConverterFactory;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.symbols.CachingSymbolProvider;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.api.workspace.WorkspaceChangeListener;
import apex.jorje.lsp.impl.clients.VSCode;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.SfdxProject;
import apex.jorje.lsp.impl.index.converter.TypeInfoConverter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.utils.SfdxProjectUtil;
import apex.jorje.lsp.impl.workspace.RootPath;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.NoopScope;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.internal.core.nd.IProgressMonitor;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.NullProgressMonitor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.FileEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexIndexer
extends AbstractScheduledService
implements WorkspaceChangeListener,
DocumentLifecycleHandler {
    public static final PathMatcher CLS_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.cls");
    public static final PathMatcher TRG_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.trigger");
    private static final Logger logger = LoggerFactory.getLogger(ApexIndexer.class);
    private static final String USER_DEFINED_TYPES_SCHEME = "file:///";
    private static final String SOBJECTS_DIR = "sobjects";
    private static final String CUSTOM_FAUX_CLASSES_DIR = "customObjects";
    private static final String STANDARD_FAUX_CLASSES_DIR = "standardObjects";
    private final Provider<RootPath> rootPathProvider;
    private final Provider<ApexIndex> apexIndexProvider;
    private final ApexDocumentService documentService;
    private final ApexCompilerService compilerService;
    private final CachingSymbolProvider symbolProvider;
    private final ConverterFactory converterFactory;
    private final SfdxProjectUtil sfdxProjectUtil;
    private final Set<URI> apexUris = Sets.newHashSet();
    private Set<URI> customObjectUris = Collections.emptySet();
    private Set<URI> standardObjectUris = Collections.emptySet();
    private final Queue<FileEvent> fileEvents = Queues.newConcurrentLinkedQueue();
    private boolean isInitializing = true;
    private Optional<SfdxProject> sfdxProject;

    @Inject
    public ApexIndexer(Provider<RootPath> rootPathProvider, Provider<ApexIndex> apexIndexProvider, ApexDocumentService documentService, ApexCompilerService compilerService, CachingSymbolProvider symbolProvider, ConverterFactory converterFactory, SfdxProjectUtil sfdxProjectUtil) {
        this.rootPathProvider = rootPathProvider;
        this.apexIndexProvider = apexIndexProvider;
        this.documentService = documentService;
        this.compilerService = compilerService;
        this.symbolProvider = symbolProvider;
        this.converterFactory = converterFactory;
        this.sfdxProjectUtil = sfdxProjectUtil;
    }

    private synchronized void reinitialize() {
        this.startUp();
    }

    @VisibleForTesting
    synchronized void clearOldCache() {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            apexIndex.fuzzyFindResourceFiles(USER_DEFINED_TYPES_SCHEME).forEach(NdNode::delete);
        }
        finally {
            nd.releaseWriteLock();
            this.symbolProvider.invalidateAll();
        }
    }

    private void buildCacheInternal(Set<URI> classesToProcess) {
        ArrayList<SourceFile> sourceFiles = Lists.newArrayList();
        try {
            for (URI uri : classesToProcess) {
                SourceFile sourceFile = SourceFile.builder().setBody(new String(Files.readAllBytes(Paths.get(uri)))).setKnownName(uri.toString()).build();
                sourceFiles.add(sourceFile);
            }
        }
        catch (IOException ioe) {
            logger.error("Unable to analyze user-defined types from filesystem", (Throwable)ioe);
        }
        for (CodeUnit codeUnit : this.compilerService.addSourceFiles(sourceFiles).compile()) {
            this.insertCodeUnit(codeUnit);
        }
    }

    private synchronized void buildCache() {
        this.buildCacheInternal(this.standardObjectUris);
        this.buildCacheInternal(this.customObjectUris);
        this.buildCacheInternal(this.apexUris);
    }

    private synchronized void insertCodeUnit(final CodeUnit codeUnit) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        final Nd nd = apexIndex.getNd();
        TypeInfo type = codeUnit.getType();
        this.insertTypeInfo(codeUnit, nd, type);
        codeUnit.getNode().traverse(new AstVisitor<NoopScope>(){

            @Override
            public boolean visit(UserClass node, NoopScope scope) {
                return true;
            }

            @Override
            public void visitEnd(UserClass node, NoopScope scope) {
                super.visitEnd(node, scope);
                if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                    ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                }
            }

            @Override
            public boolean visit(UserEnum node, NoopScope scope) {
                return true;
            }

            @Override
            public void visitEnd(UserEnum node, NoopScope scope) {
                super.visitEnd(node, scope);
                if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                    ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                }
            }

            @Override
            public boolean visit(UserInterface node, NoopScope scope) {
                return true;
            }

            @Override
            public void visitEnd(UserInterface node, NoopScope scope) {
                super.visitEnd(node, scope);
                if (!TypeInfoUtil.isTopLevel(node.getDefiningType())) {
                    ApexIndexer.this.insertTypeInfo(codeUnit, nd, node.getDefiningType());
                }
            }
        }, NoopScope.get());
    }

    private boolean isSObject(CodeUnit codeUnit) {
        String unitName = codeUnit.getSourceFile().getKnownName();
        return unitName.contains(this.getStandardObjectsDir().toString()) || unitName.contains(this.getCustomObjectsDir().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTypeInfo(CodeUnit codeUnit, Nd nd, TypeInfo type) {
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            ApexResourceFile resourceFile = new ApexResourceFile(nd);
            resourceFile.setFilename(codeUnit.getSourceFile().getKnownName());
            resourceFile.setTimeLastScanned(System.currentTimeMillis());
            TypeInfoConverter converter = this.converterFactory.createTypeInfoConverter(resourceFile);
            converter.addType(type, this.isSObject(codeUnit));
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    @VisibleForTesting
    public Path getStandardObjectsDir() {
        return Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), ".sfdx", "tools", SOBJECTS_DIR, STANDARD_FAUX_CLASSES_DIR);
    }

    @VisibleForTesting
    public Path getCustomObjectsDir() {
        return Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), ".sfdx", "tools", SOBJECTS_DIR, CUSTOM_FAUX_CLASSES_DIR);
    }

    public Path getSObjectsDir() {
        return Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), ".sfdx", "tools", SOBJECTS_DIR);
    }

    @VisibleForTesting
    public Path getSfdxProjectPath() {
        return Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), "sfdx-project.json");
    }

    private Set<URI> processSObjects(Path SObjectsPath) {
        final HashSet<URI> sobjectUris = Sets.newHashSet();
        if (Files.exists(SObjectsPath, new LinkOption[0])) {
            sobjectUris.clear();
            try {
                Files.walkFileTree(SObjectsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (CLS_MATCHER.matches(file)) {
                            sobjectUris.add(file.toUri());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ioe) {
                logger.error("Failed to retrieve contents of {}", (Object)SObjectsPath, (Object)ioe);
            }
        }
        return sobjectUris;
    }

    private synchronized Optional<SfdxProject> constructSfdxProject() {
        return this.sfdxProjectUtil.constructSfdxProject(this.apexUris, new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (CLS_MATCHER.matches(file)) {
                    ApexIndexer.this.apexUris.add(file.toUri());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private synchronized boolean isSObjectFauxClass(Path file) {
        return file.startsWith(this.getStandardObjectsDir()) || file.startsWith(this.getCustomObjectsDir());
    }

    private synchronized boolean isUnderPackageDirectory(Path file) {
        return this.sfdxProject.isPresent() && this.sfdxProject.get().isUnderPackageDirectory(file);
    }

    private synchronized boolean isValidClass(Path file) {
        return this.isUnderPackageDirectory(file) || this.isSObjectFauxClass(file);
    }

    @Override
    public synchronized void didChangeConfiguration(DidChangeConfigurationParams didChangeConfigurationParams) {
    }

    @Override
    public synchronized void didChangeWatchedFiles(DidChangeWatchedFilesParams didChangeWatchedFilesParams) {
        this.fileEvents.addAll(VSCode.standardizeFileEvents(didChangeWatchedFilesParams.getChanges()));
        logger.debug("didChangeWatchedFiles " + this.fileEvents.size());
    }

    @VisibleForTesting
    synchronized void runOne() throws Exception {
        boolean priorIsInitializing = this.isInitializing;
        try {
            this.isInitializing = false;
            this.runOneIteration();
        }
        finally {
            this.isInitializing = priorIsInitializing;
        }
    }

    @Override
    protected synchronized void runOneIteration() throws Exception {
        boolean processingChangesToSObjects = false;
        if (this.isInitializing) {
            return;
        }
        Path sfdxProjectFilePath = Paths.get(((RootPath)this.rootPathProvider.get()).getRootPath(), "sfdx-project.json");
        while (!this.fileEvents.isEmpty()) {
            FileEvent change = this.fileEvents.remove();
            String uri = change.getUri();
            Path path = Paths.get(URI.create(uri));
            if (this.isSObjectFauxClass(path)) {
                if (processingChangesToSObjects) continue;
                processingChangesToSObjects = true;
                logger.info("processing changes to SObjects " + change.getType());
                continue;
            }
            if (CLS_MATCHER.matches(path)) {
                switch (change.getType()) {
                    case Created: {
                        if (!this.isValidClass(path)) break;
                        this.apexUris.add(URI.create(uri));
                        this.insertTypeInfo(uri);
                        break;
                    }
                    case Changed: {
                        if (!this.isValidClass(path)) break;
                        this.updateTypeInfo(uri);
                        break;
                    }
                    case Deleted: {
                        if (!this.isValidClass(path)) break;
                        this.apexUris.remove(URI.create(uri));
                        this.deleteTypeInfo(uri);
                    }
                }
                continue;
            }
            if (!Objects.equals(path, sfdxProjectFilePath)) continue;
            this.reinitialize();
        }
        if (processingChangesToSObjects) {
            this.reinitialize();
        }
    }

    @Override
    public synchronized void startUp() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info("Scanning user-defined types.");
        this.isInitializing = true;
        try {
            this.standardObjectUris = this.processSObjects(this.getStandardObjectsDir());
            this.customObjectUris = this.processSObjects(this.getCustomObjectsDir());
            this.sfdxProject = this.constructSfdxProject();
            this.sfdxProject.ifPresent(workspace -> {
                this.clearOldCache();
                this.buildCache();
            });
        }
        finally {
            this.isInitializing = false;
        }
        stopwatch.stop();
        logger.info("Scanning user-defined types took {} ms.", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedRateSchedule(10L, 5L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    public synchronized void insertTypeInfo(String uri) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(uri));
        optDoc.ifPresent(doc -> {
            CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).build()).addSources(doc.getSource()).compile(), doc.getUri().toString());
            this.insertCodeUnit(codeUnit);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized void deleteTypeInfo(String uri) {
        ApexIndex apexIndex = (ApexIndex)this.apexIndexProvider.get();
        Nd nd = apexIndex.getNd();
        nd.acquireWriteLock((IProgressMonitor)new NullProgressMonitor());
        try {
            apexIndex.fuzzyFindResourceFiles(uri).forEach(apexResourceFile -> {
                apexResourceFile.getTypes().forEach(type -> this.symbolProvider.invalidate(type.getTypeId().getApexName().getString().toLowerCase()));
                apexResourceFile.delete();
            });
        }
        finally {
            nd.releaseWriteLock();
        }
    }

    @VisibleForTesting
    synchronized void updateTypeInfo(String uri) {
        this.deleteTypeInfo(uri);
        this.insertTypeInfo(uri);
    }

    @Override
    public synchronized void handleDidOpen(DidOpenTextDocumentParams params) {
    }

    @Override
    public synchronized void handleDidChange(DidChangeTextDocumentParams params) {
        this.updateTypeInfo(params.getTextDocument().getUri());
    }

    @Override
    public synchronized void handleDidClose(DidCloseTextDocumentParams params) {
    }

    @Override
    public synchronized void handleDidSave(DidSaveTextDocumentParams params) {
    }
}

