/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index;

import apex.jorje.lsp.impl.index.node.ApexField;
import apex.jorje.lsp.impl.index.node.ApexMethod;
import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexResourceFile;
import apex.jorje.lsp.impl.index.node.ApexTreeNode;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.node.SObjectField;
import apex.jorje.lsp.impl.workspace.RootPath;
import apex.jorje.semantic.compiler.Namespace;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nullable;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.NdNodeTypeRegistry;
import org.eclipse.jdt.internal.core.nd.db.ChunkCache;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.field.FieldSearchIndex;
import org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexIndex {
    public static final String INDEX_FILENAME = "apex.db";
    public static final FieldSearchIndex<ApexResourceFile> FILES;
    public static final FieldSearchIndex<ApexTypeId> TYPES_BY_APEX_NAME;
    public static final FieldSearchIndex<ApexTypeId> TYPES_BY_BYTECODE_NAME;
    public static final FieldSearchIndex<ApexTypeId> NAMESPACES;
    private static final StructDef<ApexIndex> type;
    private static final int CURRENT_VERSION;
    private static final int MAX_SUPPORTED_VERSION;
    private static final int MIN_SUPPORTED_VERSION;
    private static final Logger logger;
    private static final Object ndMutex;
    private static final BestResourceFile bestResourceFile;
    private final Nd nd;
    private final long address;
    private final FieldSearchIndex.IResultRank shortestNameMatch = (nd, address) -> (long)(500.0f / (float)ApexTypeId.APEX_NAME.get(nd, address).length());
    private Provider<RootPath> rootPathProvider;
    private Nd globalNd;

    public ApexIndex(Nd nd2, long address2) {
        this.nd = nd2;
        this.address = address2;
    }

    ApexIndex(Provider<RootPath> rootPathProvider) {
        this.rootPathProvider = rootPathProvider;
        this.nd = this.getGlobalNd();
        this.address = Database.DATA_AREA_OFFSET;
    }

    private static Nd createNd(File databaseFile, ChunkCache chunkCache) {
        return new Nd(databaseFile, chunkCache, ApexIndex.createTypeRegistry(), MIN_SUPPORTED_VERSION, MAX_SUPPORTED_VERSION, CURRENT_VERSION);
    }

    private static NdNodeTypeRegistry<NdNode> createTypeRegistry() {
        NdNodeTypeRegistry registry = new NdNodeTypeRegistry();
        registry.register(1, ApexField.type.getFactory());
        registry.register(2, ApexMethod.type.getFactory());
        registry.register(3, ApexMethodParameter.type.getFactory());
        registry.register(4, ApexResourceFile.type.getFactory());
        registry.register(5, ApexTreeNode.type.getFactory());
        registry.register(6, ApexType.type.getFactory());
        registry.register(7, ApexTypeId.type.getFactory());
        registry.register(8, SObjectField.type.getFactory());
        return registry;
    }

    public Nd getNd() {
        return this.nd;
    }

    public ApexResourceFile getResourceFile(String location) {
        return (ApexResourceFile)FILES.findBest(this.nd, this.address, FieldSearchIndex.SearchCriteria.create((String)location), (FieldSearchIndex.IResultRank)bestResourceFile);
    }

    private File getDBFile() {
        String rootPath = ((RootPath)this.rootPathProvider.get()).getRootPath();
        Path folder = Paths.get(rootPath, ".sfdx", "tools");
        if (!Files.exists(folder, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                logger.error("Unable to create storage location", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
        Path path = Paths.get(rootPath, ".sfdx", "tools", INDEX_FILENAME);
        return path.toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Nd getGlobalNd() {
        Nd localNd;
        Object object = ndMutex;
        synchronized (object) {
            localNd = this.globalNd;
        }
        if (localNd != null) {
            return localNd;
        }
        localNd = ApexIndex.createNd(this.getDBFile(), ChunkCache.getSharedInstance());
        object = ndMutex;
        synchronized (object) {
            if (this.globalNd == null) {
                this.globalNd = localNd;
            }
            return this.globalNd;
        }
    }

    public ApexTypeId getOrCreateApexTypeId(Namespace namespace, String apexName, String bytecodeName) {
        ApexTypeId existingTypeId = this.findExactTypeId(apexName);
        if (existingTypeId != null) {
            return existingTypeId;
        }
        ApexTypeId result = new ApexTypeId(this.nd, apexName, bytecodeName);
        if (namespace != null) {
            result.setApexNamespace(namespace.getGlobal());
        }
        return result;
    }

    @Nullable
    public ApexTypeId findExactTypeId(String apexName) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)apexName).matchCase(false);
        return (ApexTypeId)TYPES_BY_APEX_NAME.findBest(this.nd, this.address, searchCriteria, FieldSearchIndex.anything);
    }

    @Nullable
    public ApexTypeId fuzzyFindTypeId(String apexName) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)apexName).matchCase(false).prefix(true);
        return (ApexTypeId)TYPES_BY_APEX_NAME.findBest(this.nd, this.address, searchCriteria, this.shortestNameMatch);
    }

    public List<ApexTypeId> fuzzyFindTypeIds(String apexName) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)apexName).matchCase(false).prefix(true);
        return TYPES_BY_APEX_NAME.findAll(this.nd, this.address, searchCriteria);
    }

    public List<ApexTypeId> findTypeIdsByNamespace(String namespace) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)namespace).matchCase(false).prefix(true);
        return NAMESPACES.findAll(this.nd, this.address, searchCriteria);
    }

    List<ApexResourceFile> fuzzyFindResourceFiles(String file) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)file).matchCase(false).prefix(true);
        return FILES.findAll(this.nd, this.address, searchCriteria);
    }

    ApexResourceFile findResourceFile(String file) {
        FieldSearchIndex.SearchCriteria searchCriteria = FieldSearchIndex.SearchCriteria.create((String)file).matchCase(false);
        return (ApexResourceFile)FILES.findBest(this.nd, this.address, searchCriteria, FieldSearchIndex.anything);
    }

    static {
        CURRENT_VERSION = Nd.version((int)41, (int)4);
        MAX_SUPPORTED_VERSION = Nd.version((int)41, (int)4);
        MIN_SUPPORTED_VERSION = Nd.version((int)41, (int)4);
        logger = LoggerFactory.getLogger(ApexIndex.class);
        ndMutex = new Object();
        bestResourceFile = new BestResourceFile();
        type = StructDef.create(ApexIndex.class);
        FILES = FieldSearchIndex.create(type, ApexResourceFile.FILENAME);
        TYPES_BY_APEX_NAME = FieldSearchIndex.create(type, ApexTypeId.APEX_NAME);
        TYPES_BY_BYTECODE_NAME = FieldSearchIndex.create(type, ApexTypeId.BYTECODE_NAME);
        NAMESPACES = FieldSearchIndex.create(type, ApexTypeId.APEX_NAMESPACE);
        type.done();
        assert (type.getFactory().getRecordSize() <= 4096);
    }

    private static final class BestResourceFile
    implements FieldSearchIndex.IResultRank {
        BestResourceFile() {
        }

        public long getRank(Nd resourceFileNd, long resourceFileAddress) {
            return ApexResourceFile.TIME_LAST_SCANNED.get(resourceFileNd, resourceFileAddress);
        }
    }
}

