/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.document;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.PositionTracker;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.document.StandardPositionTracker;
import java.net.URI;

public class StandardDocument
implements Document {
    private final StringBuilder buffer;
    private final PositionTracker tracker;
    private final URI uri;

    public StandardDocument(URI uri, String source) {
        this.uri = uri;
        this.buffer = new StringBuilder(source);
        this.tracker = new StandardPositionTracker(source);
    }

    @Override
    public char getChar(int offset) {
        return this.buffer.charAt(offset);
    }

    @Override
    public int getLength() {
        return this.buffer.length();
    }

    @Override
    public int getLineLength(int line) throws BadLocationException {
        return this.tracker.getLineLength(line);
    }

    @Override
    public int getLineNumberOfOffset(int offset) throws BadLocationException {
        return this.tracker.getLineNumberOfOffset(offset);
    }

    @Override
    public int getLineOffset(int line) throws BadLocationException {
        return this.tracker.getLineOffset(line);
    }

    @Override
    public int getNumberOfLines() {
        return this.tracker.getNumberOfLines();
    }

    @Override
    public String getSource() {
        return this.buffer.toString();
    }

    @Override
    public String getSource(int start, int length) {
        return this.buffer.substring(start, start + length);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Document insert(int offset, String insertion) {
        StringBuilder copy = new StringBuilder(this.buffer.toString());
        return new StandardDocument(this.uri, copy.insert(offset, insertion).toString());
    }
}

