/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.definition;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.lsp.api.definition.DefinitionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.search.MemberDefinitionLocator;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SuperMethodCallExpression;
import apex.jorje.semantic.ast.expression.ThisMethodCallExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardSymbolsDefinitionStrategy
implements DefinitionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(StandardSymbolsDefinitionStrategy.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final MemberDefinitionLocator definitionLocator;

    @Inject
    public StandardSymbolsDefinitionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, MemberDefinitionLocator definitionLocator) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.definitionLocator = definitionLocator;
    }

    @Override
    public List<? extends org.eclipse.lsp4j.Location> provideDefinition(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            try {
                int lineOffset = doc.getLineOffset(params.getPosition().getLine());
                int offset = lineOffset + params.getPosition().getCharacter();
                LocalSymbolVisitor localSymbolVisitor = new LocalSymbolVisitor(this.definitionLocator, (Document)doc, offset);
                this.compilerService.setVisitor(localSymbolVisitor).addSources(doc.getSource()).compile();
                localSymbolVisitor.getLocation().ifPresent(items::add);
            }
            catch (BadLocationException ble) {
                logger.error("Encountered a bad location while providing definition", (Throwable)ble);
            }
        });
        return items;
    }

    static final class LocalSymbolVisitor
    extends AstVisitor<AdditionalPassScope> {
        final int selectionOffset;
        private final MemberDefinitionLocator definitionLocator;
        private final Document doc;
        private Optional<org.eclipse.lsp4j.Location> location = Optional.empty();

        LocalSymbolVisitor(MemberDefinitionLocator definitionLocator, Document doc, int selectionOffset) {
            this.definitionLocator = definitionLocator;
            this.doc = doc;
            this.selectionOffset = selectionOffset;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(ReferenceExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (!Iterables.isEmpty(node.getNames())) {
                int startIndex = node.getLoc().getStartIndex();
                int endIndex = node.getLoc().getEndIndex();
                if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                    List<Identifier> names = node.getNames();
                    IntStream.range(0, names.size()).filter(i -> this.selectionOffset >= ((Identifier)names.get(i)).getLoc().getStartIndex() && ((Identifier)names.get(i)).getLoc().getEndIndex() >= this.selectionOffset).findFirst().ifPresent(index -> {
                        Variable variable;
                        if (node.getVariables() != null && !node.getVariables().isEmpty() && (variable = node.getVariables().get(index)) != null) {
                            this.location = this.from(variable, this.getSourceFile(variable.getDefiningType()), variable.getLoc());
                        }
                    });
                }
            }
        }

        @Override
        public void visitEnd(MethodCallExpression node, AdditionalPassScope scope) {
            MethodInfo method;
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()) != null) {
                this.location = this.from(method, this.getSourceFile(method.getDefiningType()), method.getLoc());
            }
        }

        @Override
        public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            MethodInfo constructor = node.getConstructor();
            if (constructor != null) {
                Location range = Locations.from(node.getTypeRef().getNames().get(0).getLoc(), Iterables.getLast(node.getTypeRef().getNames()).getLoc());
                int startIndex = range.getStartIndex();
                int endIndex = range.getEndIndex();
                if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset) {
                    this.location = this.from(constructor, this.getSourceFile(constructor.getDefiningType()), constructor.getLoc());
                }
            }
        }

        @Override
        public void visitEnd(VariableExpression node, AdditionalPassScope scope) {
            Variable variable;
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (variable = node.getVariable()) != null) {
                this.location = this.from(variable, this.getSourceFile(variable.getDefiningType()), variable.getLoc());
            }
        }

        @Override
        public void visitEnd(SuperMethodCallExpression node, AdditionalPassScope scope) {
            MethodInfo method;
            super.visit(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()) != null) {
                this.location = this.from(method, this.getSourceFile(method.getDefiningType()), method.getLoc());
            }
        }

        @Override
        public void visitEnd(ThisMethodCallExpression node, AdditionalPassScope scope) {
            MethodInfo method;
            super.visit(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.selectionOffset >= startIndex && endIndex >= this.selectionOffset && (method = node.getMethod()) != null) {
                this.location = this.from(method, this.getSourceFile(method.getDefiningType()), method.getLoc());
            }
        }

        private Optional<SourceFile> getSourceFile(TypeInfo typeInfo) {
            try {
                return Optional.of(typeInfo.getCodeUnitDetails().getSource());
            }
            catch (UnsupportedOperationException uoe) {
                return Optional.empty();
            }
        }

        @VisibleForTesting
        Optional<org.eclipse.lsp4j.Location> from(Member member, Optional<SourceFile> optSourceFile, Location location) {
            SourceFile sourceFile;
            if (optSourceFile.isPresent() && (sourceFile = optSourceFile.get()).getKnownName() != null) {
                URI uri = URI.create(sourceFile.getKnownName());
                if (this.isDefinitionInCurrentFile(sourceFile)) {
                    if (Objects.equals(location, Locations.NONE)) {
                        return Optional.empty();
                    }
                    return Optional.of(apex.jorje.lsp.impl.utils.Locations.from(this.doc.getUri(), location));
                }
                if (this.isDefinitionInAnotherFile(uri)) {
                    return this.definitionLocator.locate(member, uri);
                }
            }
            return Optional.empty();
        }

        private boolean isDefinitionInAnotherFile(URI uri) {
            return uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("file");
        }

        private boolean isDefinitionInCurrentFile(SourceFile sourceFile) {
            return sourceFile.getBody().equalsIgnoreCase(this.doc.getSource());
        }

        Optional<org.eclipse.lsp4j.Location> getLocation() {
            return this.location;
        }
    }
}

