/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.data.Locations;
import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;

@Singleton
public class MethodNamesCompletionStrategy
implements CompletionStrategy {
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public MethodNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            if (strategy.shouldSuggestTopLevel()) {
                MethodVisitor methodVisitor = new MethodVisitor();
                CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).build()).addSources(doc.getSource()).compileByPassValidation(), doc.getUri().toString());
                codeUnit.additionalValidate(methodVisitor);
                items.addAll(methodVisitor.getMethodInfos().stream().map(methodInfo -> CompletionItemTransformer.transform(methodInfo, "5/")).collect(Collectors.toList()));
            }
        });
        return items;
    }

    static final class MethodVisitor
    extends AstVisitor<AdditionalPassScope> {
        final Collection<MethodInfo> methods = Lists.newArrayList();

        MethodVisitor() {
        }

        Collection<MethodInfo> getMethodInfos() {
            return this.methods;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            MethodInfo methodInfo = node.getMethodInfo();
            if (Locations.isReal(node.getLoc()) && methodInfo.getGenerated().isUserDefined) {
                this.methods.add(methodInfo);
            }
        }
    }
}

