/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.completions.PrefixCompletionActivationStrategy;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;

@Singleton
public class FieldNamesCompletionStrategy
implements CompletionStrategy {
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public FieldNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        ArrayList<CompletionItem> items = Lists.newArrayList();
        optDoc.ifPresent(doc -> {
            PrefixCompletionActivationStrategy strategy = this.factory.createPrefixBasedStrategy((Document)doc, params.getPosition());
            if (strategy.shouldSuggestTopLevel()) {
                FieldVisitor fieldVisitor = new FieldVisitor();
                CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSourceFiles(SourceFile.builder().setBody(doc.getSource()).setKnownName(doc.getUri().toString()).build()).compileByPassValidation(), doc.getUri().toString());
                codeUnit.additionalValidate(fieldVisitor);
                items.addAll(fieldVisitor.getFields().stream().map(field -> CompletionItemTransformer.transform(field, "4/", CompletionItemKind.Field)).collect(Collectors.toList()));
                items.addAll(fieldVisitor.getProperties().stream().map(field -> CompletionItemTransformer.transform(field, "4/", CompletionItemKind.Property)).collect(Collectors.toList()));
            }
        });
        return items;
    }

    static final class FieldVisitor
    extends AstVisitor<AdditionalPassScope> {
        final Set<FieldInfo> fieldNames = Sets.newTreeSet(Comparator.comparing(Member::getName));
        final Set<FieldInfo> propertyNames = Sets.newTreeSet(Comparator.comparing(Member::getName));

        FieldVisitor() {
        }

        Collection<FieldInfo> getProperties() {
            return this.propertyNames;
        }

        public Collection<FieldInfo> getFields() {
            return Sets.difference(this.fieldNames, this.propertyNames);
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(Property node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            this.propertyNames.add(node.getFieldInfo());
        }

        @Override
        public void visitEnd(Field node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            this.fieldNames.add(node.getFieldInfo());
        }
    }
}

