/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApexCompletionStrategyAggregator
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ApexCompletionStrategyAggregator.class);
    private final Set<CompletionStrategy> strategies;

    @Inject
    public ApexCompletionStrategyAggregator(Set<CompletionStrategy> completionStrategies) {
        this.strategies = completionStrategies;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<CompletionItem> items = Lists.newArrayList();
        for (CompletionStrategy strategy : this.strategies) {
            try {
                items.addAll(strategy.provideCompletions(params));
            }
            catch (Exception e) {
                logger.error(String.format("Encountered an error with strategy %s", strategy), (Throwable)e);
            }
        }
        stopwatch.stop();
        logger.info("Completions for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return items;
    }
}

