/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp;

import apex.jorje.lsp.api.connection.ConnectionStreamProvider;
import apex.jorje.lsp.impl.debug.DebugOptions;
import apex.jorje.lsp.impl.injection.ApexLanguageServerModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexLanguageServerLauncher
implements Provider<LanguageClient> {
    private static final Logger logger = LoggerFactory.getLogger(ApexLanguageServerLauncher.class);
    private static final Function<MessageConsumer, MessageConsumer> CONSUMER_WRAPPER = consumer -> {
        MessageConsumer result = consumer;
        if (DebugOptions.shouldTraceProtocol()) {
            result = message -> {
                logger.info(String.valueOf(message));
                consumer.consume(message);
            };
        }
        return result;
    };
    private static LanguageClient client;

    public static void main(String[] args) {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{new ApexLanguageServerModule()});
            LanguageServer languageServer = (LanguageServer)injector.getInstance(LanguageServer.class);
            ConnectionStreamProvider streamProvider = (ConnectionStreamProvider)injector.getInstance(ConnectionStreamProvider.class);
            Provider executorServiceProvider = injector.getProvider(ExecutorService.class);
            ApexLanguageServerLauncher.launch(languageServer, streamProvider, (Provider<ExecutorService>)executorServiceProvider);
        }
        catch (IOException ioe) {
            logger.error("Failed to connect to language server protocol", (Throwable)ioe);
        }
    }

    private static void launch(LanguageServer languageServer, ConnectionStreamProvider streamProvider, Provider<ExecutorService> executorServiceProvider) throws IOException {
        streamProvider.initialize();
        Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)languageServer, (InputStream)streamProvider.getInputStream(), (OutputStream)streamProvider.getOutputStream(), (ExecutorService)((ExecutorService)executorServiceProvider.get()), CONSUMER_WRAPPER);
        client = (LanguageClient)launcher.getRemoteProxy();
        logger.info("Starting Apex Language Server Protocol");
        launcher.startListening();
    }

    public LanguageClient get() {
        return client;
    }
}

