/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Case;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ElseBlock;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.FinallyBlock;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.data.soql.FieldIdentifier;
import java.util.List;
import java.util.Optional;

public abstract class Stmnt {
    private Stmnt() {
    }

    public static final Stmnt _BlockStmnt(Location loc, List<Stmnt> stmnts) {
        return new BlockStmnt(loc, stmnts);
    }

    public static final Stmnt _ExpressionStmnt(Location loc, Expr expr) {
        return new ExpressionStmnt(loc, expr);
    }

    public static final Stmnt _ReturnStmnt(Location loc, Optional<Expr> expr) {
        return new ReturnStmnt(loc, expr);
    }

    public static final Stmnt _ThrowStmnt(Location loc, Expr expr) {
        return new ThrowStmnt(loc, expr);
    }

    public static final Stmnt _BreakStmnt(Location loc) {
        return new BreakStmnt(loc);
    }

    public static final Stmnt _ContinueStmnt(Location loc) {
        return new ContinueStmnt(loc);
    }

    public static final Stmnt _DmlInsertStmnt(Location loc, Expr expr) {
        return new DmlInsertStmnt(loc, expr);
    }

    public static final Stmnt _DmlUpdateStmnt(Location loc, Expr expr) {
        return new DmlUpdateStmnt(loc, expr);
    }

    public static final Stmnt _DmlUpsertStmnt(Location loc, Expr expr, Optional<FieldIdentifier> id) {
        return new DmlUpsertStmnt(loc, expr, id);
    }

    public static final Stmnt _DmlDeleteStmnt(Location loc, Expr expr) {
        return new DmlDeleteStmnt(loc, expr);
    }

    public static final Stmnt _DmlUndeleteStmnt(Location loc, Expr expr) {
        return new DmlUndeleteStmnt(loc, expr);
    }

    public static final Stmnt _DmlMergeStmnt(Location loc, Expr expr1, Expr expr2) {
        return new DmlMergeStmnt(loc, expr1, expr2);
    }

    public static final Stmnt _WhileLoop(Location loc, Expr condition, Optional<Stmnt> stmnt) {
        return new WhileLoop(loc, condition, stmnt);
    }

    public static final Stmnt _DoLoop(Location loc, Stmnt stmnt, Expr condition) {
        return new DoLoop(loc, stmnt, condition);
    }

    public static final Stmnt _IfElseBlock(List<IfBlock> ifBlocks, Optional<ElseBlock> elseBlock) {
        return new IfElseBlock(ifBlocks, elseBlock);
    }

    public static final Stmnt _RunAsBlock(Location loc, List<Expr> inputParameters, Stmnt stmnt) {
        return new RunAsBlock(loc, inputParameters, stmnt);
    }

    public static final Stmnt _TryCatchFinallyBlock(Location loc, Stmnt tryBlock, List<CatchBlock> catchBlocks, Optional<FinallyBlock> finallyBlock) {
        return new TryCatchFinallyBlock(loc, tryBlock, catchBlocks, finallyBlock);
    }

    public static final Stmnt _VariableDeclStmnt(VariableDecls variableDecls) {
        return new VariableDeclStmnt(variableDecls);
    }

    public static final Stmnt _ForLoop(Location loc, ForControl forControl, Optional<Stmnt> stmnt) {
        return new ForLoop(loc, forControl, stmnt);
    }

    public static final Stmnt _SwitchStatement(Location loc, Expr computation, List<Case> cases) {
        return new SwitchStatement(loc, computation, cases);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class SwitchStatement
    extends Stmnt {
        public Location loc;
        public Expr computation;
        public List<Case> cases;

        public SwitchStatement(Location loc, Expr computation, List<Case> cases) {
            this.loc = loc;
            this.computation = computation;
            this.cases = cases;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.computation == null ? 0 : this.computation.hashCode());
            result = 31 * result + (this.cases == null ? 0 : this.cases.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SwitchStatement other = (SwitchStatement)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.computation == null ? other.computation != null : !this.computation.equals(other.computation)) {
                return false;
            }
            return !(this.cases == null ? other.cases != null : !this.cases.equals(other.cases));
        }

        public String toString() {
            return "SwitchStatement(loc = " + this.loc + ", computation = " + this.computation + ", cases = " + this.cases + ")";
        }
    }

    public static final class ForLoop
    extends Stmnt {
        public Location loc;
        public ForControl forControl;
        public Optional<Stmnt> stmnt;

        public ForLoop(Location loc, ForControl forControl, Optional<Stmnt> stmnt) {
            this.loc = loc;
            this.forControl = forControl;
            this.stmnt = stmnt;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.forControl == null ? 0 : this.forControl.hashCode());
            result = 31 * result + (this.stmnt == null ? 0 : this.stmnt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForLoop other = (ForLoop)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.forControl == null ? other.forControl != null : !this.forControl.equals(other.forControl)) {
                return false;
            }
            return !(this.stmnt == null ? other.stmnt != null : !this.stmnt.equals(other.stmnt));
        }

        public String toString() {
            return "ForLoop(loc = " + this.loc + ", forControl = " + this.forControl + ", stmnt = " + this.stmnt + ")";
        }
    }

    public static final class VariableDeclStmnt
    extends Stmnt {
        public VariableDecls variableDecls;

        public VariableDeclStmnt(VariableDecls variableDecls) {
            this.variableDecls = variableDecls;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.variableDecls == null ? 0 : this.variableDecls.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VariableDeclStmnt other = (VariableDeclStmnt)obj;
            return !(this.variableDecls == null ? other.variableDecls != null : !this.variableDecls.equals(other.variableDecls));
        }

        public String toString() {
            return "VariableDeclStmnt(variableDecls = " + this.variableDecls + ")";
        }
    }

    public static final class TryCatchFinallyBlock
    extends Stmnt {
        public Location loc;
        public Stmnt tryBlock;
        public List<CatchBlock> catchBlocks;
        public Optional<FinallyBlock> finallyBlock;

        public TryCatchFinallyBlock(Location loc, Stmnt tryBlock, List<CatchBlock> catchBlocks, Optional<FinallyBlock> finallyBlock) {
            this.loc = loc;
            this.tryBlock = tryBlock;
            this.catchBlocks = catchBlocks;
            this.finallyBlock = finallyBlock;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.tryBlock == null ? 0 : this.tryBlock.hashCode());
            result = 31 * result + (this.catchBlocks == null ? 0 : this.catchBlocks.hashCode());
            result = 31 * result + (this.finallyBlock == null ? 0 : this.finallyBlock.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TryCatchFinallyBlock other = (TryCatchFinallyBlock)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.tryBlock == null ? other.tryBlock != null : !this.tryBlock.equals(other.tryBlock)) {
                return false;
            }
            if (this.catchBlocks == null ? other.catchBlocks != null : !this.catchBlocks.equals(other.catchBlocks)) {
                return false;
            }
            return !(this.finallyBlock == null ? other.finallyBlock != null : !this.finallyBlock.equals(other.finallyBlock));
        }

        public String toString() {
            return "TryCatchFinallyBlock(loc = " + this.loc + ", tryBlock = " + this.tryBlock + ", catchBlocks = " + this.catchBlocks + ", finallyBlock = " + this.finallyBlock + ")";
        }
    }

    public static final class RunAsBlock
    extends Stmnt {
        public Location loc;
        public List<Expr> inputParameters;
        public Stmnt stmnt;

        public RunAsBlock(Location loc, List<Expr> inputParameters, Stmnt stmnt) {
            this.loc = loc;
            this.inputParameters = inputParameters;
            this.stmnt = stmnt;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.inputParameters == null ? 0 : this.inputParameters.hashCode());
            result = 31 * result + (this.stmnt == null ? 0 : this.stmnt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RunAsBlock other = (RunAsBlock)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.inputParameters == null ? other.inputParameters != null : !this.inputParameters.equals(other.inputParameters)) {
                return false;
            }
            return !(this.stmnt == null ? other.stmnt != null : !this.stmnt.equals(other.stmnt));
        }

        public String toString() {
            return "RunAsBlock(loc = " + this.loc + ", inputParameters = " + this.inputParameters + ", stmnt = " + this.stmnt + ")";
        }
    }

    public static final class IfElseBlock
    extends Stmnt {
        public List<IfBlock> ifBlocks;
        public Optional<ElseBlock> elseBlock;

        public IfElseBlock(List<IfBlock> ifBlocks, Optional<ElseBlock> elseBlock) {
            this.ifBlocks = ifBlocks;
            this.elseBlock = elseBlock;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ifBlocks == null ? 0 : this.ifBlocks.hashCode());
            result = 31 * result + (this.elseBlock == null ? 0 : this.elseBlock.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IfElseBlock other = (IfElseBlock)obj;
            if (this.ifBlocks == null ? other.ifBlocks != null : !this.ifBlocks.equals(other.ifBlocks)) {
                return false;
            }
            return !(this.elseBlock == null ? other.elseBlock != null : !this.elseBlock.equals(other.elseBlock));
        }

        public String toString() {
            return "IfElseBlock(ifBlocks = " + this.ifBlocks + ", elseBlock = " + this.elseBlock + ")";
        }
    }

    public static final class DoLoop
    extends Stmnt {
        public Location loc;
        public Stmnt stmnt;
        public Expr condition;

        public DoLoop(Location loc, Stmnt stmnt, Expr condition) {
            this.loc = loc;
            this.stmnt = stmnt;
            this.condition = condition;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.stmnt == null ? 0 : this.stmnt.hashCode());
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DoLoop other = (DoLoop)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.stmnt == null ? other.stmnt != null : !this.stmnt.equals(other.stmnt)) {
                return false;
            }
            return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
        }

        public String toString() {
            return "DoLoop(loc = " + this.loc + ", stmnt = " + this.stmnt + ", condition = " + this.condition + ")";
        }
    }

    public static final class WhileLoop
    extends Stmnt {
        public Location loc;
        public Expr condition;
        public Optional<Stmnt> stmnt;

        public WhileLoop(Location loc, Expr condition, Optional<Stmnt> stmnt) {
            this.loc = loc;
            this.condition = condition;
            this.stmnt = stmnt;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
            result = 31 * result + (this.stmnt == null ? 0 : this.stmnt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WhileLoop other = (WhileLoop)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
                return false;
            }
            return !(this.stmnt == null ? other.stmnt != null : !this.stmnt.equals(other.stmnt));
        }

        public String toString() {
            return "WhileLoop(loc = " + this.loc + ", condition = " + this.condition + ", stmnt = " + this.stmnt + ")";
        }
    }

    public static final class DmlMergeStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr1;
        public Expr expr2;

        public DmlMergeStmnt(Location loc, Expr expr1, Expr expr2) {
            this.loc = loc;
            this.expr1 = expr1;
            this.expr2 = expr2;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr1 == null ? 0 : this.expr1.hashCode());
            result = 31 * result + (this.expr2 == null ? 0 : this.expr2.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlMergeStmnt other = (DmlMergeStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr1 == null ? other.expr1 != null : !this.expr1.equals(other.expr1)) {
                return false;
            }
            return !(this.expr2 == null ? other.expr2 != null : !this.expr2.equals(other.expr2));
        }

        public String toString() {
            return "DmlMergeStmnt(loc = " + this.loc + ", expr1 = " + this.expr1 + ", expr2 = " + this.expr2 + ")";
        }
    }

    public static final class DmlUndeleteStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public DmlUndeleteStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlUndeleteStmnt other = (DmlUndeleteStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "DmlUndeleteStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class DmlDeleteStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public DmlDeleteStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlDeleteStmnt other = (DmlDeleteStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "DmlDeleteStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class DmlUpsertStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;
        public Optional<FieldIdentifier> id;

        public DmlUpsertStmnt(Location loc, Expr expr, Optional<FieldIdentifier> id) {
            this.loc = loc;
            this.expr = expr;
            this.id = id;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlUpsertStmnt other = (DmlUpsertStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.expr == null ? other.expr != null : !this.expr.equals(other.expr)) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return "DmlUpsertStmnt(loc = " + this.loc + ", expr = " + this.expr + ", id = " + this.id + ")";
        }
    }

    public static final class DmlUpdateStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public DmlUpdateStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlUpdateStmnt other = (DmlUpdateStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "DmlUpdateStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class DmlInsertStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public DmlInsertStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DmlInsertStmnt other = (DmlInsertStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "DmlInsertStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class ContinueStmnt
    extends Stmnt {
        public Location loc;

        public ContinueStmnt(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContinueStmnt other = (ContinueStmnt)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "ContinueStmnt(loc = " + this.loc + ")";
        }
    }

    public static final class BreakStmnt
    extends Stmnt {
        public Location loc;

        public BreakStmnt(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BreakStmnt other = (BreakStmnt)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "BreakStmnt(loc = " + this.loc + ")";
        }
    }

    public static final class ThrowStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public ThrowStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ThrowStmnt other = (ThrowStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "ThrowStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class ReturnStmnt
    extends Stmnt {
        public Location loc;
        public Optional<Expr> expr;

        public ReturnStmnt(Location loc, Optional<Expr> expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReturnStmnt other = (ReturnStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "ReturnStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class ExpressionStmnt
    extends Stmnt {
        public Location loc;
        public Expr expr;

        public ExpressionStmnt(Location loc, Expr expr) {
            this.loc = loc;
            this.expr = expr;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.expr == null ? 0 : this.expr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpressionStmnt other = (ExpressionStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.expr == null ? other.expr != null : !this.expr.equals(other.expr));
        }

        public String toString() {
            return "ExpressionStmnt(loc = " + this.loc + ", expr = " + this.expr + ")";
        }
    }

    public static final class BlockStmnt
    extends Stmnt {
        public Location loc;
        public List<Stmnt> stmnts;

        public BlockStmnt(Location loc, List<Stmnt> stmnts) {
            this.loc = loc;
            this.stmnts = stmnts;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.stmnts == null ? 0 : this.stmnts.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockStmnt other = (BlockStmnt)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.stmnts == null ? other.stmnts != null : !this.stmnts.equals(other.stmnts));
        }

        public String toString() {
            return "BlockStmnt(loc = " + this.loc + ", stmnts = " + this.stmnts + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(BlockStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(ExpressionStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(ReturnStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(ThrowStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(BreakStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(ContinueStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlInsertStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlUpdateStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlUpsertStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlDeleteStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlUndeleteStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(DmlMergeStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(WhileLoop x) {
            this._default(x);
        }

        @Override
        public void _case(DoLoop x) {
            this._default(x);
        }

        @Override
        public void _case(IfElseBlock x) {
            this._default(x);
        }

        @Override
        public void _case(RunAsBlock x) {
            this._default(x);
        }

        @Override
        public void _case(TryCatchFinallyBlock x) {
            this._default(x);
        }

        @Override
        public void _case(VariableDeclStmnt x) {
            this._default(x);
        }

        @Override
        public void _case(ForLoop x) {
            this._default(x);
        }

        @Override
        public void _case(SwitchStatement x) {
            this._default(x);
        }

        protected abstract void _default(Stmnt var1);
    }

    public static interface SwitchBlock {
        public void _case(BlockStmnt var1);

        public void _case(ExpressionStmnt var1);

        public void _case(ReturnStmnt var1);

        public void _case(ThrowStmnt var1);

        public void _case(BreakStmnt var1);

        public void _case(ContinueStmnt var1);

        public void _case(DmlInsertStmnt var1);

        public void _case(DmlUpdateStmnt var1);

        public void _case(DmlUpsertStmnt var1);

        public void _case(DmlDeleteStmnt var1);

        public void _case(DmlUndeleteStmnt var1);

        public void _case(DmlMergeStmnt var1);

        public void _case(WhileLoop var1);

        public void _case(DoLoop var1);

        public void _case(IfElseBlock var1);

        public void _case(RunAsBlock var1);

        public void _case(TryCatchFinallyBlock var1);

        public void _case(VariableDeclStmnt var1);

        public void _case(ForLoop var1);

        public void _case(SwitchStatement var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(BlockStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ExpressionStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ReturnStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ThrowStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(BreakStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ContinueStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlInsertStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlUpdateStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlUpsertStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlDeleteStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlUndeleteStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DmlMergeStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(WhileLoop x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(DoLoop x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IfElseBlock x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(RunAsBlock x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(TryCatchFinallyBlock x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(VariableDeclStmnt x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(ForLoop x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(SwitchStatement x) {
            return this._default(x);
        }

        protected abstract ResultType _default(Stmnt var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(BlockStmnt var1);

        public ResultType _case(ExpressionStmnt var1);

        public ResultType _case(ReturnStmnt var1);

        public ResultType _case(ThrowStmnt var1);

        public ResultType _case(BreakStmnt var1);

        public ResultType _case(ContinueStmnt var1);

        public ResultType _case(DmlInsertStmnt var1);

        public ResultType _case(DmlUpdateStmnt var1);

        public ResultType _case(DmlUpsertStmnt var1);

        public ResultType _case(DmlDeleteStmnt var1);

        public ResultType _case(DmlUndeleteStmnt var1);

        public ResultType _case(DmlMergeStmnt var1);

        public ResultType _case(WhileLoop var1);

        public ResultType _case(DoLoop var1);

        public ResultType _case(IfElseBlock var1);

        public ResultType _case(RunAsBlock var1);

        public ResultType _case(TryCatchFinallyBlock var1);

        public ResultType _case(VariableDeclStmnt var1);

        public ResultType _case(ForLoop var1);

        public ResultType _case(SwitchStatement var1);
    }
}

