/*
 * Decompiled with CFR 0.152.
 */
package apex.common.base;

import apex.common.base.ToLowerCaseFast;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class MoreStrings {
    public static final Collector<CharSequence, ?, String> ON_COMMA = Collectors.joining(",");
    public static final Collector<CharSequence, ?, String> ON_NEW_LINE = Collectors.joining("\n");
    public static final Collector<CharSequence, ?, String> ON_COMMA_AND_SPACE = Collectors.joining(", ");
    public static final Collector<CharSequence, ?, String> ON_COLON = Collectors.joining(":");
    public static final Collector<CharSequence, ?, String> ON_COMMA_ENCLOSING_PARENTHESISES = Collectors.joining(", ", "(", ")");
    public static final Collector<CharSequence, ?, String> ON_COMMA_ENCLOSING_CURLY_BRACES = Collectors.joining(", ", "{", "}");

    private MoreStrings() {
    }

    public static String toLowerCase(String string) {
        int length;
        block4: {
            length = string.length();
            for (int firstUpper = 0; firstUpper < length; ++firstUpper) {
                char c = string.charAt(firstUpper);
                if (ToLowerCaseFast.get().canBeFastLowerCased(c) && c == ToLowerCaseFast.get().toLowerCase(c)) {
                    continue;
                }
                break block4;
            }
            return string;
        }
        char[] charArray = string.toCharArray();
        for (int i = firstUpper; i < length; ++i) {
            if (!ToLowerCaseFast.get().canBeFastLowerCased(charArray[i])) {
                return string.toLowerCase();
            }
            charArray[i] = ToLowerCaseFast.get().toLowerCase(charArray[i]);
        }
        return new String(charArray);
    }

    public static boolean isLowerCase(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isAlphabetic(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public static int lowerCaseHashCode(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < value.length(); ++i) {
            hash = 31 * hash + ToLowerCaseFast.get().toLowerCase(value.charAt(i));
        }
        return hash;
    }

    public static boolean equalsIgnoreCase(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null || left.length() != right.length()) {
            return false;
        }
        int index = left.length();
        while (--index > -1) {
            if (ToLowerCaseFast.get().toLowerCase(left.charAt(index)) == ToLowerCaseFast.get().toLowerCase(right.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(String string, String prefix) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        return string != null && string.startsWith(prefix);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        return MoreStrings.startsWithIgnoreCase(string, prefix, 0);
    }

    public static boolean startsWithIgnoreCase(String string, String prefix, int offset) {
        Objects.requireNonNull(prefix, "prefix must be non null");
        if (string == null) {
            return false;
        }
        int stringOffset = offset;
        int prefixOffset = 0;
        int prefixLength = prefix.length();
        if (offset < 0 || offset > string.length() - prefixLength) {
            return false;
        }
        while (--prefixLength >= 0) {
            if (ToLowerCaseFast.get().toLowerCase(string.charAt(stringOffset++)) == ToLowerCaseFast.get().toLowerCase(prefix.charAt(prefixOffset++))) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(String string, String suffix) {
        Objects.requireNonNull(suffix, "suffix must be non null");
        return string != null && string.endsWith(suffix);
    }

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        Objects.requireNonNull(suffix, "suffix must be non null");
        return string != null && MoreStrings.startsWithIgnoreCase(string, suffix, string.length() - suffix.length());
    }
}

