/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.data.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.FieldDeclaration;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlDeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlInsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlMergeStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUndeleteStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpdateStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDmlUpsertStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTNewKeyValueObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;

public final class Helper {
    static final String ANY_METHOD = "*";

    private Helper() {
        throw new AssertionError((Object)"Can't instantiate helper classes");
    }

    static boolean isTestMethodOrClass(ApexNode<?> node) {
        List modifierNode = node.findChildrenOfType(ASTModifierNode.class);
        for (ASTModifierNode m : modifierNode) {
            if (!((ModifierNode)m.getNode()).getModifiers().isTest()) continue;
            return true;
        }
        String className = node.getNode().getDefiningType().getApexName();
        return className.endsWith("Test");
    }

    static boolean foundAnySOQLorSOSL(ApexNode<?> node) {
        List dmlSoqlExpression = node.findDescendantsOfType(ASTSoqlExpression.class);
        List dmlSoslExpression = node.findDescendantsOfType(ASTSoslExpression.class);
        return !dmlSoqlExpression.isEmpty() || !dmlSoslExpression.isEmpty();
    }

    static boolean foundAnyDML(ApexNode<?> node) {
        List dmlUpsertStatement = node.findDescendantsOfType(ASTDmlUpsertStatement.class);
        List dmlUpdateStatement = node.findDescendantsOfType(ASTDmlUpdateStatement.class);
        List dmlUndeleteStatement = node.findDescendantsOfType(ASTDmlUndeleteStatement.class);
        List dmlMergeStatement = node.findDescendantsOfType(ASTDmlMergeStatement.class);
        List dmlInsertStatement = node.findDescendantsOfType(ASTDmlInsertStatement.class);
        List dmlDeleteStatement = node.findDescendantsOfType(ASTDmlDeleteStatement.class);
        return !dmlUpsertStatement.isEmpty() || !dmlUpdateStatement.isEmpty() || !dmlUndeleteStatement.isEmpty() || !dmlMergeStatement.isEmpty() || !dmlInsertStatement.isEmpty() || !dmlDeleteStatement.isEmpty();
    }

    static boolean isMethodName(ASTMethodCallExpression methodNode, String className, String methodName) {
        ASTReferenceExpression reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class);
        return reference != null && ((ReferenceExpression)reference.getNode()).getNames().size() == 1 && ((Identifier)((ReferenceExpression)reference.getNode()).getNames().get(0)).getValue().equalsIgnoreCase(className) && (methodName.equals(ANY_METHOD) || Helper.isMethodName(methodNode, methodName));
    }

    static boolean isMethodName(ASTMethodCallExpression m, String methodName) {
        return Helper.isMethodName((MethodCallExpression)m.getNode(), methodName);
    }

    static boolean isMethodName(MethodCallExpression m, String methodName) {
        return m.getMethodName().equalsIgnoreCase(methodName);
    }

    static boolean isMethodCallChain(ASTMethodCallExpression methodNode, String ... methodNames) {
        ASTReferenceExpression reference;
        String methodName = methodNames[methodNames.length - 1];
        if (Helper.isMethodName(methodNode, methodName) && (reference = (ASTReferenceExpression)methodNode.getFirstChildOfType(ASTReferenceExpression.class)) != null) {
            ASTMethodCallExpression nestedMethod = (ASTMethodCallExpression)reference.getFirstChildOfType(ASTMethodCallExpression.class);
            if (nestedMethod != null) {
                String[] newMethodNames = Arrays.copyOf(methodNames, methodNames.length - 1);
                return Helper.isMethodCallChain(nestedMethod, newMethodNames);
            }
            String[] newClassName = Arrays.copyOf(methodNames, methodNames.length - 1);
            if (newClassName.length == 1) {
                return Helper.isMethodName(methodNode, newClassName[0], methodName);
            }
        }
        return false;
    }

    static String getFQVariableName(ASTVariableExpression variable) {
        ASTReferenceExpression ref = (ASTReferenceExpression)variable.getFirstChildOfType(ASTReferenceExpression.class);
        String objectName = "";
        if (ref != null && ((ReferenceExpression)ref.getNode()).getNames().size() == 1) {
            objectName = ((Identifier)((ReferenceExpression)ref.getNode()).getNames().get(0)).getValue() + ".";
        }
        VariableExpression n = (VariableExpression)variable.getNode();
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(objectName).append(n.getIdentifier().getValue());
        return sb.toString();
    }

    static String getFQVariableName(ASTVariableDeclaration variable) {
        VariableDeclaration n = (VariableDeclaration)variable.getNode();
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(n.getLocalInfo().getName());
        return sb.toString();
    }

    static String getFQVariableName(ASTField variable) {
        apex.jorje.semantic.ast.member.Field n = (apex.jorje.semantic.ast.member.Field)variable.getNode();
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(n.getFieldInfo().getName());
        return sb.toString();
    }

    static String getVariableType(ASTField variable) {
        apex.jorje.semantic.ast.member.Field n = (apex.jorje.semantic.ast.member.Field)variable.getNode();
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(n.getFieldInfo().getName());
        return sb.toString();
    }

    static String getFQVariableName(ASTFieldDeclaration variable) {
        FieldDeclaration n = (FieldDeclaration)variable.getNode();
        String name = "";
        try {
            Field f = n.getClass().getDeclaredField("name");
            f.setAccessible(true);
            Identifier nameField = (Identifier)f.get(n);
            name = nameField.getValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(name);
        return sb.toString();
    }

    static String getFQVariableName(ASTNewKeyValueObjectExpression variable) {
        NewKeyValueObjectExpression n = (NewKeyValueObjectExpression)variable.getNode();
        TypeRef typeRef = n.getTypeRef();
        String objType = ((Identifier)typeRef.getNames().get(0)).getValue();
        StringBuilder sb = new StringBuilder().append(n.getDefiningType().getApexName()).append(":").append(objType);
        return sb.toString();
    }

    static boolean isSystemLevelClass(ASTUserClass node) {
        List interfaces = ((UserClass)node.getNode()).getDefiningType().getCodeUnitDetails().getInterfaceTypeRefs();
        for (TypeRef intObject : interfaces) {
            if (!Helper.isWhitelisted(intObject.getNames())) continue;
            return true;
        }
        return false;
    }

    private static boolean isWhitelisted(List<Identifier> ids) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(ids.get(i).getValue());
            if (i == ids.size() - 1) continue;
            sb.append(".");
        }
        switch (sb.toString().toLowerCase(Locale.ROOT)) {
            case "queueable": 
            case "database.batchable": 
            case "installhandler": {
                return true;
            }
        }
        return false;
    }

    public static String getFQVariableName(Parameter p) {
        StringBuffer sb = new StringBuffer();
        sb.append(p.getDefiningType()).append(":").append(p.getName().getValue());
        return sb.toString();
    }
}

