/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.expression.LiteralExpression;
import java.util.List;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexXSSFromEscapeFalseRule
extends AbstractApexRule {
    private static final String ADD_ERROR = "addError";

    public ApexXSSFromEscapeFalseRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        List methodCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression methodCall : methodCalls) {
            if (!Helper.isMethodName(methodCall, ADD_ERROR)) continue;
            this.validateBooleanParameter(methodCall, data);
        }
        return data;
    }

    private void validateBooleanParameter(ASTMethodCallExpression methodCall, Object data) {
        Boolean paramValue;
        ASTLiteralExpression parameter;
        Object o;
        Node potentialLiteral;
        int numberOfChildren = methodCall.jjtGetNumChildren();
        if (numberOfChildren == 3 && (potentialLiteral = methodCall.jjtGetChild(2)) instanceof ASTLiteralExpression && (o = ((LiteralExpression)(parameter = (ASTLiteralExpression)potentialLiteral).getNode()).getLiteral()) instanceof Boolean && (paramValue = (Boolean)o).equals(Boolean.FALSE)) {
            this.validateLiteralPresence(methodCall, data);
        }
    }

    private void validateLiteralPresence(ASTMethodCallExpression methodCall, Object data) {
        List variables = methodCall.findDescendantsOfType(ASTVariableExpression.class);
        for (ASTVariableExpression v : variables) {
            this.addViolation(data, v);
        }
    }
}

