/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.expression.LiteralExpression;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexInsecureEndpointRule
extends AbstractApexRule {
    private static final String SET_ENDPOINT = "setEndpoint";
    private static final Pattern PATTERN = Pattern.compile("^http://.+?$", 2);
    private final Set<String> httpEndpointStrings = new HashSet<String>();

    public ApexInsecureEndpointRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTAssignmentExpression node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.findInsecureEndpoints(node);
        return data;
    }

    private void findInsecureEndpoints(AbstractApexNode<?> node) {
        ASTVariableExpression variableNode = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        this.findInnerInsecureEndpoints(node, variableNode);
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.findInnerInsecureEndpoints(binaryNode, variableNode);
        }
    }

    private void findInnerInsecureEndpoints(AbstractApexNode<?> node, ASTVariableExpression variableNode) {
        String literal;
        Object o;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        if (literalNode != null && variableNode != null && (o = ((LiteralExpression)literalNode.getNode()).getLiteral()) instanceof String && PATTERN.matcher(literal = (String)o).matches()) {
            this.httpEndpointStrings.add(Helper.getFQVariableName(variableNode));
        }
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        this.processInsecureEndpoint(node, data);
        return data;
    }

    private void processInsecureEndpoint(ASTMethodCallExpression node, Object data) {
        if (!Helper.isMethodName(node, SET_ENDPOINT)) {
            return;
        }
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.runChecks(binaryNode, data);
        }
        this.runChecks(node, data);
    }

    private void runChecks(AbstractApexNode<?> node, Object data) {
        ASTVariableExpression variableNode;
        String literal;
        Object o;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        if (literalNode != null && (o = ((LiteralExpression)literalNode.getNode()).getLiteral()) instanceof String && PATTERN.matcher(literal = (String)o).matches()) {
            this.addViolation(data, literalNode);
        }
        if ((variableNode = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class)) != null && this.httpEndpointStrings.contains(Helper.getFQVariableName(variableNode))) {
            this.addViolation(data, variableNode);
        }
    }
}

