/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import java.util.Stack;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserTrigger;
import net.sourceforge.pmd.lang.apex.metrics.ApexMetrics;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexClassMetricKey;
import net.sourceforge.pmd.lang.apex.metrics.api.ApexOperationMetricKey;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class CyclomaticComplexityRule
extends AbstractApexRule {
    private static final IntegerProperty CLASS_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"classReportLevel").desc("Total class complexity reporting threshold")).range((Object)1, (Object)200)).defaultValue((Object)40)).uiOrder(1.0f)).build();
    private static final IntegerProperty METHOD_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"methodReportLevel").desc("Cyclomatic complexity reporting threshold")).range((Object)1, (Object)30)).defaultValue((Object)10)).uiOrder(2.0f)).build();
    private Stack<String> classNames = new Stack();
    private boolean inTrigger;

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)METHOD_LEVEL_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTUserTrigger node, Object data) {
        this.inTrigger = true;
        super.visit(node, data);
        this.inTrigger = false;
        return data;
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        int classWmc;
        this.classNames.push(node.getImage());
        super.visit(node, data);
        this.classNames.pop();
        if (ApexClassMetricKey.WMC.supports(node) && (classWmc = (int)ApexMetrics.get(ApexClassMetricKey.WMC, node)) >= (Integer)this.getProperty((PropertyDescriptor)CLASS_LEVEL_DESCRIPTOR)) {
            int classHighest = (int)ApexMetrics.get((MetricKey<ASTMethod>)ApexOperationMetricKey.CYCLO, node, ResultOption.HIGHEST);
            Object[] messageParams = new String[]{"class", node.getImage(), " total", classWmc + " (highest " + classHighest + ")"};
            this.addViolation(data, node, messageParams);
        }
        return data;
    }

    @Override
    public final Object visit(ASTMethod node, Object data) {
        int cyclo = (int)ApexMetrics.get(ApexOperationMetricKey.CYCLO, node);
        if (cyclo >= (Integer)this.getProperty((PropertyDescriptor)METHOD_LEVEL_DESCRIPTOR)) {
            String opType = this.inTrigger ? "trigger" : (node.getImage().equals(this.classNames.peek()) ? "constructor" : "method");
            this.addViolation(data, node, new String[]{opType, node.getQualifiedName().getOperation(), "", "" + cyclo});
        }
        return data;
    }
}

