/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.compilation.UserInterface;
import java.lang.reflect.Field;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.apex.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClassOrInterface;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitor;
import net.sourceforge.pmd.lang.apex.ast.ApexQualifiedName;
import net.sourceforge.pmd.lang.apex.ast.ApexRootNode;
import net.sourceforge.pmd.lang.apex.ast.CanSuppressWarnings;

public class ASTUserInterface
extends ApexRootNode<UserInterface>
implements ASTUserClassOrInterface<UserInterface>,
CanSuppressWarnings {
    private ApexQualifiedName qname;

    public ASTUserInterface(UserInterface userInterface) {
        super(userInterface);
    }

    @Override
    public Object jjtAccept(ApexParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getImage() {
        try {
            Field field = ((UserInterface)this.node).getClass().getDeclaredField("name");
            field.setAccessible(true);
            Identifier name = (Identifier)field.get(this.node);
            return name.getValue();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ASTUserClassOrInterface.TypeKind getTypeKind() {
        return ASTUserClassOrInterface.TypeKind.INTERFACE;
    }

    @Override
    public ApexQualifiedName getQualifiedName() {
        if (this.qname == null) {
            ASTUserClass parent = (ASTUserClass)this.getFirstParentOfType(ASTUserClass.class);
            this.qname = parent != null ? ApexQualifiedName.ofNestedClass(parent.getQualifiedName(), this) : ApexQualifiedName.ofOuterClass(this);
        }
        return this.qname;
    }

    @Override
    public boolean hasSuppressWarningsAnnotationFor(Rule rule) {
        for (ASTModifierNode modifier : this.findChildrenOfType(ASTModifierNode.class)) {
            for (ASTAnnotation a : modifier.findChildrenOfType(ASTAnnotation.class)) {
                if (!a.suppresses(rule)) continue;
                return true;
            }
        }
        return false;
    }
}

