/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.scene.Node;
import org.fxmisc.flowless.CellWrapper;

@FunctionalInterface
public interface Cell<T, N extends Node> {
    public static <T, N extends Node> Cell<T, N> wrapNode(final N node) {
        return new Cell<T, N>(){

            @Override
            public N getNode() {
                return node;
            }

            public String toString() {
                return node.toString();
            }
        };
    }

    public N getNode();

    default public boolean isReusable() {
        return false;
    }

    default public void updateItem(T item) {
        throw new UnsupportedOperationException();
    }

    default public void updateIndex(int index) {
    }

    default public void reset() {
    }

    default public void dispose() {
    }

    default public Cell<T, N> beforeDispose(Runnable action) {
        return CellWrapper.beforeDispose(this, action);
    }

    default public Cell<T, N> afterDispose(Runnable action) {
        return CellWrapper.afterDispose(this, action);
    }

    default public Cell<T, N> beforeReset(Runnable action) {
        return CellWrapper.beforeReset(this, action);
    }

    default public Cell<T, N> afterReset(Runnable action) {
        return CellWrapper.afterReset(this, action);
    }

    default public Cell<T, N> beforeUpdateItem(Consumer<? super T> action) {
        return CellWrapper.beforeUpdateItem(this, action);
    }

    default public Cell<T, N> afterUpdateItem(Consumer<? super T> action) {
        return CellWrapper.afterUpdateItem(this, action);
    }

    default public Cell<T, N> beforeUpdateIndex(IntConsumer action) {
        return CellWrapper.beforeUpdateIndex(this, action);
    }

    default public Cell<T, N> afterUpdateIndex(IntConsumer action) {
        return CellWrapper.afterUpdateIndex(this, action);
    }
}

