/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSignature;
import net.sourceforge.pmd.lang.java.rule.documentation.AbstractCommentRule;
import net.sourceforge.pmd.properties.EnumeratedProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class CommentRequiredRule
extends AbstractCommentRule {
    private static final Map<String, String> DESCRIPTOR_NAME_TO_COMMENT_TYPE = new HashMap<String, String>();
    private static final EnumeratedProperty<CommentRequirement> ACCESSOR_CMT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("accessorCommentRequirement", "Comments on getters and setters\"").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final EnumeratedProperty<CommentRequirement> OVERRIDE_CMT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("methodWithOverrideCommentRequirement", "Comments on @Override methods").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final EnumeratedProperty<CommentRequirement> HEADER_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("headerCommentRequirement", "Header comments").uiOrder(1.0f)).build();
    private static final EnumeratedProperty<CommentRequirement> FIELD_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("fieldCommentRequirement", "Field comments").uiOrder(2.0f)).build();
    private static final EnumeratedProperty<CommentRequirement> PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("publicMethodCommentRequirement", "Public method and constructor comments").uiOrder(3.0f)).build();
    private static final EnumeratedProperty<CommentRequirement> PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("protectedMethodCommentRequirement", "Protected method constructor comments").uiOrder(4.0f)).build();
    private static final EnumeratedProperty<CommentRequirement> ENUM_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("enumCommentRequirement", "Enum comments").uiOrder(5.0f)).build();
    private static final EnumeratedProperty<CommentRequirement> SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR = ((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)CommentRequiredRule.requirementPropertyBuilder("serialVersionUIDCommentRequired", "Serial version UID comments").defaultValue((Object)CommentRequirement.Ignored)).uiOrder(6.0f)).build();

    public CommentRequiredRule() {
        this.definePropertyDescriptor((PropertyDescriptor)OVERRIDE_CMT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ACCESSOR_CMT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)HEADER_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
    }

    private void checkCommentMeetsRequirement(Object data, AbstractJavaNode node, EnumeratedProperty<CommentRequirement> descriptor) {
        switch ((CommentRequirement)((Object)this.getProperty((PropertyDescriptor)descriptor))) {
            case Ignored: {
                break;
            }
            case Required: {
                if (node.comment() != null) break;
                this.commentRequiredViolation(data, node, descriptor);
                break;
            }
            case Unwanted: {
                if (node.comment() == null) break;
                this.commentRequiredViolation(data, node, descriptor);
                break;
            }
        }
    }

    private void commentRequiredViolation(Object data, AbstractJavaNode node, EnumeratedProperty<CommentRequirement> descriptor) {
        this.addViolationWithMessage(data, (Node)node, DESCRIPTOR_NAME_TO_COMMENT_TYPE.get(descriptor.name()) + " are " + ((CommentRequirement)((Object)this.getProperty((PropertyDescriptor)descriptor))).label.toLowerCase(Locale.ROOT));
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, HEADER_CMT_REQUIREMENT_DESCRIPTOR);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        this.checkMethodOrConstructorComment(decl, data);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.isAnnotatedOverride(decl)) {
            this.checkCommentMeetsRequirement(data, decl, OVERRIDE_CMT_DESCRIPTOR);
        } else if (decl.getSignature().role == JavaOperationSignature.Role.GETTER_OR_SETTER) {
            this.checkCommentMeetsRequirement(data, decl, ACCESSOR_CMT_DESCRIPTOR);
        } else {
            this.checkMethodOrConstructorComment(decl, data);
        }
        return super.visit(decl, data);
    }

    private void checkMethodOrConstructorComment(AbstractJavaAccessNode decl, Object data) {
        if (decl.isPublic()) {
            this.checkCommentMeetsRequirement(data, decl, PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        } else if (decl.isProtected()) {
            this.checkCommentMeetsRequirement(data, decl, PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        }
    }

    private boolean isAnnotatedOverride(ASTMethodDeclaration decl) {
        List annotations = decl.jjtGetParent().findDescendantsOfType(ASTMarkerAnnotation.class);
        for (ASTMarkerAnnotation ann : annotations) {
            if (!((ASTName)ann.getFirstChildOfType(ASTName.class)).getImage().equals("Override")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.isSerialVersionUID(decl)) {
            this.checkCommentMeetsRequirement(data, decl, SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
        } else {
            this.checkCommentMeetsRequirement(data, decl, FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        }
        return super.visit(decl, data);
    }

    private boolean isSerialVersionUID(ASTFieldDeclaration field) {
        return "serialVersionUID".equals(field.getVariableName()) && field.isStatic() && field.isFinal() && field.getType() == Long.TYPE;
    }

    @Override
    public Object visit(ASTEnumDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.assignCommentsToDeclarations(cUnit);
        return super.visit(cUnit, data);
    }

    private boolean allCommentsAreIgnored() {
        return this.getProperty((PropertyDescriptor)OVERRIDE_CMT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)ACCESSOR_CMT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)HEADER_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)FIELD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)ENUM_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty((PropertyDescriptor)SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored;
    }

    public String dysfunctionReason() {
        return this.allCommentsAreIgnored() ? "All comment types are ignored" : null;
    }

    private static EnumeratedProperty.EnumPBuilder<CommentRequirement> requirementPropertyBuilder(String name, String commentType) {
        DESCRIPTOR_NAME_TO_COMMENT_TYPE.put(name, commentType);
        return ((EnumeratedProperty.EnumPBuilder)((EnumeratedProperty.EnumPBuilder)EnumeratedProperty.named((String)name).desc(commentType + ". Possible values: " + CommentRequirement.labels())).mappings(CommentRequirement.mappings()).defaultValue((Object)CommentRequirement.Required)).type(CommentRequirement.class);
    }

    private static enum CommentRequirement {
        Required("Required"),
        Ignored("Ignored"),
        Unwanted("Unwanted");

        private static final List<String> LABELS;
        private static final Map<String, CommentRequirement> MAPPINGS;
        private final String label;

        private CommentRequirement(String theLabel) {
            this.label = theLabel;
        }

        private static List<String> buildValueLabels() {
            ArrayList<String> labels = new ArrayList<String>(CommentRequirement.values().length);
            for (CommentRequirement r : CommentRequirement.values()) {
                labels.add(r.label);
            }
            return Collections.unmodifiableList(labels);
        }

        public static List<String> labels() {
            return LABELS;
        }

        public static Map<String, CommentRequirement> mappings() {
            return MAPPINGS;
        }

        static {
            LABELS = CommentRequirement.buildValueLabels();
            HashMap<String, CommentRequirement> tmp = new HashMap<String, CommentRequirement>();
            for (CommentRequirement r : CommentRequirement.values()) {
                tmp.put(r.label, r);
            }
            MAPPINGS = Collections.unmodifiableMap(tmp);
        }
    }
}

