/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class TooManyFieldsRule
extends AbstractJavaRule {
    private static final int DEFAULT_MAXFIELDS = 15;
    private static final IntegerProperty MAX_FIELDS_DESCRIPTOR = new IntegerProperty("maxfields", "Max allowable fields", Integer.valueOf(1), Integer.valueOf(300), Integer.valueOf(15), 1.0f);

    public TooManyFieldsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)MAX_FIELDS_DESCRIPTOR);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        int maxFields = (Integer)this.getProperty((PropertyDescriptor)MAX_FIELDS_DESCRIPTOR);
        int counter = 0;
        List l = node.findDescendantsOfType(ASTFieldDeclaration.class);
        for (ASTFieldDeclaration fd : l) {
            if (fd.isFinal() && fd.isStatic()) continue;
            ++counter;
        }
        if (counter > maxFields) {
            this.addViolation(data, node);
        }
        return data;
    }
}

