/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class UnnecessaryModifierRule
extends AbstractJavaRule {
    public UnnecessaryModifierRule() {
        this.addRuleChainVisit(ASTEnumDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationTypeDeclaration.class);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
        this.addRuleChainVisit(ASTMethodDeclaration.class);
        this.addRuleChainVisit(ASTResource.class);
        this.addRuleChainVisit(ASTFieldDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationMethodDeclaration.class);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        if (node.isStatic()) {
            this.addViolation(data, node, this.getMessage());
        }
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        boolean isParentInterfaceOrAnnotation;
        if (node.isAbstract()) {
            this.addViolation(data, node, this.getMessage());
        }
        if (!node.isNested()) {
            return data;
        }
        Node parent = node.jjtGetParent().jjtGetParent().jjtGetParent();
        boolean bl = isParentInterfaceOrAnnotation = parent instanceof ASTAnnotationTypeDeclaration || parent instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)parent).isInterface();
        if (node.isPublic() && isParentInterfaceOrAnnotation) {
            this.addViolation(data, node, this.getMessage());
        }
        if (node.isStatic()) {
            this.addViolation(data, node, this.getMessage());
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        boolean isParentInterfaceOrAnnotation;
        if (node.isInterface() && node.isAbstract()) {
            this.addViolation(data, node, this.getMessage());
        }
        if (!node.isNested()) {
            return data;
        }
        Node parent = node.jjtGetParent().jjtGetParent().jjtGetParent();
        boolean bl = isParentInterfaceOrAnnotation = parent instanceof ASTAnnotationTypeDeclaration || parent instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)parent).isInterface();
        if (node.isInterface() && node.isPublic() && isParentInterfaceOrAnnotation) {
            this.addViolation(data, node, this.getMessage());
        }
        if (node.isInterface() && node.isStatic()) {
            this.addViolation(data, node, this.getMessage());
        }
        if (!node.isInterface() && (node.isPublic() || node.isStatic()) && isParentInterfaceOrAnnotation) {
            this.addViolation(data, node, this.getMessage());
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isSyntacticallyPublic() || node.isSyntacticallyAbstract()) {
            this.check(node, data);
        }
        if (node.isFinal() && !this.isSafeVarargs(node)) {
            if (node.isPrivate()) {
                this.addViolation(data, node);
            } else {
                Node n = node.getNthParent(3);
                if (n instanceof ASTAllocationExpression || n instanceof ASTEnumConstant) {
                    this.addViolation(data, node);
                } else if (n instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)n).isFinal()) {
                    this.addViolation(data, node);
                }
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTResource node, Object data) {
        if (node.isFinal()) {
            this.addViolation(data, node);
        }
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (node.isSyntacticallyPublic() || node.isSyntacticallyStatic() || node.isSyntacticallyFinal()) {
            this.check(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTAnnotationMethodDeclaration node, Object data) {
        if (node.isPublic() || node.isAbstract()) {
            this.check(node, data);
        }
        return data;
    }

    private boolean isSafeVarargs(ASTMethodDeclaration node) {
        for (ASTAnnotation annotation : node.jjtGetParent().findChildrenOfType(ASTAnnotation.class)) {
            ASTMarkerAnnotation marker;
            Node childAnnotation = annotation.jjtGetChild(0);
            if (!(childAnnotation instanceof ASTMarkerAnnotation) || (marker = (ASTMarkerAnnotation)childAnnotation).getType() == null || !SafeVarargs.class.isAssignableFrom(marker.getType())) continue;
            return true;
        }
        return false;
    }

    private void check(Node fieldOrMethod, Object data) {
        Node parent = fieldOrMethod.jjtGetParent().jjtGetParent().jjtGetParent();
        if (parent instanceof ASTAnnotationTypeDeclaration || parent instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            this.addViolation(data, fieldOrMethod);
        }
    }
}

