# Generated by Django 2.2.1 on 2019-05-03 09:44

from django.db import migrations
from django.db.models import Count


def fix_primary_emails(apps, schema_editor):
    """
    For all users who only have a single email address, set it as their
    primary.
    """
    EmailAddress = apps.get_model("rest_email_auth", "EmailAddress")

    EmailAddress.objects.annotate(count=Count("user__email_address")).filter(
        count=1
    ).update(is_primary=True)


class Migration(migrations.Migration):

    dependencies = [("rest_email_auth", "0005_passwordresettoken")]

    operations = [
        migrations.RunPython(
            fix_primary_emails, reverse_code=migrations.RunPython.noop
        )
    ]
