"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlSubscription = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
/**
 * Use a URL as a subscription target
 *
 * The message will be POSTed to the given URL.
 *
 * @see https://docs.aws.amazon.com/sns/latest/dg/sns-http-https-endpoint-as-subscriber.html
 */
class UrlSubscription {
    constructor(url, props = {}) {
        this.url = url;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sns_subscriptions_UrlSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.unresolvedUrl = core_1.Token.isUnresolved(url);
        if (!this.unresolvedUrl && !url.startsWith('http://') && !url.startsWith('https://')) {
            throw new Error('URL must start with either http:// or https://');
        }
        if (this.unresolvedUrl && props.protocol === undefined) {
            throw new Error('Must provide protocol if url is unresolved');
        }
        if (this.unresolvedUrl) {
            this.protocol = props.protocol;
        }
        else {
            this.protocol = this.url.startsWith('https:') ? sns.SubscriptionProtocol.HTTPS : sns.SubscriptionProtocol.HTTP;
        }
    }
    /**
     * Returns a configuration for a URL to subscribe to an SNS topic
     */
    bind(_topic) {
        return {
            subscriberId: this.url,
            endpoint: this.url,
            protocol: this.protocol,
            rawMessageDelivery: this.props.rawMessageDelivery,
            filterPolicy: this.props.filterPolicy,
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
}
exports.UrlSubscription = UrlSubscription;
_a = JSII_RTTI_SYMBOL_1;
UrlSubscription[_a] = { fqn: "@aws-cdk/aws-sns-subscriptions.UrlSubscription", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,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