import configparser

class PipfileParser:
    def __init__(self, path_to_pipfile):
        self.path_to_pipfile = path_to_pipfile
        self.parse()

    def parse(self):
        parser = configparser.ConfigParser(strict=False)
        parser.read("Pipfile")

        self.install_requires = list()
        self.dev_requires = list()

        for key in parser["dev-packages"]:
            value = parser["dev-packages"][key]
            value = value.replace("\"", "")
            if value == '*':
                value = ''
            self.dev_requires.append(key+value)

        for key in parser["packages"]:
            value = parser["packages"][key]
            value = value.replace("\"", "")
            if value == '*':
                value = ''
            self.install_requires.append(key+value)
            self.dev_requires.append(key+value)

    def write_requirements_files(self):
        with open("requirements-dev.txt", "w") as f:
            f.write("# DO NOT EDIT: THIS FILE IS AUTOGENERATED BY pipfile_parse.py\n")
            f.write("\n".join(self.dev_requires))


        with open("requirements.txt", "w") as f:
            f.write("# DO NOT EDIT: THIS FILE IS AUTOGENERATED BY pipfile_parse.py\n")
            f.write("\n".join(self.install_requires))
            
    def write_requirements_to_setup_py(self):
        with open('setup.py', 'r') as f:
            setup_lines = f.readlines()

        new_setup_requires_line = (f'    install_requires = {parser.install_requires}, '
                                   '# <-- DO NOT EDIT, THIS LINE IS AUTOGENERATED\n'
                                  )
        
        with open('setup.py', 'w') as f:
            for line in setup_lines:
                if 'install_requires = ' in line:
                    f.write(new_setup_requires_line)
                else:
                    f.write(line)

if __name__ == "__main__":
    parser = PipfileParser('Pipfile')
    parser.write_requirements_files()
    parser.write_requirements_to_setup_py()
