<a id="mypy-boto3-ecr-public"></a>

# mypy-boto3-ecr-public

[![PyPI - mypy-boto3-ecr-public](https://img.shields.io/pypi/v/mypy-boto3-ecr-public.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecr-public)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ecr-public.svg?color=blue)](https://pypi.org/project/mypy-boto3-ecr-public)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-ecr-public?color=blue)](https://pypistats.org/packages/mypy-boto3-ecr-public)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ECRPublic 1.19.10](https://boto3.amazonaws.com/v1/documentation/api/1.19.10/reference/services/ecr-public.html#ECRPublic)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.1.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ecr-public docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecr_public/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ecr-public](#mypy-boto3-ecr-public)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ECRPublic` service.

```bash
python -m pip install boto3-stubs[ecr-public]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ecr-public]` in your environment:
  `python -m pip install 'boto3-stubs[ecr-public]'`

Both type checking and auto-complete should work for `ECRPublic` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ecr-public]` in your environment:
  `python -m pip install 'boto3-stubs[ecr-public]'`

Both type checking and auto-complete should work for `ECRPublic` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ecr-public]` in your environment:
  `python -m pip install 'boto3-stubs[ecr-public]'`
- Run `mypy` as usual

Type checking should work for `ECRPublic` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ecr-public]` in your environment:
  `python -m pip install 'boto3-stubs[ecr-public]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ECRPublic` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ECRPublicClient` provides annotations for `boto3.client("ecr-public")`.

```python
import boto3

from mypy_boto3_ecr_public import ECRPublicClient

client: ECRPublicClient = boto3.client("ecr-public")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ECRPublicClient = session.client("ecr-public")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ecr_public.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_ecr_public import ECRPublicClient
from mypy_boto3_ecr_public.paginator import (
    DescribeImageTagsPaginator,
    DescribeImagesPaginator,
    DescribeRegistriesPaginator,
    DescribeRepositoriesPaginator,
)

client: ECRPublicClient = boto3.client("ecr-public")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_image_tags_paginator: DescribeImageTagsPaginator = client.get_paginator("describe_image_tags")
describe_images_paginator: DescribeImagesPaginator = client.get_paginator("describe_images")
describe_registries_paginator: DescribeRegistriesPaginator = client.get_paginator("describe_registries")
describe_repositories_paginator: DescribeRepositoriesPaginator = client.get_paginator("describe_repositories")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ecr_public.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_ecr_public.literals import (
    DescribeImageTagsPaginatorName,
    DescribeImagesPaginatorName,
    DescribeRegistriesPaginatorName,
    DescribeRepositoriesPaginatorName,
    ImageFailureCodeType,
    LayerAvailabilityType,
    LayerFailureCodeType,
    RegistryAliasStatusType,
    ServiceName,
    PaginatorName,
)

def check_value(value: DescribeImageTagsPaginatorName) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ecr_public.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_ecr_public.type_defs import (
    AuthorizationDataTypeDef,
    BatchCheckLayerAvailabilityRequestRequestTypeDef,
    BatchCheckLayerAvailabilityResponseTypeDef,
    BatchDeleteImageRequestRequestTypeDef,
    BatchDeleteImageResponseTypeDef,
    CompleteLayerUploadRequestRequestTypeDef,
    CompleteLayerUploadResponseTypeDef,
    CreateRepositoryRequestRequestTypeDef,
    CreateRepositoryResponseTypeDef,
    DeleteRepositoryPolicyRequestRequestTypeDef,
    DeleteRepositoryPolicyResponseTypeDef,
    DeleteRepositoryRequestRequestTypeDef,
    DeleteRepositoryResponseTypeDef,
    DescribeImageTagsRequestRequestTypeDef,
    DescribeImageTagsResponseTypeDef,
    DescribeImagesRequestRequestTypeDef,
    DescribeImagesResponseTypeDef,
    DescribeRegistriesRequestRequestTypeDef,
    DescribeRegistriesResponseTypeDef,
    DescribeRepositoriesRequestRequestTypeDef,
    DescribeRepositoriesResponseTypeDef,
    GetAuthorizationTokenResponseTypeDef,
    GetRegistryCatalogDataResponseTypeDef,
    GetRepositoryCatalogDataRequestRequestTypeDef,
    GetRepositoryCatalogDataResponseTypeDef,
    GetRepositoryPolicyRequestRequestTypeDef,
    GetRepositoryPolicyResponseTypeDef,
    ImageDetailTypeDef,
    ImageFailureTypeDef,
    ImageIdentifierTypeDef,
    ImageTagDetailTypeDef,
    ImageTypeDef,
    InitiateLayerUploadRequestRequestTypeDef,
    InitiateLayerUploadResponseTypeDef,
    LayerFailureTypeDef,
    LayerTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PutImageRequestRequestTypeDef,
    PutImageResponseTypeDef,
    PutRegistryCatalogDataRequestRequestTypeDef,
    PutRegistryCatalogDataResponseTypeDef,
    PutRepositoryCatalogDataRequestRequestTypeDef,
    PutRepositoryCatalogDataResponseTypeDef,
    ReferencedImageDetailTypeDef,
    RegistryAliasTypeDef,
    RegistryCatalogDataTypeDef,
    RegistryTypeDef,
    RepositoryCatalogDataInputTypeDef,
    RepositoryCatalogDataTypeDef,
    RepositoryTypeDef,
    ResponseMetadataTypeDef,
    SetRepositoryPolicyRequestRequestTypeDef,
    SetRepositoryPolicyResponseTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UploadLayerPartRequestRequestTypeDef,
    UploadLayerPartResponseTypeDef,
)

def get_structure() -> AuthorizationDataTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ecr-public` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ecr-public docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ecr_public/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
