import contextlib

import construct
import pytest

from mercury_engine_data_structures.formats.bmsad import BMSAD
from mercury_engine_data_structures.game_check import Game
from test.test_lib import parse_and_build_compare, parse_build_compare_editor

all_bmsad = [
    "actors/characters/armadigger/charclasses/armadigger.bmsad",
    "actors/characters/autclast/charclasses/autclast.bmsad",
    "actors/characters/autector/charclasses/autector.bmsad",
    "actors/characters/autool/charclasses/autool.bmsad",
    "actors/characters/autsharp/charclasses/autsharp.bmsad",
    "actors/characters/autsniper/charclasses/autsniper.bmsad",
    "actors/characters/batalloon/charclasses/batalloon.bmsad",
    "actors/characters/bigfist/charclasses/bigfist.bmsad",
    "actors/characters/bigkranx/charclasses/bigkranx.bmsad",
    "actors/characters/bigx_commanderx/charclasses/bigx_commanderx.bmsad",
    "actors/characters/big_x/charclasses/big_x.bmsad",
    "actors/characters/blindfly/charclasses/blindfly.bmsad",
    "actors/characters/caterzilla/charclasses/caterzilla.bmsad",
    "actors/characters/centralunitcave/charclasses/centralunitcave.bmsad",
    "actors/characters/centralunitforest/charclasses/centralunitforest.bmsad",
    "actors/characters/centralunitlaboratory/charclasses/centralunitlaboratory.bmsad",
    "actors/characters/centralunitmagma/charclasses/centralunitmagma.bmsad",
    "actors/characters/centralunitproto/charclasses/centralunitproto.bmsad",
    "actors/characters/centralunitsanctuary/charclasses/centralunitsanctuary.bmsad",
    "actors/characters/centralunitshipyard/charclasses/centralunitshipyard.bmsad",
    "actors/characters/chozocommander/charclasses/chozocommander.bmsad",
    "actors/characters/chozocommanderx/charclasses/chozocommanderx.bmsad",
    "actors/characters/chozorobotsoldier/charclasses/chozorobotsoldier.bmsad",
    "actors/characters/chozowarrior/charclasses/chozowarrior.bmsad",
    "actors/characters/chozowarriorelite/charclasses/chozowarriorelite.bmsad",
    "actors/characters/chozowarriornormal/charclasses/chozowarriornormal.bmsad",
    "actors/characters/chozowarriorx/charclasses/chozowarriorx.bmsad",
    "actors/characters/chozowarriorxelite/charclasses/chozowarriorxelite.bmsad",
    "actors/characters/chozowarriorxnormal/charclasses/chozowarriorxnormal.bmsad",
    "actors/characters/chozozombiex/charclasses/chozozombiex.bmsad",
    "actors/characters/cooldownxboss/charclasses/cooldownxboss.bmsad",
    "actors/characters/core_x/charclasses/core_x.bmsad",
    "actors/characters/core_x_superquetzoa/charclasses/core_x_superquetzoa.bmsad",
    "actors/characters/cucannon/charclasses/cucannon.bmsad",
    "actors/characters/daivo/charclasses/daivo.bmsad",
    "actors/characters/daivoswarm/charclasses/daivoswarm.bmsad",
    "actors/characters/depthorn/charclasses/depthorn.bmsad",
    "actors/characters/dizzeansprite/charclasses/dizzeansprite.bmsad",
    "actors/characters/dredhed/charclasses/dredhed.bmsad",
    "actors/characters/dropter/charclasses/dropter.bmsad",
    "actors/characters/emmycave/charclasses/emmycave.bmsad",
    "actors/characters/emmyforest/charclasses/emmyforest.bmsad",
    "actors/characters/emmylab/charclasses/emmylab.bmsad",
    "actors/characters/emmymagma/charclasses/emmymagma.bmsad",
    "actors/characters/emmyproto/charclasses/emmyproto.bmsad",
    "actors/characters/emmysanc/charclasses/emmysanc.bmsad",
    "actors/characters/emmyshipyard/charclasses/emmyshipyard.bmsad",
    "actors/characters/fing/charclasses/fing.bmsad",
    "actors/characters/fulmite/charclasses/fulmite.bmsad",
    "actors/characters/gobbler_chozowarriorx/charclasses/gobbler_chozowarriorx.bmsad",
    "actors/characters/gobbler_cooldownx/charclasses/gobbler_cooldownx.bmsad",
    "actors/characters/gobbler_hydrogiga/charclasses/gobbler_hydrogiga.bmsad",
    "actors/characters/gobbler_kraid/charclasses/gobbler_kraid.bmsad",
    "actors/characters/gobbler_scorpius/charclasses/gobbler_scorpius.bmsad",
    "actors/characters/gobbler_supergoliath/charclasses/gobbler_supergoliath.bmsad",
    "actors/characters/gobbler_superquetzoa/charclasses/gobbler_superquetzoa.bmsad",
    "actors/characters/goliath/charclasses/goliath.bmsad",
    "actors/characters/gooplot/charclasses/gooplot.bmsad",
    "actors/characters/gooshocker/charclasses/gooshocker.bmsad",
    "actors/characters/groundshocker/charclasses/groundshocker.bmsad",
    "actors/characters/hecathon/charclasses/hecathon.bmsad",
    "actors/characters/hydrogiga/charclasses/hydrogiga.bmsad",
    "actors/characters/iceflea/charclasses/iceflea.bmsad",
    "actors/characters/infester/charclasses/infester.bmsad",
    "actors/characters/klaida/charclasses/klaida.bmsad",
    "actors/characters/kraid/charclasses/kraid.bmsad",
    "actors/characters/kreep/charclasses/kreep.bmsad",
    "actors/characters/morphball/charclasses/morphball.bmsad",
    "actors/characters/morphball_grab/charclasses/morphball_grab.bmsad",
    "actors/characters/nailong/charclasses/nailong.bmsad",
    "actors/characters/nailugger/charclasses/nailugger.bmsad",
    "actors/characters/obsydomithon/charclasses/obsydomithon.bmsad",
    "actors/characters/omnithon/charclasses/omnithon.bmsad",
    "actors/characters/poisonfly/charclasses/poisonfly.bmsad",
    "actors/characters/quetshocker/charclasses/quetshocker.bmsad",
    "actors/characters/quetzoa/charclasses/quetzoa.bmsad",
    "actors/characters/redenki/charclasses/redenki.bmsad",
    "actors/characters/rinka/charclasses/rinka.bmsad",
    "actors/characters/rockdiver/charclasses/rockdiver.bmsad",
    "actors/characters/rodomithonx/charclasses/rodomithonx.bmsad",
    "actors/characters/rodotuk/charclasses/rodotuk.bmsad",
    "actors/characters/sabotoru/charclasses/sabotoru.bmsad",
    "actors/characters/sakai/charclasses/sakai.bmsad",
    "actors/characters/samus/charclasses/samus.bmsad",
    "actors/characters/samuszerolow/charclasses/samuszerolow.bmsad",
    "actors/characters/sclawk/charclasses/sclawk.bmsad",
    "actors/characters/scorpius/charclasses/scorpius.bmsad",
    "actors/characters/scourge/charclasses/scourge.bmsad",
    "actors/characters/shakernaut/charclasses/shakernaut.bmsad",
    "actors/characters/sharpaw/charclasses/sharpaw.bmsad",
    "actors/characters/shelmit/charclasses/shelmit.bmsad",
    "actors/characters/slidle/charclasses/slidle.bmsad",
    "actors/characters/slugger/charclasses/slugger.bmsad",
    "actors/characters/specimen_x4a/charclasses/specimen_x4a.bmsad",
    "actors/characters/spitclawk/charclasses/spitclawk.bmsad",
    "actors/characters/spittail/charclasses/spittail.bmsad",
    "actors/characters/sunnap/charclasses/sunnap.bmsad",
    "actors/characters/supergoliath/charclasses/supergoliath.bmsad",
    "actors/characters/superquetzoa/charclasses/superquetzoa.bmsad",
    "actors/characters/takumaku/charclasses/takumaku.bmsad",
    "actors/characters/vulkran/charclasses/vulkran.bmsad",
    "actors/characters/warlotus/charclasses/warlotus.bmsad",
    "actors/characters/xparasite/charclasses/xparasite.bmsad",
    "actors/characters/yampa/charclasses/yampa.bmsad",
    "actors/characters/yojimbee/charclasses/yojimbee.bmsad",
    "actors/cutscene/batalloon.bmsad",
    "actors/cutscene/chozocommander_arm_skybase.bmsad",
    "actors/cutscene/chozo_chozoprofessor_cut.bmsad",
    "actors/cutscene/chozo_commander.bmsad",
    "actors/cutscene/chozo_commanderface.bmsad",
    "actors/cutscene/chozo_robotsoldier.bmsad",
    "actors/cutscene/chozo_warrior_normal.bmsad",
    "actors/cutscene/emmy_cave.bmsad",
    "actors/cutscene/emmy_forest.bmsad",
    "actors/cutscene/emmy_lab.bmsad",
    "actors/cutscene/emmy_magma.bmsad",
    "actors/cutscene/emmy_proto.bmsad",
    "actors/cutscene/emmy_sanc.bmsad",
    "actors/cutscene/emmy_shipyard.bmsad",
    "actors/cutscene/samus.bmsad",
    "actors/cutscene/samus_facial.bmsad",
    "actors/cutscene/scorpius.bmsad",
    "actors/cutscene/takumaku_cut.bmsad",
    "actors/cutscene/xparasite_cut.bmsad",
    "actors/events/mapev_activator/charclasses/mapev_activator.bmsad",
    "actors/events/mapev_armor01/charclasses/mapev_armor01.bmsad",
    "actors/events/mapev_armor02/charclasses/mapev_armor02.bmsad",
    "actors/events/mapev_armor03/charclasses/mapev_armor03.bmsad",
    "actors/events/mapev_atriumdebris/charclasses/mapev_atriumdebris.bmsad",
    "actors/events/mapev_bigdebrisqua01/charclasses/mapev_bigdebrisqua01.bmsad",
    "actors/events/mapev_bigdebrisqua02/charclasses/mapev_bigdebrisqua02.bmsad",
    "actors/events/mapev_bigfistgrub_a/charclasses/mapev_bigfistgrub_a.bmsad",
    "actors/events/mapev_birdforest01/charclasses/mapev_birdforest01.bmsad",
    "actors/events/mapev_birdforest02/charclasses/mapev_birdforest02.bmsad",
    "actors/events/mapev_birdforest03/charclasses/mapev_birdforest03.bmsad",
    "actors/events/mapev_birdforest04/charclasses/mapev_birdforest04.bmsad",
    "actors/events/mapev_birdforest05/charclasses/mapev_birdforest05.bmsad",
    "actors/events/mapev_birdforest06/charclasses/mapev_birdforest06.bmsad",
    "actors/events/mapev_birdforest07/charclasses/mapev_birdforest07.bmsad",
    "actors/events/mapev_birdforest08/charclasses/mapev_birdforest08.bmsad",
    "actors/events/mapev_birdforest09/charclasses/mapev_birdforest09.bmsad",
    "actors/events/mapev_birdforest10/charclasses/mapev_birdforest10.bmsad",
    "actors/events/mapev_birdforest11/charclasses/mapev_birdforest11.bmsad",
    "actors/events/mapev_bridgeparts/charclasses/mapev_bridgeparts.bmsad",
    "actors/events/mapev_butterflygroup01/charclasses/mapev_butterflygroup01.bmsad",
    "actors/events/mapev_butterflygroup02/charclasses/mapev_butterflygroup02.bmsad",
    "actors/events/mapev_butterflygroup03/charclasses/mapev_butterflygroup03.bmsad",
    "actors/events/mapev_butterflygroup04/charclasses/mapev_butterflygroup04.bmsad",
    "actors/events/mapev_celldoors/charclasses/mapev_celldoors.bmsad",
    "actors/events/mapev_coral01/charclasses/mapev_coral01.bmsad",
    "actors/events/mapev_cwxencounter01a/charclasses/mapev_cwxencounter01a.bmsad",
    "actors/events/mapev_cwxencounter01b/charclasses/mapev_cwxencounter01b.bmsad",
    "actors/events/mapev_cwxencounter02/charclasses/mapev_cwxencounter02.bmsad",
    "actors/events/mapev_cwxencounter02_ship/charclasses/mapev_cwxencounter02_ship.bmsad",
    "actors/events/mapev_cwxencounter03/charclasses/mapev_cwxencounter03.bmsad",
    "actors/events/mapev_deer01/charclasses/mapev_deer01.bmsad",
    "actors/events/mapev_deer02/charclasses/mapev_deer02.bmsad",
    "actors/events/mapev_deer03/charclasses/mapev_deer03.bmsad",
    "actors/events/mapev_deer04/charclasses/mapev_deer04.bmsad",
    "actors/events/mapev_deer05/charclasses/mapev_deer05.bmsad",
    "actors/events/mapev_deer06/charclasses/mapev_deer06.bmsad",
    "actors/events/mapev_deer07/charclasses/mapev_deer07.bmsad",
    "actors/events/mapev_deer08/charclasses/mapev_deer08.bmsad",
    "actors/events/mapev_deer09/charclasses/mapev_deer09.bmsad",
    "actors/events/mapev_deer10/charclasses/mapev_deer10.bmsad",
    "actors/events/mapev_deer11/charclasses/mapev_deer11.bmsad",
    "actors/events/mapev_deer12/charclasses/mapev_deer12.bmsad",
    "actors/events/mapev_deer13/charclasses/mapev_deer13.bmsad",
    "actors/events/mapev_deer14/charclasses/mapev_deer14.bmsad",
    "actors/events/mapev_deer15/charclasses/mapev_deer15.bmsad",
    "actors/events/mapev_disectedcreature01/charclasses/mapev_disectedcreature01.bmsad",
    "actors/events/mapev_disectedcreature02/charclasses/mapev_disectedcreature02.bmsad",
    "actors/events/mapev_disectedcreature03/charclasses/mapev_disectedcreature03.bmsad",
    "actors/events/mapev_fishes01/charclasses/mapev_fishes01.bmsad",
    "actors/events/mapev_fishes02/charclasses/mapev_fishes02.bmsad",
    "actors/events/mapev_fishes03/charclasses/mapev_fishes03.bmsad",
    "actors/events/mapev_fishes04/charclasses/mapev_fishes04.bmsad",
    "actors/events/mapev_gooplot/charclasses/mapev_gooplot.bmsad",
    "actors/events/mapev_hecathon01/charclasses/mapev_hecathon01.bmsad",
    "actors/events/mapev_hecathon02/charclasses/mapev_hecathon02.bmsad",
    "actors/events/mapev_hecathon03/charclasses/mapev_hecathon03.bmsad",
    "actors/events/mapev_hecathon04/charclasses/mapev_hecathon04.bmsad",
    "actors/events/mapev_hecathon05/charclasses/mapev_hecathon05.bmsad",
    "actors/events/mapev_hecathon06/charclasses/mapev_hecathon06.bmsad",
    "actors/events/mapev_hecathon07/charclasses/mapev_hecathon07.bmsad",
    "actors/events/mapev_hecathon08/charclasses/mapev_hecathon08.bmsad",
    "actors/events/mapev_hecathon09/charclasses/mapev_hecathon09.bmsad",
    "actors/events/mapev_hecathon10/charclasses/mapev_hecathon10.bmsad",
    "actors/events/mapev_insects_forest_001/charclasses/mapev_insects_forest_001.bmsad",
    "actors/events/mapev_insects_forest_002/charclasses/mapev_insects_forest_002.bmsad",
    "actors/events/mapev_insects_magma_001a/charclasses/mapev_insects_magma_001a.bmsad",
    "actors/events/mapev_insects_magma_001b/charclasses/mapev_insects_magma_001b.bmsad",
    "actors/events/mapev_insects_magma_002/charclasses/mapev_insects_magma_002.bmsad",
    "actors/events/mapev_insects_magma_003/charclasses/mapev_insects_magma_003.bmsad",
    "actors/events/mapev_insects_magma_004/charclasses/mapev_insects_magma_004.bmsad",
    "actors/events/mapev_insects_magma_005/charclasses/mapev_insects_magma_005.bmsad",
    "actors/events/mapev_insects_quarantine_001/charclasses/mapev_insects_quarantine_001.bmsad",
    "actors/events/mapev_insects_quarantine_002/charclasses/mapev_insects_quarantine_002.bmsad",
    "actors/events/mapev_lapa_01/charclasses/mapev_lapa_01.bmsad",
    "actors/events/mapev_lapa_02/charclasses/mapev_lapa_02.bmsad",
    "actors/events/mapev_lightinsects/charclasses/mapev_lightinsects.bmsad",
    "actors/events/mapev_lum_ell/charclasses/mapev_lum_ell.bmsad",
    "actors/events/mapev_magma_crab/charclasses/mapev_magma_crab01.bmsad",
    "actors/events/mapev_magma_crab02/charclasses/mapev_magma_crab02.bmsad",
    "actors/events/mapev_omnithon01/charclasses/mapev_omnithon01.bmsad",
    "actors/events/mapev_omnithon02/charclasses/mapev_omnithon02.bmsad",
    "actors/events/mapev_omnithon03/charclasses/mapev_omnithon03.bmsad",
    "actors/events/mapev_omnithon04/charclasses/mapev_omnithon04.bmsad",
    "actors/events/mapev_omnithon05/charclasses/mapev_omnithon05.bmsad",
    "actors/events/mapev_omnithon06/charclasses/mapev_omnithon06.bmsad",
    "actors/events/mapev_omnithon09/charclasses/mapev_omnithon09.bmsad",
    "actors/events/mapev_omnithon10/charclasses/mapev_omnithon10.bmsad",
    "actors/events/mapev_omnithon11/charclasses/mapev_omnithon11.bmsad",
    "actors/events/mapev_omnithon12/charclasses/mapev_omnithon12.bmsad",
    "actors/events/mapev_plant001/charclasses/mapev_plant001.bmsad",
    "actors/events/mapev_plant002_x2/charclasses/mapev_plant002_x2.bmsad",
    "actors/events/mapev_plant002_x4/charclasses/mapev_plant002_x4.bmsad",
    "actors/events/mapev_plant002_x6/charclasses/mapev_plant002_x6.bmsad",
    "actors/events/mapev_plant003_small/charclasses/mapev_plant003_small.bmsad",
    "actors/events/mapev_planteater01/charclasses/mapev_planteater01.bmsad",
    "actors/events/mapev_planteater02/charclasses/mapev_planteater02.bmsad",
    "actors/events/mapev_planteater03/charclasses/mapev_planteater03.bmsad",
    "actors/events/mapev_planteater04/charclasses/mapev_planteater04.bmsad",
    "actors/events/mapev_planteater04_deer/charclasses/mapev_planteater04_deer.bmsad",
    "actors/events/mapev_planteater05/charclasses/mapev_planteater05.bmsad",
    "actors/events/mapev_planteater06/charclasses/mapev_planteater06.bmsad",
    "actors/events/mapev_planteater07/charclasses/mapev_planteater07.bmsad",
    "actors/events/mapev_planteater08/charclasses/mapev_planteater08.bmsad",
    "actors/events/mapev_planteater09/charclasses/mapev_planteater09.bmsad",
    "actors/events/mapev_reptile01/charclasses/mapev_reptile01.bmsad",
    "actors/events/mapev_reptile02/charclasses/mapev_reptile02.bmsad",
    "actors/events/mapev_sanc_superquetzoa001/charclasses/mapev_sanc_superquetzoa001.bmsad",
    "actors/events/mapev_sanc_superquetzoa002/charclasses/mapev_sanc_superquetzoa002.bmsad",
    "actors/events/mapev_sanc_superquetzoa003/charclasses/mapev_sanc_superquetzoa003.bmsad",
    "actors/events/mapev_sanc_superquetzoa004/charclasses/mapev_sanc_superquetzoa004.bmsad",
    "actors/events/mapev_scorpiushunting01/charclasses/mapev_scorpiushunting01.bmsad",
    "actors/events/mapev_scorpiushunting02/charclasses/mapev_scorpiushunting02.bmsad",
    "actors/events/mapev_scorpiushunting03/charclasses/mapev_scorpiushunting03.bmsad",
    "actors/events/mapev_scorpiushunting04/charclasses/mapev_scorpiushunting04.bmsad",
    "actors/events/mapev_scorpiustail/charclasses/mapev_scorpiustail.bmsad",
    "actors/events/mapev_sealife/charclasses/mapev_sealife.bmsad",
    "actors/events/mapev_shrimps/charclasses/mapev_shrimps.bmsad",
    "actors/events/mapev_yamplot/charclasses/mapev_yamplot.bmsad",
    "actors/fx/escape_explosion_big/charclasses/escape_explosion_big.bmsad",
    "actors/fx/escape_explosion_medium/charclasses/escape_explosion_medium.bmsad",
    "actors/fx/escape_explosion_path/charclasses/escape_explosion_path.bmsad",
    "actors/fx/escape_explosion_small/charclasses/escape_explosion_small.bmsad",
    "actors/fx/escape_glass/charclasses/escape_glass.bmsad",
    "actors/fx/flickeringlight01/charclasses/flickeringlight01.bmsad",
    "actors/fx/flickeringlight01static/charclasses/flickeringlight01static.bmsad",
    "actors/fx/heatroomfx/charclasses/heatroomfx.bmsad",
    "actors/fx/smokepipesyellowadorn/charclasses/smokepipesyellowadorn.bmsad",
    "actors/fx/spraypipe_cave/spraypipe_cave.bmsad",
    "actors/fx/steamprotoemmy/charclasses/steamprotoemmy.bmsad",
    "actors/fx/waterbeforemaproom/charclasses/waterbeforemaproom.bmsad",
    "actors/items/itemsphere_bomb/charclasses/itemsphere_bomb.bmsad",
    "actors/items/itemsphere_chargebeam/charclasses/itemsphere_chargebeam.bmsad",
    "actors/items/itemsphere_diffusionbeam/charclasses/itemsphere_diffusionbeam.bmsad",
    "actors/items/itemsphere_doublejump/charclasses/itemsphere_doublejump.bmsad",
    "actors/items/itemsphere_grapplebeam/charclasses/itemsphere_grapplebeam.bmsad",
    "actors/items/itemsphere_gravitysuit/charclasses/itemsphere_gravitysuit.bmsad",
    "actors/items/itemsphere_plasmabeam/charclasses/itemsphere_plasmabeam.bmsad",
    "actors/items/itemsphere_screwattack/charclasses/itemsphere_screwattack.bmsad",
    "actors/items/itemsphere_spacejump/charclasses/itemsphere_spacejump.bmsad",
    "actors/items/itemsphere_supermissile/charclasses/itemsphere_supermissile.bmsad",
    "actors/items/itemsphere_variasuit/charclasses/itemsphere_variasuit.bmsad",
    "actors/items/itemsphere_widebeam/charclasses/itemsphere_widebeam.bmsad",
    "actors/items/item_energyfragment/charclasses/item_energyfragment.bmsad",
    "actors/items/item_energytank/charclasses/item_energytank.bmsad",
    "actors/items/item_missiletank/charclasses/item_missiletank.bmsad",
    "actors/items/item_missiletankplus/charclasses/item_missiletankplus.bmsad",
    "actors/items/item_powerbombtank/charclasses/item_powerbombtank.bmsad",
    "actors/items/powerup_bomb/charclasses/powerup_bomb.bmsad",
    "actors/items/powerup_chargebeam/charclasses/powerup_chargebeam.bmsad",
    "actors/items/powerup_diffusionbeam/charclasses/powerup_diffusionbeam.bmsad",
    "actors/items/powerup_doublejump/charclasses/powerup_doublejump.bmsad",
    "actors/items/powerup_ghostaura/charclasses/powerup_ghostaura.bmsad",
    "actors/items/powerup_grapplebeam/charclasses/powerup_grapplebeam.bmsad",
    "actors/items/powerup_gravitysuit/charclasses/powerup_gravitysuit.bmsad",
    "actors/items/powerup_plasmabeam/charclasses/powerup_plasmabeam.bmsad",
    "actors/items/powerup_screwattack/charclasses/powerup_screwattack.bmsad",
    "actors/items/powerup_sonar/charclasses/powerup_sonar.bmsad",
    "actors/items/powerup_spacejump/charclasses/powerup_spacejump.bmsad",
    "actors/items/powerup_supermissile/charclasses/powerup_supermissile.bmsad",
    "actors/items/powerup_variasuit/charclasses/powerup_variasuit.bmsad",
    "actors/items/powerup_widebeam/charclasses/powerup_widebeam.bmsad",
    "actors/lights/cubemap/charclasses/cubemap.bmsad",
    "actors/lights/omni/charclasses/omni.bmsad",
    "actors/lights/segment/charclasses/segment.bmsad",
    "actors/lights/spot/charclasses/spot.bmsad",
    "actors/logic/breakablehint/charclasses/breakablehint.bmsad",
    "actors/logic/breakabletilegroup/charclasses/breakabletilegroup.bmsad",
    "actors/logic/breakablevignette/charclasses/breakablevignette.bmsad",
    "actors/logic/camerarailpath/charclasses/camerarailpath.bmsad",
    "actors/logic/cutsceneplayer/charclasses/cutsceneplayer.bmsad",
    "actors/logic/cutscenetrigger/charclasses/cutscenetrigger.bmsad",
    "actors/logic/landmark/charclasses/landmark.bmsad",
    "actors/logic/logicactiontrigger/charclasses/logicactiontrigger.bmsad",
    "actors/logic/logiccamera/charclasses/logiccamera.bmsad",
    "actors/logic/logicpath/charclasses/logicpath.bmsad",
    "actors/logic/logicshape/charclasses/logicshape.bmsad",
    "actors/logic/magnetsurface/magnetsurface.bmsad",
    "actors/logic/magnetsurfacewithhusk/magnetsurfacewithhusk.bmsad",
    "actors/logic/magnetsurfacewithhuskright/magnetsurfacewithhuskright.bmsad",
    "actors/logic/nofreezeroom/charclasses/nofreezeroom.bmsad",
    "actors/logic/spawngroup/charclasses/caterzillaspawngroup.bmsad",
    "actors/logic/spawngroup/charclasses/spawngroup.bmsad",
    "actors/logic/spawngroup/charclasses/spawngroupboss.bmsad",
    "actors/logic/spawngroup/charclasses/spawngroupmassivecaterzilla.bmsad",
    "actors/logic/spawnpoint/charclasses/spawnpoint.bmsad",
    "actors/logic/startpoint/charclasses/startpoint.bmsad",
    "actors/logic/trigger/charclasses/trigger.bmsad",
    "actors/logic/videomanager/charclasses/videomanager.bmsad",
    "actors/logic/worldgraph/charclasses/worldgraph.bmsad",
    "actors/props/accesspoint/charclasses/accesspoint.bmsad",
    "actors/props/accesspointcommander/charclasses/accesspointcommander.bmsad",
    "actors/props/aeiongd_statue/charclasses/aeiongd_statue.bmsad",
    "actors/props/aeionstatue/charclasses/aeionstatue.bmsad",
    "actors/props/ammorecharge/charclasses/ammorecharge.bmsad",
    "actors/props/autoolsmartobject/charclasses/autoolsmartobject.bmsad",
    "actors/props/block_cut43/charclasses/block_cut43.bmsad",
    "actors/props/block_hyperbeam/charclasses/block_hyperbeam.bmsad",
    "actors/props/block_pbcolumn/charclasses/block_pbcolumn.bmsad",
    "actors/props/block_pbtube_001/charclasses/block_pbtube_001.bmsad",
    "actors/props/block_pbtube_002/charclasses/block_pbtube_002.bmsad",
    "actors/props/block_pbtube_003/charclasses/block_pbtube_003.bmsad",
    "actors/props/block_slide_reg_001/charclasses/block_slide_reg_001.bmsad",
    "actors/props/box_grapple_cv_001/charclasses/box_grapple_cv_001.bmsad",
    "actors/props/box_magnet_aq_001/charclasses/box_magnet_aq_001.bmsad",
    "actors/props/box_magnet_fr_001/charclasses/box_magnet_fr_001.bmsad",
    "actors/props/box_magnet_mg_003/charclasses/box_magnet_mg_003.bmsad",
    "actors/props/box_magnet_mg_01/charclasses/box_magnet_mg_01.bmsad",
    "actors/props/box_weight_cv_001/charclasses/box_weight_cv_001.bmsad",
    "actors/props/box_weight_cv_001_col/charclasses/box_weight_cv_001_col.bmsad",
    "actors/props/box_wide_cv_001/charclasses/box_wide_cv_001.bmsad",
    "actors/props/breakablecave002/charclasses/breakablecave002.bmsad",
    "actors/props/breakablecave003/charclasses/breakablecave003.bmsad",
    "actors/props/breakablecave006/charclasses/breakablecave006.bmsad",
    "actors/props/breakablecave007/charclasses/breakablecave007.bmsad",
    "actors/props/breakablecave008/charclasses/breakablecave008.bmsad",
    "actors/props/breakablecave009/charclasses/breakablecave009.bmsad",
    "actors/props/breakablecave010/charclasses/breakablecave010.bmsad",
    "actors/props/breakablecave014/charclasses/breakablecave014.bmsad",
    "actors/props/breakablecave016/charclasses/breakablecave016.bmsad",
    "actors/props/breakablecave017/charclasses/breakablecave017.bmsad",
    "actors/props/breakablecave018/charclasses/breakablecave018.bmsad",
    "actors/props/breakablecave020/charclasses/breakablecave020.bmsad",
    "actors/props/breakablemag001/charclasses/breakablemag001.bmsad",
    "actors/props/breakablemag002/charclasses/breakablemag002.bmsad",
    "actors/props/breakablemag003/charclasses/breakablemag003.bmsad",
    "actors/props/breakablemag004/charclasses/breakablemag004.bmsad",
    "actors/props/breakablemag005/charclasses/breakablemag005.bmsad",
    "actors/props/breakablemag007/charclasses/breakablemag007.bmsad",
    "actors/props/breakablemag008/charclasses/breakablemag008.bmsad",
    "actors/props/breakablemag009/charclasses/breakablemag009.bmsad",
    "actors/props/breakablemag010/charclasses/breakablemag010.bmsad",
    "actors/props/breakablemag012/charclasses/breakablemag012.bmsad",
    "actors/props/breakablemag013/charclasses/breakablemag013.bmsad",
    "actors/props/breakablemag014/charclasses/breakablemag014.bmsad",
    "actors/props/burnertrapcav01/charclasses/burnertrapcav01.bmsad",
    "actors/props/capsuleelevatorskybase/charclasses/capsuleelevatorskybase.bmsad",
    "actors/props/capsulelaunchershipyard/charclasses/capsulelaunchershipyard.bmsad",
    "actors/props/capsule_commander/charclasses/capsule_commander.bmsad",
    "actors/props/centralunit/charclasses/centralunit.bmsad",
    "actors/props/centralunitmagmacontroller/charclasses/centralunitmagmacontroller.bmsad",
    "actors/props/centralunitprotocontroller/charclasses/centralunitprotocontroller.bmsad",
    "actors/props/centralunitshipyarddeactivated/charclasses/centralunitshipyarddeactivated.bmsad",
    "actors/props/chozoastro/charclasses/chozoastro.bmsad",
    "actors/props/commander_elevator/charclasses/commander_elevator.bmsad",
    "actors/props/cut_54_scorpiusstatue/charclasses/cut_54_scorpiusstatue.bmsad",
    "actors/props/db_dif_b1_001/charclasses/db_dif_b1_001.bmsad",
    "actors/props/db_dif_b1_002/charclasses/db_dif_b1_002.bmsad",
    "actors/props/db_dif_cv_001/charclasses/db_dif_cv_001.bmsad",
    "actors/props/db_dif_mg_001/charclasses/db_dif_mg_001.bmsad",
    "actors/props/db_dif_mg_002/charclasses/db_dif_mg_002.bmsad",
    "actors/props/db_dside_mg_001/charclasses/db_dside_mg_001.bmsad",
    "actors/props/db_dside_mg_001b/charclasses/db_dside_mg_001b.bmsad",
    "actors/props/db_dside_mg_002/charclasses/db_dside_mg_002.bmsad",
    "actors/props/db_dside_mg_002b/charclasses/db_dside_mg_002b.bmsad",
    "actors/props/db_dside_mg_003/charclasses/db_dside_mg_003.bmsad",
    "actors/props/db_dside_mg_003b/charclasses/db_dside_mg_003b.bmsad",
    "actors/props/db_hdoor_b1_001/charclasses/db_hdoor_b1_001.bmsad",
    "actors/props/db_hdoor_mg_001/charclasses/db_hdoor_mg_001.bmsad",
    "actors/props/db_hdoor_mg_002/charclasses/db_hdoor_mg_002.bmsad",
    "actors/props/db_hdoor_mg_002b/charclasses/db_hdoor_mg_002b.bmsad",
    "actors/props/db_reg_aq_001/charclasses/db_reg_aq_001.bmsad",
    "actors/props/db_reg_aq_002/charclasses/db_reg_aq_002.bmsad",
    "actors/props/db_reg_aq_003/charclasses/db_reg_aq_003.bmsad",
    "actors/props/db_reg_aq_004/charclasses/db_reg_aq_004.bmsad",
    "actors/props/db_reg_aq_005/charclasses/db_reg_aq_005.bmsad",
    "actors/props/db_reg_aq_007/charclasses/db_reg_aq_007.bmsad",
    "actors/props/db_reg_aq_008/charclasses/db_reg_aq_008.bmsad",
    "actors/props/db_reg_aq_009/charclasses/db_reg_aq_009.bmsad",
    "actors/props/db_reg_aq_010/charclasses/db_reg_aq_010.bmsad",
    "actors/props/db_reg_aq_011/charclasses/db_reg_aq_011.bmsad",
    "actors/props/db_reg_b1_001/charclasses/db_reg_b1_001.bmsad",
    "actors/props/db_reg_b1_002/charclasses/db_reg_b1_002.bmsad",
    "actors/props/db_reg_b1_003/charclasses/db_reg_b1_003.bmsad",
    "actors/props/db_reg_b1_004/charclasses/db_reg_b1_004.bmsad",
    "actors/props/db_reg_b2_001/charclasses/db_reg_b2_001.bmsad",
    "actors/props/db_reg_b2_003/charclasses/db_reg_b2_003.bmsad",
    "actors/props/db_reg_b2_004/charclasses/db_reg_b2_004.bmsad",
    "actors/props/db_reg_b2_005/charclasses/db_reg_b2_005.bmsad",
    "actors/props/db_reg_b2_006/charclasses/db_reg_b2_006.bmsad",
    "actors/props/db_reg_b2_007/charclasses/db_reg_b2_007.bmsad",
    "actors/props/db_reg_b2_008/charclasses/db_reg_b2_008.bmsad",
    "actors/props/db_reg_b2_009/charclasses/db_reg_b2_009.bmsad",
    "actors/props/db_reg_b2_010/charclasses/db_reg_b2_010.bmsad",
    "actors/props/db_reg_b2_011/charclasses/db_reg_b2_011.bmsad",
    "actors/props/db_reg_cv_020/charclasses/db_reg_cv_020.bmsad",
    "actors/props/db_reg_cv_021/charclasses/db_reg_cv_021.bmsad",
    "actors/props/db_reg_cv_022/charclasses/db_reg_cv_022.bmsad",
    "actors/props/db_reg_mg_016/charclasses/db_reg_mg_016.bmsad",
    "actors/props/db_reg_mg_018/charclasses/db_reg_mg_018.bmsad",
    "actors/props/db_reg_mg_019/charclasses/db_reg_mg_019.bmsad",
    "actors/props/db_reg_mg_020/charclasses/db_reg_mg_020.bmsad",
    "actors/props/db_reg_qt_001/charclasses/db_reg_qt_001.bmsad",
    "actors/props/deviceheat/charclasses/deviceheat.bmsad",
    "actors/props/deviceheat_camerafar/charclasses/deviceheat_camerafar.bmsad",
    "actors/props/doorcentralunit/charclasses/doorcentralunit.bmsad",
    "actors/props/doorchargecharge/charclasses/doorchargecharge.bmsad",
    "actors/props/doorchargeclosed/charclasses/doorchargeclosed.bmsad",
    "actors/props/doorclosedcharge/charclasses/doorclosedcharge.bmsad",
    "actors/props/doorclosedgrapple/charclasses/doorclosedgrapple.bmsad",
    "actors/props/doorclosedpower/charclasses/doorclosedpower.bmsad",
    "actors/props/dooremmy/charclasses/dooremmy.bmsad",
    "actors/props/doorframe/charclasses/doorframe.bmsad",
    "actors/props/doorframepresence/charclasses/doorframepresence.bmsad",
    "actors/props/doorgrappleclosed/charclasses/doorgrappleclosed.bmsad",
    "actors/props/doorgrapplegrapple/charclasses/doorgrapplegrapple.bmsad",
    "actors/props/doorheat/charclasses/doorheat.bmsad",
    "actors/props/doorlock/charclasses/doorlock.bmsad",
    "actors/props/doorpowerclosed/charclasses/doorpowerclosed.bmsad",
    "actors/props/doorpowerpower/charclasses/doorpowerpower.bmsad",
    "actors/props/doorpresenceframe/charclasses/doorpresenceframe.bmsad",
    "actors/props/doorpresencepresence/charclasses/doorpresencepresence.bmsad",
    "actors/props/doorshieldmissile/charclasses/doorshieldmissile.bmsad",
    "actors/props/doorshieldsupermissile/charclasses/doorshieldsupermissile.bmsad",
    "actors/props/doorshutter/charclasses/doorshutter.bmsad",
    "actors/props/doorwavebeam/charclasses/doorwavebeam.bmsad",
    "actors/props/doorwidebeam/charclasses/doorwidebeam.bmsad",
    "actors/props/door_frblack_gen/charclasses/door_frblack_gen.bmsad",
    "actors/props/door_frblack_protoemmy/charclasses/door_frblack_protoemmy.bmsad",
    "actors/props/door_shield_plasma/charclasses/door_shield_plasma.bmsad",
    "actors/props/dummybtobserver/charclasses/dummybtobserver.bmsad",
    "actors/props/elevator/charclasses/elevator.bmsad",
    "actors/props/elevator_with_cutscene/charclasses/elevator_with_cutscene.bmsad",
    "actors/props/emergency_light/charclasses/emergency_light.bmsad",
    "actors/props/emmyvalve_reg_gen_001/charclasses/emmyvalve_reg_gen_001.bmsad",
    "actors/props/emmy_frozen/charclasses/emmy_frozen.bmsad",
    "actors/props/emmy_sanc_deactivated/charclasses/emmy_sanc_deactivated.bmsad",
    "actors/props/emmy_shipyard/charclasses/emmy_shipyard.bmsad",
    "actors/props/energyrecharge/charclasses/energyrecharge.bmsad",
    "actors/props/env_frozen_gen_001/charclasses/env_frozen_gen_001.bmsad",
    "actors/props/env_heat_gen_001/charclasses/env_heat_gen_001.bmsad",
    "actors/props/ev_aquadrain_left/charclasses/ev_aquadrain_left.bmsad",
    "actors/props/ev_aquadrain_right/charclasses/ev_aquadrain_right.bmsad",
    "actors/props/ev_chainreaction_cv_001/charclasses/ev_chainreaction_cv_001.bmsad",
    "actors/props/ev_chainreaction_cv_001_a/charclasses/ev_chainreaction_cv_001_a.bmsad",
    "actors/props/ev_chainreaction_cv_001_b/charclasses/ev_chainreaction_cv_001_b.bmsad",
    "actors/props/ev_chainreaction_cv_002/charclasses/ev_chainreaction_cv_002.bmsad",
    "actors/props/ev_chainreaction_cv_003/charclasses/ev_chainreaction_cv_003.bmsad",
    "actors/props/ev_chainreaction_cv_004/charclasses/ev_chainreaction_cv_004.bmsad",
    "actors/props/ev_chainreaction_cv_004_a/charclasses/ev_chainreaction_cv_004_a.bmsad",
    "actors/props/ev_chainreaction_cv_005/charclasses/ev_chainreaction_cv_005.bmsad",
    "actors/props/ev_chainreaction_cv_006/charclasses/ev_chainreaction_cv_006.bmsad",
    "actors/props/ev_chainreaction_cv_007/charclasses/ev_chainreaction_cv_007.bmsad",
    "actors/props/ev_chainreaction_cv_009/charclasses/ev_chainreaction_cv_009.bmsad",
    "actors/props/ev_chainreaction_cv_010/charclasses/ev_chainreaction_cv_010.bmsad",
    "actors/props/ev_chainreaction_cv_010_b/charclasses/ev_chainreaction_cv_010_b.bmsad",
    "actors/props/ev_chainreaction_cv_011/charclasses/ev_chainreaction_cv_011.bmsad",
    "actors/props/ev_chainreaction_cv_fx_001/charclasses/ev_chainreaction_cv_fx_001.bmsad",
    "actors/props/ev_chainreaction_cv_fx_002/charclasses/ev_chainreaction_cv_fx_002.bmsad",
    "actors/props/ev_chainreaction_cv_fx_003/charclasses/ev_chainreaction_cv_fx_003.bmsad",
    "actors/props/ev_chainreaction_cv_fx_004/charclasses/ev_chainreaction_cv_fx_004.bmsad",
    "actors/props/ev_chozowall/charclasses/ev_chozowall.bmsad",
    "actors/props/ev_commanderx_rock01/charclasses/ev_commanderx_rock01.bmsad",
    "actors/props/ev_demolition_block/charclasses/ev_demolition_block.bmsad",
    "actors/props/ev_demolition_db_001/charclasses/ev_demolition_db_001.bmsad",
    "actors/props/ev_demolition_db_002/charclasses/ev_demolition_db_002.bmsad",
    "actors/props/ev_demolition_db_003/charclasses/ev_demolition_db_003.bmsad",
    "actors/props/ev_demolition_debris/charclasses/ev_demolition_debris.bmsad",
    "actors/props/ev_demolition_grapple/charclasses/ev_demolition_grapple.bmsad",
    "actors/props/ev_demolition_tunnel/charclasses/ev_demolition_tunnel.bmsad",
    "actors/props/ev_dna_centrifuge_001/charclasses/ev_dna_centrifuge_001.bmsad",
    "actors/props/ev_dna_centrifuge_002/charclasses/ev_dna_centrifuge_002.bmsad",
    "actors/props/ev_dna_centrifuge_003/charclasses/ev_dna_centrifuge_003.bmsad",
    "actors/props/ev_dna_centrifuge_004/charclasses/ev_dna_centrifuge_004.bmsad",
    "actors/props/ev_dna_centrifuge_005/charclasses/ev_dna_centrifuge_005.bmsad",
    "actors/props/ev_dna_centrifuge_006/charclasses/ev_dna_centrifuge_006.bmsad",
    "actors/props/ev_doorprof/charclasses/ev_doorprof.bmsad",
    "actors/props/ev_doorprof_open/charclasses/ev_doorprof_open.bmsad",
    "actors/props/ev_dspiston_heat/charclasses/ev_dspiston_heat.bmsad",
    "actors/props/ev_dspiston_mg_001/charclasses/ev_dspiston_mg_001.bmsad",
    "actors/props/ev_entercu_cv_001/charclasses/ev_entercu_cv_001.bmsad",
    "actors/props/ev_escape_1/charclasses/ev_escape_1.bmsad",
    "actors/props/ev_escape_2_end/charclasses/ev_escape_2_end.bmsad",
    "actors/props/ev_escape_2_init/charclasses/ev_escape_2_init.bmsad",
    "actors/props/ev_escape_3/charclasses/ev_escape_3.bmsad",
    "actors/props/ev_escape_4/charclasses/ev_escape_4.bmsad",
    "actors/props/ev_evacuation/charclasses/ev_evacuation.bmsad",
    "actors/props/ev_gatesealed_aut_001/charclasses/ev_gatesealed_aut_001.bmsad",
    "actors/props/ev_gatesealed_closed/charclasses/ev_gatesealed_closed.bmsad",
    "actors/props/ev_gatesealed_openned/charclasses/ev_gatesealed_openned.bmsad",
    "actors/props/ev_gatesealed_sanc/charclasses/ev_gatesealed_sanc.bmsad",
    "actors/props/ev_hpiston_mg_001/charclasses/ev_hpiston_mg_001.bmsad",
    "actors/props/ev_hpiston_mg_001_disabled/charclasses/ev_hpiston_mg_001_disabled.bmsad",
    "actors/props/ev_kraid_entrance/charclasses/ev_kraid_entrance.bmsad",
    "actors/props/ev_kraid_platform/charclasses/ev_kraid_platform.bmsad",
    "actors/props/ev_kraid_platform_post/charclasses/ev_kraid_platform_post.bmsad",
    "actors/props/ev_kraid_spike/charclasses/ev_kraid_spike.bmsad",
    "actors/props/ev_kraid_structure_ingame/charclasses/ev_kraid_structure_ingame.bmsad",
    "actors/props/ev_lavapump_mg_001/charclasses/ev_lavapump_mg_001.bmsad",
    "actors/props/ev_ph2drain_activator/charclasses/ev_ph2drain_activator.bmsad",
    "actors/props/ev_ph2drain_platform/charclasses/ev_ph2drain_platform.bmsad",
    "actors/props/ev_piston_cv_001/charclasses/ev_piston_cv_001.bmsad",
    "actors/props/ev_protoemmy_chasemusic/charclasses/ev_protoemmy_chasemusic.bmsad",
    "actors/props/ev_quarantine_roomlights/charclasses/ev_quarantine_roomlights.bmsad",
    "actors/props/ev_scorpiusstatue_end/charclasses/ev_scorpiusstatue_end.bmsad",
    "actors/props/ev_shi_ray02/charclasses/ev_shi_ray02.bmsad",
    "actors/props/ev_shi_rayimpact01/charclasses/ev_shi_rayimpact01.bmsad",
    "actors/props/ev_shi_ship01/charclasses/ev_shi_ship01.bmsad",
    "actors/props/ev_shi_ship02/charclasses/ev_shi_ship02.bmsad",
    "actors/props/ev_soldierpresentation/charclasses/ev_soldierpresentation.bmsad",
    "actors/props/ev_tbdrainboss/charclasses/ev_tbdrainboss.bmsad",
    "actors/props/ev_tentacledead_001/charclasses/ev_tentacledead_001.bmsad",
    "actors/props/ev_tentacledead_002/charclasses/ev_tentacledead_002.bmsad",
    "actors/props/ev_tentacledead_003/charclasses/ev_tentacledead_003.bmsad",
    "actors/props/ev_tentacledead_004/charclasses/ev_tentacledead_004.bmsad",
    "actors/props/ev_tentacle_001/charclasses/ev_tentacle_001.bmsad",
    "actors/props/ev_tentacle_002/charclasses/ev_tentacle_002.bmsad",
    "actors/props/ev_tentacle_003/charclasses/ev_tentacle_003.bmsad",
    "actors/props/ev_tentacle_004/charclasses/ev_tentacle_004.bmsad",
    "actors/props/ev_tpiston_heat/charclasses/ev_tpiston_heat.bmsad",
    "actors/props/ev_tpiston_mg_001/charclasses/ev_tpiston_mg_001.bmsad",
    "actors/props/ev_watervalve_hydrogiga/charclasses/ev_watervalve_hydrogiga.bmsad",
    "actors/props/fan_cooldown/charclasses/fan_cooldown.bmsad",
    "actors/props/fan_reg/charclasses/fan_reg.bmsad",
    "actors/props/fedship_hol/charclasses/fedship_hol.bmsad",
    "actors/props/footstepplatform/charclasses/footstepplatform.bmsad",
    "actors/props/fusiblebox/charclasses/fusiblebox.bmsad",
    "actors/props/fusiblebox_broken/charclasses/fusiblebox_broken.bmsad",
    "actors/props/fx_cold_door/charclasses/fx_cold_door.bmsad",
    "actors/props/fx_heat_door/charclasses/fx_heat_door.bmsad",
    "actors/props/fx_heat_tunnel/charclasses/fx_heat_tunnel.bmsad",
    "actors/props/gatecaveprotoemmy/charclasses/gatecaveprotoemmy.bmsad",
    "actors/props/gobblerweb/gobblerweb.bmsad",
    "actors/props/grapplepulloff1x2/charclasses/grapplepulloff1x2.bmsad",
    "actors/props/grappleswingpoint/charclasses/grappleswingpoint.bmsad",
    "actors/props/hydrogigacorpse/charclasses/hydrogigacorpse.bmsad",
    "actors/props/ice_casquery/charclasses/ice_casquery.bmsad",
    "actors/props/ice_cube/charclasses/ice_cube.bmsad",
    "actors/props/instanceactor/charclasses/instanceactor.bmsad",
    "actors/props/instancefx/charclasses/instancefx.bmsad",
    "actors/props/lavazone/charclasses/lavazone.bmsad",
    "actors/props/maproom/charclasses/maproom.bmsad",
    "actors/props/mblauncher_exit_gen_001/charclasses/mblauncher_exit_gen_001.bmsad",
    "actors/props/mblauncher_exit_kraid/charclasses/mblauncher_exit_kraid.bmsad",
    "actors/props/mblauncher_launcher_gen_001/charclasses/mblauncher_launcher_gen_001.bmsad",
    "actors/props/mlm_block/charclasses/mlm_block.bmsad",
    "actors/props/mlm_point/charclasses/mlm_point.bmsad",
    "actors/props/pf_mushr_fr/charclasses/pf_mushr_fr.bmsad",
    "actors/props/pf_mushr_fr_ice_cube/charclasses/pf_mushr_fr_ice_cube.bmsad",
    "actors/props/pistonmag01/charclasses/pistonmag01.bmsad",
    "actors/props/piston_right_kraid/charclasses/piston_right_kraid.bmsad",
    "actors/props/platformcavewaterb/charclasses/platformcavewaterb.bmsad",
    "actors/props/platformcavmagnet3left/charclasses/platformcavmagnet3left.bmsad",
    "actors/props/platformcavmagnet4down/charclasses/platformcavmagnet4down.bmsad",
    "actors/props/platformcavmagnet5down/charclasses/platformcavmagnet5down.bmsad",
    "actors/props/platformtrapgrapple5right/charclasses/platformtrapgrapple5right.bmsad",
    "actors/props/portal_trainwagon_left/charclasses/portal_trainwagon_left.bmsad",
    "actors/props/portal_trainwagon_right/charclasses/portal_trainwagon_right.bmsad",
    "actors/props/powergenerator/charclasses/powergenerator.bmsad",
    "actors/props/powergeneratorengine/charclasses/powergeneratorengine.bmsad",
    "actors/props/professor_death/charclasses/professor_death.bmsad",
    "actors/props/rail_magnet/charclasses/rail_magnet.bmsad",
    "actors/props/samus_deadsuit/charclasses/samus_deadsuit.bmsad",
    "actors/props/savestation/charclasses/savestation.bmsad",
    "actors/props/shootactivatorhidrogiga/charclasses/shootactivatorhidrogiga.bmsad",
    "actors/props/shootactivatormag01/charclasses/shootactivatormag01.bmsad",
    "actors/props/shootactivatormag01/charclasses/shootactivatormag01fakeblock.bmsad",
    "actors/props/shootactivatoroff/charclasses/shootactivatoroff.bmsad",
    "actors/props/skybase/charclasses/skybase.bmsad",
    "actors/props/spacejump_marker/charclasses/spacejump_marker.bmsad",
    "actors/props/steammag01/charclasses/steammag01.bmsad",
    "actors/props/teleporter/charclasses/teleporter.bmsad",
    "actors/props/totalrechargestation/charclasses/totalrechargestation.bmsad",
    "actors/props/trap_rot_cv_001/charclasses/trap_rot_cv_001.bmsad",
    "actors/props/trap_rot_cv_002/charclasses/trap_rot_cv_002.bmsad",
    "actors/props/trap_thermal_horizontal/charclasses/trap_thermal_horizontal.bmsad",
    "actors/props/tunnelframe/charclasses/tunnelframe.bmsad",
    "actors/props/wagontrain/charclasses/wagontrain.bmsad",
    "actors/props/wagontrain_with_cutscene/charclasses/wagontrain_with_cutscene.bmsad",
    "actors/props/wagontrain_with_portal/charclasses/wagontrain_with_portal.bmsad",
    "actors/props/waterzone/charclasses/waterzone.bmsad",
    "actors/props/weightactivatedplatform_access/charclasses/weightactivatedplatform_access.bmsad",
    "actors/props/weightactivatedplatform_ammo/charclasses/weightactivatedplatform_ammo.bmsad",
    "actors/props/weightactivatedplatform_elevator/charclasses/weightactivatedplatform_elevator.bmsad",
    "actors/props/weightactivatedplatform_elevator_frozen/charclasses/weightactivatedplatform_elevator_frozen.bmsad",
    "actors/props/weightactivatedplatform_energy/charclasses/weightactivatedplatform_energy.bmsad",
    "actors/props/weightactivatedplatform_generator/charclasses/weightactivatedplatform_generator.bmsad",
    "actors/props/weightactivatedplatform_map/charclasses/weightactivatedplatform_map.bmsad",
    "actors/props/weightactivatedplatform_save/charclasses/weightactivatedplatform_save.bmsad",
    "actors/props/weightactivatedplatform_teleport/charclasses/weightactivatedplatform_teleport.bmsad",
    "actors/props/weightactivatedplatform_teleport_frozen/charclasses/weightactivatedplatform_teleport_frozen.bmsad",
    "actors/props/weightactivatedplatform_thermal/charclasses/weightactivatedplatform_thermal.bmsad",
    "actors/props/weightactivatedplatform_total/charclasses/weightactivatedplatform_total.bmsad",
    "actors/props/weightactivatedplatform_train/charclasses/weightactivatedplatform_train.bmsad",
    "actors/props/weightactivatedplatform_valve/charclasses/weightactivatedplatform_valve.bmsad",
    "actors/props/wplatform_cm_elevator/charclasses/weightactivatedplatform_commanderelevator.bmsad",
    "actors/props/zipline_bottom_gen_001/charclasses/zipline_bottom_gen_001.bmsad",
    "actors/props/zipline_bottom_hydrogiga/charclasses/zipline_bottom_hydrogiga.bmsad",
    "actors/props/zipline_frozen/charclasses/zipline_frozen.bmsad",
    "actors/props/zipline_left_gen_001/charclasses/zipline_left_gen_001.bmsad",
    "actors/props/zipline_rail_hydrogiga/charclasses/zipline_rail_hydrogiga.bmsad",
    "actors/props/zipline_right_gen_001/charclasses/zipline_right_gen_001.bmsad",
    "actors/sounds/areamusic/charclasses/areamusic.bmsad",
    "actors/sounds/areasound/charclasses/areasound.bmsad",
    "actors/sounds/positionalsound/charclasses/positionalsound.bmsad",
    "actors/sounds/soundproofarea/charclasses/soundproofarea.bmsad",
    "actors/spawnpoints/spawnpointautool/charclasses/spawnpointautool.bmsad",
    "actors/spawnpoints/spawnpointautsharp/charclasses/spawnpointautsharp.bmsad",
    "actors/spawnpoints/spawnpointautsniper/charclasses/spawnpointautsniper.bmsad",
    "actors/spawnpoints/spawnpointcaterzilla/charclasses/spawnpointcaterzilla.bmsad",
    "actors/spawnpoints/spawnpointcaterzilla/charclasses/spawnpointcaterzillawall.bmsad",
    "actors/spawnpoints/spawnpointcaterzillametallic/charclasses/spawnpointcaterzillametallic.bmsad",
    "actors/spawnpoints/spawnpointcaterzillametallic/charclasses/spawnpointcaterzillametallicwall.bmsad",
    "actors/spawnpoints/spawnpointchozozombiex/charclasses/spawnpointchozozombiex.bmsad",
    "actors/spawnpoints/spawnpointemmy/charclasses/spawnpointemmy.bmsad",
    "actors/spawnpoints/spawnpointgobbler/charclasses/spawnpointgobbler.bmsad",
    "actors/spawnpoints/spawnpointrinka/charclasses/spawnpointrinka.bmsad",
    "actors/spawnpoints/spawnpointrockdiver/charclasses/spawnpointrockdiver.bmsad",
    "actors/spawnpoints/spawnpointrockdivermetallic/charclassses/spawnpointrockdivermetallic.bmsad",
    "actors/spawnpoints/spawnpointsabotoru/charclasses/spawnpointsabotoru.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidle.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidlemetallic.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidlemetallicout.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidlemetallicoutwall.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidlemetallicwall.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidleout.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidleoutwall.bmsad",
    "actors/spawnpoints/spawnpointslidle/charclasses/spawnpointslidlewall.bmsad",
    "actors/spawnpoints/spawnpointslownailong/charclasses/spawnpointslownailong.bmsad",
    "actors/weapons/bigkranxmagmaball/charclasses/bigkranxmagmaball.bmsad",
    "actors/weapons/bomb/charclasses/bomb.bmsad",
    "actors/weapons/chozocommanderenergyshardsfragment/charclasses/chozocommanderenergyshardsfragment.bmsad",
    "actors/weapons/chozocommanderenergyshardssphere/charclasses/chozocommanderenergyshardssphere.bmsad",
    "actors/weapons/chozocommandersentencesphere/charclasses/chozocommandersentencesphere.bmsad",
    "actors/weapons/chozorobotsoldierbeam/charclasses/chozorobotsoldierbeam.bmsad",
    "actors/weapons/chozowarriorxspit/charclasses/chozowarriorxspit.bmsad",
    "actors/weapons/cooldownxbossfireball/charclasses/cooldownxbossfireball.bmsad",
    "actors/weapons/cooldownxbossfireballbreakable/charclasses/cooldownxbossfireballbreakable.bmsad",
    "actors/weapons/cooldownxbosslavacarpet/charclasses/cooldownxbosslavacarpet.bmsad",
    "actors/weapons/cooldownxbossweakpoint/charclasses/cooldownxbossweakpoint.bmsad",
    "actors/weapons/cooldownxbosswindtunneldamagetrigger/charclasses/cooldownxbosswindtunneldamagetrigger.bmsad",
    "actors/weapons/cucannonbeam/charclasses/cucannonbeam.bmsad",
    "actors/weapons/depthornball/charclasses/depthornball.bmsad",
    "actors/weapons/emmywave/charclasses/emmywave.bmsad",
    "actors/weapons/floorshockwave/charclasses/floorshockwave.bmsad",
    "actors/weapons/fulmitebellymine/charclasses/fulmitebellymine.bmsad",
    "actors/weapons/grapplebeam/charclasses/grapplebeam.bmsad",
    "actors/weapons/icemissile/charclasses/icemissile.bmsad",
    "actors/weapons/infesterball/charclasses/infesterball.bmsad",
    "actors/weapons/kraidacidblobs/charclasses/kraidacidblobs.bmsad",
    "actors/weapons/kraidbouncingcreatures/charclasses/kraidbouncingcreatures.bmsad",
    "actors/weapons/kraidbouncingcreaturesunb/charclasses/kraidbouncingcreaturesunb.bmsad",
    "actors/weapons/kraidnail/charclasses/kraidnail.bmsad",
    "actors/weapons/kraidrottenmeat/charclasses/kraidrottenmeat.bmsad",
    "actors/weapons/kraidshockersplashprojectile/charclasses/kraidshockersplashprojectile.bmsad",
    "actors/weapons/kraidspike/charclasses/kraidspike.bmsad",
    "actors/weapons/kraidspike2/charclasses/kraidspike2.bmsad",
    "actors/weapons/kraidspike3/charclasses/kraidspike3.bmsad",
    "actors/weapons/kraidspikedown/charclasses/kraidspikedown.bmsad",
    "actors/weapons/kraidspikemedium/charclasses/kraidspikemedium.bmsad",
    "actors/weapons/kraidspikeup/charclasses/kraidspikeup.bmsad",
    "actors/weapons/linebomb/charclasses/linebomb.bmsad",
    "actors/weapons/lockonmissile/charclasses/lockonmissile.bmsad",
    "actors/weapons/lockonmissilemarker/charclasses/lockonmissilemarker.bmsad",
    "actors/weapons/missile/charclasses/missile.bmsad",
    "actors/weapons/nailongthorn/charclasses/nailongthorn.bmsad",
    "actors/weapons/nailuggeracidball/charclasses/nailuggeracidball.bmsad",
    "actors/weapons/powerbomb/charclasses/powerbomb.bmsad",
    "actors/weapons/quetzoaenergywave/charclasses/quetzoaenergywave.bmsad",
    "actors/weapons/scorpiuspoisonousspit/charclasses/scorpiuspoisonousspit.bmsad",
    "actors/weapons/shockwave/charclasses/shockwave.bmsad",
    "actors/weapons/shockwavepool/charclasses/shockwavepool.bmsad",
    "actors/weapons/sluggeracidball/charclasses/sluggeracidball.bmsad",
    "actors/weapons/specialrocket/charclasses/specialrocket.bmsad",
    "actors/weapons/spittailmagmaball/charclasses/spittailmagmaball.bmsad",
    "actors/weapons/supergoliathlinebomb/charclasses/supergoliathlinebomb.bmsad",
    "actors/weapons/supermissile/charclasses/supermissile.bmsad",
    "actors/weapons/superquetzoaenergywave/charclasses/superquetzoaenergywave.bmsad",
    "actors/weapons/superquetzoavoidmissiles/charclasses/superquetzoavoidmissiles.bmsad",
    "actors/weapons/vulkranmagmaball/charclasses/vulkranmagmaball.bmsad",
    "cutscenes/0001gameintrolanding/actors/caveelevator/actor.bmsad",
    "cutscenes/0001gameintrolanding/actors/samus_facial/actor.bmsad",
    "cutscenes/0001gameintrolanding/actors/samus_ship_b/actor.bmsad",
    "cutscenes/0001gameintro_arrivalatrium/actors/caveelevator/actor.bmsad",
    "cutscenes/0001gameintro_arrivalatrium/actors/cut_01_bridgesubchar/actor.bmsad",
    "cutscenes/0001gameintro_arrivalatrium/actors/doorcaveatrium/actor.bmsad",
    "cutscenes/0001gameintro_arrivalatrium/actors/watercave02subchar/actor.bmsad",
    "cutscenes/0001gameintro_fight/actors/cut_01_bridgesubchar/actor.bmsad",
    "cutscenes/0001gameintro_fight/actors/missile_cutsubchar/actor.bmsad",
    "cutscenes/0001gameintro_fight/actors/samus_facial/actor.bmsad",
    "cutscenes/0001gameintro_fight/actors/supermissile_cutsubchar/actor.bmsad",
    "cutscenes/0001gameintro_fight/actors/watercave02subchar/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/asteroid_a/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/asteroid_b/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/asteroid_c/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/planetzdr/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/planetzdr_background/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/samuship_int/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/samus_face/actor.bmsad",
    "cutscenes/0001gameintro_space/actors/samus_ship_b/actor.bmsad",
    "cutscenes/0003firstcomunicationfakeadam/actors/accesspoint/actor.bmsad",
    "cutscenes/0003firstcomunicationfakeadam/actors/weightactivatedplatform/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_2/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_3/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_5/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_6/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_7/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_8/actor.bmsad",
    "cutscenes/0004quarantinedoorsopen/actors/xparasite_9/actor.bmsad",
    "cutscenes/0005meleetutorial/actors/bigfist/actor.bmsad",
    "cutscenes/0007beginningofcooldown/actors/elevator/actor.bmsad",
    "cutscenes/0012metroidnizationstrongreactionevent/actors/cut_012_capsule_2/actor.bmsad",
    "cutscenes/0012metroidnizationstrongreactionevent/actors/cut_012_capsule_3/actor.bmsad",
    "cutscenes/0012metroidnizationstrongreactionevent/actors/samus_facial/actor.bmsad",
    "cutscenes/0013firstencounterchozozombie/actors/chozozombiex/actor.bmsad",
    "cutscenes/0013firstencounterchozozombie/actors/chozozombiex_2/actor.bmsad",
    "cutscenes/0032ghostdashobtention/actors/itemcube_broken/actor.bmsad",
    "cutscenes/0033sonarobtention/actors/aeionstatuesubchar/actor.bmsad",
    "cutscenes/0033sonarobtention/actors/itemcube_broken/actor.bmsad",
    "cutscenes/0034protoemmyappears/actors/cutmodel49wall01subchar/actor.bmsad",
    "cutscenes/0034protoemmyappears/actors/cutmodel49wall02subchar/actor.bmsad",
    "cutscenes/0034protoemmyappears/actors/cutmodel49wall03subchar/actor.bmsad",
    "cutscenes/0034protoemmyappears/actors/cutmodel49wall04subchar/actor.bmsad",
    "cutscenes/0034protoemmyappears/actors/cutmodel49wall04_2/actor.bmsad",
    "cutscenes/0035protoemmycantclimb/actors/cutmodel49wall01subchar/actor.bmsad",
    "cutscenes/0036enteremmyzone/actors/dooremmy_cut36subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/cut_37_wall01subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/cut_37_wallend01subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/cut_37_wallend02subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/cut_37_wdrain01subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/cut_37_wires01subchar/actor.bmsad",
    "cutscenes/0037emmycaveappears/actors/missile_cut/actor.bmsad",
    "cutscenes/0039labemmypresentation/actors/cut_all_pathemmy01subchar/actor.bmsad",
    "cutscenes/0039labemmypresentation/actors/doorshutter/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part1/actors/chozoprofessor/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part1/actors/cut_professorpanel/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part1/actors/muralbreakeable_cut40_3/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part1/actors/mural_cut40subchar/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part1/actors/samus_facial/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2a/actors/chozoprofessor/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2a/actors/cut_professorpanelagua/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2a/actors/samus_face/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2b/actors/chozoprofessor/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2b/actors/professor_deathsubchar/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part2b/actors/samus_face/actor.bmsad",
    "cutscenes/0040sancemmypresentation_part3/actors/professor_deathsubchar/actor.bmsad",
    "cutscenes/0042professorxpresentation/actors/autool_cut/actor.bmsad",
    "cutscenes/0042professorxpresentation/actors/cut_37_wall01subchar/actor.bmsad",
    "cutscenes/0042professorxpresentation/actors/cut_professorpanel/actor.bmsad",
    "cutscenes/0043emmymetroidnization/actors/centralunitcave/actor.bmsad",
    "cutscenes/0043emmymetroidnization/actors/cut_81_wall01subchar/actor.bmsad",
    "cutscenes/0043emmymetroidnization/actors/samus_face/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_01/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_02/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_03/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_04/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_05/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_06/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/butterfly_07/actor.bmsad",
    "cutscenes/0048firstcupowerobtention/actors/centralunitcavebroken/actor.bmsad",
    "cutscenes/0049centralunitdetectsamus01/actors/centralunitcave/actor.bmsad",
    "cutscenes/0049centralunitdetectsamus02/actors/centralunitcave/actor.bmsad",
    "cutscenes/0050firstcupresentation/actors/centralunitcave/actor.bmsad",
    "cutscenes/0051cudeathandpowerobtention/actors/centralunitcave/actor.bmsad",
    "cutscenes/0053genericcupowerobtention/actors/centralunitcave/actor.bmsad",
    "cutscenes/0053genericcupowerobtention_r/actors/centralunitcave/actor.bmsad",
    "cutscenes/0054scorpiuspresentation/actors/missile_cutsubchar/actor.bmsad",
    "cutscenes/0054scorpiuspresentation/actors/scostatuefull_cut54subchar/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/drop_life_cutsubchar/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/drop_life_cut_2/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/drop_life_cut_3/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/missile_cut/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/missile_cut_2/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/missile_cut_3/actor.bmsad",
    "cutscenes/0055scorpiusphase2/actors/missile_cut_4/actor.bmsad",
    "cutscenes/0057scorpiusdeath/actors/cut_57_statuebrokensubchar/actor.bmsad",
    "cutscenes/0057scorpiusdeath/actors/itemcube_broken/actor.bmsad",
    "cutscenes/0057scorpiusdeath/actors/scostatuertop_cut57/actor.bmsad",
    "cutscenes/0059kraidpresentation/actors/ev_kraid_railssubchar/actor.bmsad",
    "cutscenes/0059kraidpresentation/actors/ev_kraid_structure/actor.bmsad",
    "cutscenes/0059kraidpresentation/actors/ev_kraid_symmetrywalldomesubchar/actor.bmsad",
    "cutscenes/0059kraidpresentation/actors/ev_kraid_symmetrywallsubchar/actor.bmsad",
    "cutscenes/0059kraidpresentation/actors/kraid/actor.bmsad",
    "cutscenes/0060kraidphase02/actors/ev_kraid_railssubchar/actor.bmsad",
    "cutscenes/0060kraidphase02/actors/ev_kraid_structuresubchar/actor.bmsad",
    "cutscenes/0060kraidphase02/actors/ev_kraid_symmetrywalldomesubchar/actor.bmsad",
    "cutscenes/0060kraidphase02/actors/ev_kraid_symmetrywallsubchar/actor.bmsad",
    "cutscenes/0060kraidphase02/actors/kraid/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/ev_kraid_platformsubchar/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/ev_kraid_railssubchar/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/ev_kraid_symmetrywalldomesubchar/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/ev_kraid_symmetrywallsubchar/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/kraid/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/kraidshackles/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/kraidspike_cntk/actor.bmsad",
    "cutscenes/0061kraiddeath/actors/pool_lava_45x2_kraidsubchar/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/ev_kraid_platformsubchar/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/ev_kraid_railssubchar/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/ev_kraid_symmetrywalldomesubchar/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/ev_kraid_symmetrywallsubchar/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/kraid/actor.bmsad",
    "cutscenes/0061kraiddeath_zipline_mb/actors/kraidshackles/actor.bmsad",
    "cutscenes/0063_hydrogiga-presentation/actors/hydrogiga/actor.bmsad",
    "cutscenes/0063_hydrogiga-presentation/actors/zipline_rail_hydrogigasubchar/actor.bmsad",
    "cutscenes/0065hydrogigadeath/actors/hydrogiga/actor.bmsad",
    "cutscenes/0067chozowarriorxpresentation/actors/chozowarrior/actor.bmsad",
    "cutscenes/0067chozowarriorxpresentation/actors/ev_soldierpresentation/actor.bmsad",
    "cutscenes/0071chozowarriorxelitepresentation/actors/chozowarriorelite/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/cooldownxboss/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/cut_78_roofsubchar/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/cut_81_ball_slime/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/cut_81_lavasubchar/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/cut_cooldownboss_machine/actor.bmsad",
    "cutscenes/0078cooldownpresentation/actors/morphball/actor.bmsad",
    "cutscenes/0081cooldowndeath/actors/cooldownxboss/actor.bmsad",
    "cutscenes/0081cooldowndeath/actors/core_x/actor.bmsad",
    "cutscenes/0081cooldowndeath/actors/cut_81_lavasubchar/actor.bmsad",
    "cutscenes/0081cooldowndeath/actors/cut_cooldownboss_machine/actor.bmsad",
    "cutscenes/0081cooldowndeath_grab/actors/cut_81_lavasubchar/actor.bmsad",
    "cutscenes/0081cooldowndeath_grab/actors/cut_81_wall01subchar/actor.bmsad",
    "cutscenes/0086commanderorbital/actors/accesspoint/actor.bmsad",
    "cutscenes/0086commanderorbital/actors/cut_86_fackeaccpointsubchar/actor.bmsad",
    "cutscenes/0086commanderorbital/actors/samus_facial/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/chozocommander_wing/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/drop_life_cutsubchar/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/drop_life_cut_2/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/drop_life_cut_3/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/drop_life_cut_4/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/missile_cut/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/missile_cut_2/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/missile_cut_3/actor.bmsad",
    "cutscenes/0101commanderlosehiswings/actors/missile_cut_4/actor.bmsad",
    "cutscenes/0101commanderlosehiswings_left/actors/chozocommander_wing/actor.bmsad",
    "cutscenes/0101commanderlosehiswings_right/actors/chozocommander_wing/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/shipyardrock01/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/shipyardrock02/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/shipyardrock03/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/shipyardrock06/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/shipyardrock07/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/skybase/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/skybaseclouds/actor.bmsad",
    "cutscenes/0108fallofskybase/actors/skybaseclouds_b/actor.bmsad",
    "cutscenes/0108shipyard/actors/chozocommanderx/actor.bmsad",
    "cutscenes/0108shipyard/actors/chozocommander_2/actor.bmsad",
    "cutscenes/0110commanderxdeath/actors/core_x/actor.bmsad",
    "cutscenes/0112endgame/actors/chozoprofessor/actor.bmsad",
    "cutscenes/0112endgame/actors/planetzdr/actor.bmsad",
    "cutscenes/0112endgame/actors/planetzdr_background/actor.bmsad",
    "cutscenes/0112endgame/actors/planetzdr_background_plane/actor.bmsad",
    "cutscenes/0112endgame/actors/samuship_int/actor.bmsad",
    "cutscenes/0112endgame/actors/samus_facial/actor.bmsad",
    "cutscenes/0112endgame/actors/samus_ship_b/actor.bmsad",
    "cutscenes/0112endgame/actors/samus_ship_ssubchar/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_1/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_10/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_11/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_12/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_13/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_14/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_15/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_2/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_3/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_4/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_5/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_6/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_7/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_8/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/camersanc_9/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/ev_gatesealed/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/ev_gatesealed_aut_001/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/ev_gatesealed_closedsubchar/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/ev_quarantine_roomlights/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/quarantinebridge/actor.bmsad",
    "cutscenes/0113quarantinearrival/actors/quarantinebridge_2/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/drop_life_cutsubchar/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/drop_life_cut_2/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/drop_life_cut_3/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/missile_cut/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/missile_cut_2/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/missile_cut_3/actor.bmsad",
    "cutscenes/0155scorpiusphase3/actors/missile_cut_4/actor.bmsad",
    "cutscenes/100commandershowswings/actors/cut_100_comandercap/actor.bmsad"
]

expected_failures = {
    "actors/props/pf_mushr_fr/charclasses/pf_mushr_fr.bmsad",
}


@pytest.mark.parametrize("bmsad_path", all_bmsad)
def test_compare_dread_all(dread_file_tree, bmsad_path):
    if bmsad_path in expected_failures:
        expectation = pytest.raises(construct.ConstructError)
    else:
        expectation = contextlib.nullcontext()

    with expectation:
        parse_build_compare_editor(
            BMSAD, dread_file_tree, bmsad_path
        )


def test_compare_dread(dread_path):
    parse_and_build_compare(
        BMSAD, Game.DREAD,
        dread_path.joinpath("actors/items/itemsphere_plasmabeam/charclasses/itemsphere_plasmabeam.bmsad"), True
    )
