# coding:utf-8

import matplotlib

matplotlib.use('Agg')

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator
import numpy as np

t = range(-100, 100)
s = abs(np.random.randn(len(t)))
fig = plt.gcf()
relative_site = 500
transcript_id = "test"

fig.set_size_inches(10.5, 10.5)

plt.subplot(611)
plt.axis([min(t), max(t), min(s), max(s)])
plt.bar(t, s, width=1)
# plt.xlabel('time (s)')
plt.ylabel('Wild type cmc+')
plt.title('Average_Peak = %.5f' % 1.11111111)
ax = plt.gca()
xmajorLocator = MultipleLocator(10)
ax.xaxis.set_major_locator(xmajorLocator)
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.yticks([])
plt.xticks([])
plt.grid(False)
line = ax.axvline(x=0, color='r', linewidth=1, linestyle="--")

plt.subplot(612)
plt.axis([min(t), max(t), min(s), max(s)])
plt.bar(t, s, width=1)
# plt.xlabel('time (s)')
plt.ylabel('Wild type cmc-')
plt.title(u'Ψ ' + str(relative_site))
ax = plt.gca()
xmajorLocator = MultipleLocator(10)
ax.xaxis.set_major_locator(xmajorLocator)
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.yticks([])
plt.xticks([])
plt.grid(False)
line = ax.axvline(x=0, color='r', linewidth=1, linestyle="--")

plt.subplot(613)
plt.title(transcript_id + " " + str(relative_site + min(t)) + "-" + str(relative_site + max(t)))
plt.yticks([])
plt.xticks([])
ax = plt.gca()
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.spines['bottom'].set_visible(False)
plt.grid(False)

plt.subplot(614)
plt.axis([min(t), max(t), min(s), max(s)])
plt.bar(t, s, width=1)
# plt.xlabel('time (s)')
plt.ylabel('Mutant type cmc+')
plt.title('Average_Peak = %.5f' % 1.111111111)
ax = plt.gca()
xmajorLocator = MultipleLocator(10)
ax.xaxis.set_major_locator(xmajorLocator)
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.yticks([])
plt.xticks([])
plt.grid(False)
line = ax.axvline(x=0, color='r', linewidth=1, linestyle="--")

plt.subplot(615)
plt.axis([min(t), max(t), min(s), max(s)])
plt.bar(t, s, width=1)
# plt.xlabel('time (s)')
plt.ylabel('Mutant type cmc-')
plt.title(u'Ψ ' + str(relative_site))
ax = plt.gca()
xmajorLocator = MultipleLocator(10)
ax.xaxis.set_major_locator(xmajorLocator)
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
plt.yticks([])
plt.xticks([])
plt.grid(False)
line = ax.axvline(x=0, color='r', linewidth=1, linestyle="--")

plt.subplot(616)
plt.title(transcript_id + " " + str(relative_site + min(t)) + "-" + str(relative_site + max(t)))
plt.yticks([])
plt.xticks([])
ax = plt.gca()
ax.spines['left'].set_visible(False)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.spines['bottom'].set_visible(False)
plt.grid(False)
plt.subplots_adjust(hspace=0.5)
plt.savefig(transcript_id + "_" + str(relative_site) + '.pdf', dpi=1000)

plt.show()
