"""
This type stub file was generated by pyright.
"""

from typing import Optional
from datasets import DownloadConfig

""" List and inspect metrics."""
logger = ...
class SplitsNotFoundError(ValueError):
    ...


def list_evaluation_modules(module_type=..., include_community=..., with_details=...): # -> list[dict[str, Any | Unknown]] | list[Any]:
    """List all evaluation modules available on the Hugging Face Hub.

    Args:
        module_type (`str`, *optional*, default `None`): Type of evaluation modules to list. Has to be one of `'metric'`, `'comparison'`, or `'measurement'`. If `None`, all types are listed.
        include_community (`bool`, *optional*, default `True`): Include community modules in the list.
        with_details (`bool`, *optional*, default `False`): Return the full details on the metrics instead of only the ID.

    Returns:
        `List[Union[str, dict]]`
    """
    ...

def inspect_evaluation_module(path: str, local_path: str, download_config: Optional[DownloadConfig] = ..., **download_kwargs): # -> None:
    r"""
    Allow inspection/modification of a evaluation script by copying it on local drive at local_path.

    Args:
        path (``str``): path to the evaluation script. Can be either:

            - a local path to script or the directory containing the script (if the script has the same name as the directory),
                e.g. ``'./metrics/accuracy'`` or ``'./metrics/accuracy/accuracy.py'``
            - a dataset identifier on the Hugging Face Hub (list all available datasets and ids with ``evaluate.list_evaluation_modules()``)
                e.g. ``'accuracy'``, ``'bleu'`` or ``'word_length'``
        local_path (``str``): path to the local folder to copy the datset script to.
        download_config (Optional ``datasets.DownloadConfig``: specific download configuration parameters.
        **download_kwargs: optional attributes for DownloadConfig() which will override the attributes in download_config if supplied.
    """
    ...

