# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AccessTokenList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, service_sid):
        """
        Initialize the AccessTokenList

        :param Version version: Version that contains the resource
        :param service_sid: The unique string that identifies the resource

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenList
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenList
        """
        super(AccessTokenList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/AccessTokens'.format(**self._solution)

    def create(self, identity, factor_type, factor_friendly_name=values.unset):
        """
        Create the AccessTokenInstance

        :param unicode identity: Unique external identifier of the Entity
        :param AccessTokenInstance.FactorTypes factor_type: The Type of this Factor
        :param unicode factor_friendly_name: The factor friendly name

        :returns: The created AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        data = values.of({
            'Identity': identity,
            'FactorType': factor_type,
            'FactorFriendlyName': factor_friendly_name,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return AccessTokenInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.AccessTokenList>'


class AccessTokenPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the AccessTokenPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The unique string that identifies the resource

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenPage
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenPage
        """
        super(AccessTokenPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AccessTokenInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        return AccessTokenInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.AccessTokenPage>'


class AccessTokenInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class FactorTypes(object):
        PUSH = "push"

    def __init__(self, version, payload, service_sid):
        """
        Initialize the AccessTokenInstance

        :returns: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        :rtype: twilio.rest.verify.v2.service.access_token.AccessTokenInstance
        """
        super(AccessTokenInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'token': payload.get('token'), }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, }

    @property
    def token(self):
        """
        :returns: Generated access token.
        :rtype: unicode
        """
        return self._properties['token']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.AccessTokenInstance>'
