# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.media.v1.media_processor import MediaProcessorList
from twilio.rest.media.v1.player_streamer import PlayerStreamerList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Media

        :returns: V1 version of Media
        :rtype: twilio.rest.media.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._media_processor = None
        self._player_streamer = None

    @property
    def media_processor(self):
        """
        :rtype: twilio.rest.media.v1.media_processor.MediaProcessorList
        """
        if self._media_processor is None:
            self._media_processor = MediaProcessorList(self)
        return self._media_processor

    @property
    def player_streamer(self):
        """
        :rtype: twilio.rest.media.v1.player_streamer.PlayerStreamerList
        """
        if self._player_streamer is None:
            self._player_streamer = PlayerStreamerList(self)
        return self._player_streamer

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Media.V1>'
