# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.insights.v1 import V1


class Insights(Domain):

    def __init__(self, twilio):
        """
        Initialize the Insights Domain

        :returns: Domain for Insights
        :rtype: twilio.rest.insights.Insights
        """
        super(Insights, self).__init__(twilio)

        self.base_url = 'https://insights.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of insights
        :rtype: twilio.rest.insights.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def settings(self):
        """
        :rtype: twilio.rest.insights.v1.setting.SettingList
        """
        return self.v1.settings

    @property
    def calls(self):
        """
        :rtype: twilio.rest.insights.v1.call.CallList
        """
        return self.v1.calls

    @property
    def call_summaries(self):
        """
        :rtype: twilio.rest.insights.v1.call_summaries.CallSummariesList
        """
        return self.v1.call_summaries

    @property
    def rooms(self):
        """
        :rtype: twilio.rest.insights.v1.room.RoomList
        """
        return self.v1.rooms

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Insights>'
