import Template from 'cloudform-types/types/template';
import { StringParameter, NumberParameter } from 'cloudform-types';
import { AuthRule, AuthProvider } from './AuthRule';
import { Expression } from 'graphql-mapping-template';
import GraphQLApi from 'cloudform-types/types/appSync/graphQlApi';
import * as Transformer from './ModelAuthTransformer';
import { FieldDefinitionNode } from 'graphql';
import ManagedPolicy from 'cloudform-types/types/iam/managedPolicy';
export declare class ResourceFactory {
    makeParams(): {
        [x: string]: StringParameter | NumberParameter;
    };
    initTemplate(apiKeyConfig: Transformer.ApiKeyConfig): Template;
    makeAppSyncApiKey(apiKeyConfig: Transformer.ApiKeyConfig): import("cloudform-types/types/appSync/apiKey").default;
    makeApiKeyOutput(): any;
    updateGraphQLAPIWithAuth(apiRecord: GraphQLApi, authConfig: Transformer.AppSyncAuthConfiguration): GraphQLApi;
    private assignOpenIDConnectConfig;
    blankResolver(type: string, field: string): import("cloudform-types/types/appSync/resolver").default;
    noneDataSource(): import("cloudform-types/types/appSync/dataSource").default;
    staticGroupAuthorizationExpression(rules: AuthRule[], field?: FieldDefinitionNode): Expression;
    dynamicGroupAuthorizationExpressionForCreateOperations(rules: AuthRule[], variableToCheck?: string, variableToSet?: string): Expression;
    dynamicGroupAuthorizationExpressionForCreateOperationsByField(rules: AuthRule[], fieldToCheck: string, variableToCheck?: string, variableToSet?: string): Expression;
    private dynamicAuthorizationExpressionForCreate;
    ownerAuthorizationExpressionForCreateOperations(rules: AuthRule[], fieldIsList: (fieldName: string) => boolean, variableToCheck?: string, variableToSet?: string): Expression;
    ownerAuthorizationExpressionForSubscriptions(rules: AuthRule[], variableToCheck?: string, variableToSet?: string): Expression;
    ownershipAuthorizationExpressionForSubscriptions(rules: AuthRule[], variableToCheck?: string, variableToSet?: string, formatComment?: (rule: AuthRule) => string): import("graphql-mapping-template").CompoundExpressionNode;
    ownerAuthorizationExpressionForCreateOperationsByField(rules: AuthRule[], fieldToCheck: string, fieldIsList: (fieldName: string) => boolean, variableToCheck?: string, variableToSet?: string): Expression;
    ownershipAuthorizationExpressionForCreate(rules: AuthRule[], fieldIsList: (fieldName: string) => boolean, variableToCheck?: string, variableToSet?: string, formatComment?: (rule: AuthRule) => string): import("graphql-mapping-template").CompoundExpressionNode;
    dynamicGroupAuthorizationExpressionForUpdateOrDeleteOperations(rules: AuthRule[], fieldIsList: (fieldName: string) => boolean, fieldBeingProtected?: string, variableToCheck?: string, variableToSet?: string): Expression;
    ownerAuthorizationExpressionForUpdateOrDeleteOperations(rules: AuthRule[], fieldIsList: (fieldName: string) => boolean, fieldBeingProtected?: string, variableToCheck?: string, variableToSet?: string): Expression;
    dynamicGroupAuthorizationExpressionForReadOperations(rules: AuthRule[], variableToCheck?: string, variableToSet?: string, defaultValue?: Expression): Expression;
    ownerAuthorizationExpressionForReadOperations(rules: AuthRule[], variableToCheck?: string, variableToSet?: string, defaultValue?: Expression): Expression;
    throwIfSubscriptionUnauthorized(): Expression;
    throwIfUnauthorized(field?: FieldDefinitionNode): Expression;
    returnIfEmpty(objectPath: string): Expression;
    throwIfStaticGroupUnauthorized(field?: FieldDefinitionNode): Expression;
    throwIfNotStaticGroupAuthorizedOrAuthConditionIsEmpty(field?: FieldDefinitionNode): Expression;
    collectAuthCondition(): Expression;
    appendItemIfLocallyAuthorized(): Expression;
    setUserGroups(customGroup?: string): Expression;
    generateSubscriptionResolver(fieldName: string, subscriptionTypeName?: string): import("cloudform-types/types/appSync/resolver").default;
    operationCheckExpression(operation: string, field: FieldDefinitionNode): import("graphql-mapping-template").CompoundExpressionNode;
    setOperationExpression(operation: string): string;
    getAuthModeCheckWrappedExpression(expectedAuthModes: Set<AuthProvider>, expression: Expression): Expression;
    getAuthModeDeterminationExpression(authProviders: Set<AuthProvider>, isUserPoolTheDefault: boolean): Expression;
    getStaticAuthorizationVariable(field: FieldDefinitionNode): string;
    makeIAMPolicyForRole(isAuthPolicy: Boolean, resources: Set<string>): ManagedPolicy[];
    makeESItemsExpression(includeVersion: boolean): import("graphql-mapping-template").CompoundExpressionNode;
    private getSourceMapper;
    makeESToGQLExpression(): import("graphql-mapping-template").CompoundExpressionNode;
}
//# sourceMappingURL=resources.d.ts.map