/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis.rdd;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.partitioner.RedisPartition;
import com.redislabs.provider.redis.rdd.Keys;
import com.redislabs.provider.redis.util.ParseUtils$;
import com.redislabs.provider.redis.util.PipelineUtils$;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import redis.clients.jedis.Jedis;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\tQ!+\u001a3jg.3&\u000b\u0012#\u000b\u0005\r!\u0011a\u0001:eI*\u0011QAB\u0001\u0006e\u0016$\u0017n\u001d\u0006\u0003\u000f!\t\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003\u0013)\t\u0011B]3eSNd\u0017MY:\u000b\u0003-\t1aY8n\u0007\u0001\u00192\u0001\u0001\b+!\ryq#G\u0007\u0002!)\u00111!\u0005\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO&\u0011\u0001\u0004\u0005\u0002\u0004%\u0012#\u0005\u0003\u0002\u000e\u001e?}i\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0001:cBA\u0011&!\t\u00113$D\u0001$\u0015\t!C\"\u0001\u0004=e>|GOP\u0005\u0003Mm\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011ae\u0007\t\u0003W1j\u0011AA\u0005\u0003[\t\u0011AaS3zg\"Aq\u0006\u0001B\u0001B\u0003%\u0001'\u0001\u0003qe\u00164\bcA\b\u0018?!A!\u0007\u0001BC\u0002\u0013\u00051'A\u0004sI\u0012$\u0016\u0010]3\u0016\u0003}A\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IaH\u0001\te\u0012$G+\u001f9fA!Aq\u0007\u0001BC\u0002\u0013\r\u0001(A\bsK\u0006$wK]5uK\u000e{gNZ5h+\u0005I\u0004C\u0001\u001e<\u001b\u0005!\u0011B\u0001\u001f\u0005\u0005=\u0011V-\u00193Xe&$XmQ8oM&<\u0007\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002!I,\u0017\rZ,sSR,7i\u001c8gS\u001e\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005CA\u0016\u0001\u0011\u0015ys\b1\u00011\u0011\u0015\u0011t\b1\u0001 \u0011\u00159t\bq\u0001:\u0011\u00159\u0005\u0001\"\u0011I\u000359W\r\u001e)beRLG/[8ogV\t\u0011\nE\u0002\u001b\u00152K!aS\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u00055sU\"A\t\n\u0005=\u000b\"!\u0003)beRLG/[8o\u0011\u0015\t\u0006\u0001\"\u0011S\u0003\u001d\u0019w.\u001c9vi\u0016$2a\u0015/_!\r!\u0016,\u0007\b\u0003+^s!A\t,\n\u0003qI!\u0001W\u000e\u0002\u000fA\f7m[1hK&\u0011!l\u0017\u0002\t\u0013R,'/\u0019;pe*\u0011\u0001l\u0007\u0005\u0006;B\u0003\r\u0001T\u0001\u0006gBd\u0017\u000e\u001e\u0005\u0006?B\u0003\r\u0001Y\u0001\bG>tG/\u001a=u!\ti\u0015-\u0003\u0002c#\tYA+Y:l\u0007>tG/\u001a=u\u0011\u0015!\u0007\u0001\"\u0001f\u0003\u00159W\r^&W)\r\u0019f\r\u001c\u0005\u0006O\u000e\u0004\r\u0001[\u0001\u0006]>$Wm\u001d\t\u00045)K\u0007C\u0001\u001ek\u0013\tYGAA\u0005SK\u0012L7OT8eK\")Qn\u0019a\u0001]\u0006!1.Z=t!\r!\u0016l\b\u0005\u0006a\u0002!\t!]\u0001\bO\u0016$\b*Q*I)\r\u0019&o\u001d\u0005\u0006O>\u0004\r\u0001\u001b\u0005\u0006[>\u0004\rA\u001c")
public class RedisKVRDD
extends RDD<Tuple2<String, String>>
implements Keys {
    private final RDD<String> prev;
    private final String rddType;
    private final ReadWriteConfig readWriteConfig;

    @Override
    public boolean isRedisRegex(String key) {
        return Keys.isRedisRegex$(this, key);
    }

    @Override
    public Iterator<String> getKeys(RedisNode[] nodes, int sPos, int ePos, String keyPattern, ReadWriteConfig readWriteConfig) {
        return Keys.getKeys$(this, nodes, sPos, ePos, keyPattern, readWriteConfig);
    }

    @Override
    public RedisNode getMasterNode(RedisNode[] nodes, String key) {
        return Keys.getMasterNode$(this, nodes, key);
    }

    @Override
    public Iterator<Tuple2<RedisNode, String[]>> groupKeysByNode(RedisNode[] nodes, Iterator<String> keys) {
        return Keys.groupKeysByNode$(this, nodes, keys);
    }

    @Override
    public String[] filterKeysByType(Jedis conn, String[] keys, String t, ReadWriteConfig readWriteConfig) {
        return Keys.filterKeysByType$(this, conn, keys, t, readWriteConfig);
    }

    public String rddType() {
        return this.rddType;
    }

    public ReadWriteConfig readWriteConfig() {
        return this.readWriteConfig;
    }

    public Partition[] getPartitions() {
        return this.prev.partitions();
    }

    public Iterator<Tuple2<String, String>> compute(Partition split, TaskContext context) {
        Iterator<Tuple2<String, String>> iterator;
        RedisPartition partition = (RedisPartition)split;
        int sPos = partition.slots()._1$mcI$sp();
        int ePos = partition.slots()._2$mcI$sp();
        RedisNode[] nodes = partition.redisConfig().getNodesBySlots(sPos, ePos);
        Iterator keys = this.firstParent(ClassTag$.MODULE$.apply(String.class)).iterator(split, context);
        String auth = partition.redisConfig().getAuth();
        int db = partition.redisConfig().getDB();
        String string = this.rddType();
        if ("kv".equals(string)) {
            iterator = this.getKV(nodes, (Iterator<String>)keys);
        } else if ("hash".equals(string)) {
            iterator = this.getHASH(nodes, (Iterator<String>)keys);
        } else {
            throw new MatchError((Object)string);
        }
        return iterator;
    }

    public Iterator<Tuple2<String, String>> getKV(RedisNode[] nodes, Iterator<String> keys) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            Seq<Object> response = PipelineUtils$.MODULE$.mapWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)), (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
                pipeline.get(key);
                return BoxedUnit.UNIT;
            }, this.readWriteConfig());
            Iterator res = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)).zip(response, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Object e;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null && (e = tuple2._2()) instanceof Throwable) {
                    Throwable throwable = (Throwable)e;
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Failure(throwable)));
                }
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                if (!(v instanceof String)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String string = (String)v;
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Success((Object)new Tuple2((Object)k, (Object)string))));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Try.class))))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable((Option)ParseUtils$.MODULE$.ignoreJedisWrongTypeException(x$1).get()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).iterator();
            conn.close();
            Iterator iterator = res;
            return iterator;
        });
    }

    public Iterator<Tuple2<String, String>> getHASH(RedisNode[] nodes, Iterator<String> keys) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            Iterator res = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> Option$.MODULE$.option2Iterable((Option)ParseUtils$.MODULE$.ignoreJedisWrongTypeException(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(conn.hgetAll((String)k)).toMap(Predef$.MODULE$.$conforms()))).get()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class))))).flatten((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(Tuple2.class)))).iterator();
            conn.close();
            Iterator iterator = res;
            return iterator;
        });
    }

    public RedisKVRDD(RDD<String> prev, String rddType, ReadWriteConfig readWriteConfig) {
        this.prev = prev;
        this.rddType = rddType;
        this.readWriteConfig = readWriteConfig;
        super(prev, ClassTag$.MODULE$.apply(Tuple2.class));
        Keys.$init$(this);
    }
}

