/*
 * Decompiled with CFR 0.152.
 */
package sklearn.neighbors;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.jpmml.converter.Schema;
import sklearn.Regressor;
import sklearn.neighbors.HasNeighbors;
import sklearn.neighbors.HasTrainingData;
import sklearn.neighbors.KNeighborsUtil;

public class KNeighborsRegressor
extends Regressor
implements HasNeighbors,
HasTrainingData {
    public KNeighborsRegressor(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getFitXShape();
        return shape[1];
    }

    @Override
    public int getNumberOfOutputs() {
        return KNeighborsUtil.getNumberOfOutputs(this);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public NearestNeighborModel encodeModel(Schema schema) {
        int[] shape = this.getFitXShape();
        int numberOfInstances = shape[0];
        int numberOfFeatures = shape[1];
        NearestNeighborModel nearestNeighborModel = KNeighborsUtil.encodeNeighbors(this, MiningFunction.REGRESSION, numberOfInstances, numberOfFeatures, schema).setContinuousScoringMethod(NearestNeighborModel.ContinuousScoringMethod.AVERAGE);
        return nearestNeighborModel;
    }

    @Override
    public String getMetric() {
        return this.getString("metric");
    }

    @Override
    public int getNumberOfNeighbors() {
        return this.getInteger("n_neighbors");
    }

    @Override
    public int getP() {
        return this.getInteger("p");
    }

    @Override
    public String getWeights() {
        return this.getString("weights");
    }

    @Override
    public List<? extends Number> getFitX() {
        return this.getNumberArray("_fit_X");
    }

    @Override
    public int[] getFitXShape() {
        return this.getArrayShape("_fit_X", 2);
    }

    @Override
    public List<? extends Number> getY() {
        return this.getNumberArray("_y");
    }

    @Override
    public int[] getYShape() {
        return this.getArrayShape("_y");
    }
}

