# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['baidupcs_py',
 'baidupcs_py.app',
 'baidupcs_py.baidupcs',
 'baidupcs_py.commands',
 'baidupcs_py.common']

package_data = \
{'': ['*']}

install_requires = \
['Cython>=0.29.21,<0.30.0',
 'Jinja2>=2.11.3,<3.0.0',
 'Pillow>=8.1.0,<9.0.0',
 'aget>=0.1.17,<0.2.0',
 'chardet>=4.0.0,<5.0.0',
 'click>=7.1.2,<8.0.0',
 'cryptography>=3.4.5,<4.0.0',
 'fastapi>=0.63.0,<0.64.0',
 'filelock>=3.0.12,<4.0.0',
 'passlib>=1.7.4,<2.0.0',
 'requests-toolbelt>=0.9.1,<0.10.0',
 'requests>=2.25.1,<3.0.0',
 'rich>=9.11.0,<10.0.0',
 'typing-extensions>=3.7.4,<4.0.0',
 'uvicorn[standard]>=0.13.3,<0.14.0']

entry_points = \
{'console_scripts': ['BaiduPCS-Py = baidupcs_py.app:main']}

setup_kwargs = {
    'name': 'baidupcs-py',
    'version': '0.6.6',
    'description': 'Baidu Pcs App',
    'long_description': '# BaiduPCS-Py\n\n[![PyPI version](https://badge.fury.io/py/baidupcs-py.svg)](https://badge.fury.io/py/baidupcs-py)\n![Build](https://github.com/PeterDing/BaiduPCS-Py/workflows/BaiduPCS-Py%20Build%20&%20Test/badge.svg)\n[![Gitter](https://badges.gitter.im/PeterDing/BaiduPCS-Py.svg)](https://gitter.im/PeterDing/BaiduPCS-Py?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)\n\nA BaiduPCS API and An App\n\nBaiduPCS-Py 是百度网盘 pcs 的非官方 api 和一个命令行运用程序。\n\n> 也是 https://github.com/PeterDing/iScript/blob/master/pan.baidu.com.py 的重构版。\n\n- [安装](#安装)\n- [API](#API)\n- [用法](#用法)\n- [命令别名](#命令别名)\n- [对多个帐号进行相同操作](#对多个帐号进行相同操作)\n\n#### 用户相关命令\n\n- [添加用户](#添加用户)\n- [设置文件加密密码](#设置文件加密密码)\n- [显示当前用户的信息](#显示当前用户的信息)\n- [更新用户信息](#更新用户信息)\n- [显示所有用户](#显示所有用户)\n- [切换当前用户](#切换当前用户)\n- [删除一个用户](#删除一个用户)\n- [显示当前工作目录](#显示当前工作目录)\n- [切换当前工作目录](#切换当前工作目录)\n\n#### 文件操作相关命令\n\n- [文件操作](#文件操作)\n- [列出网盘路径下的文件](#列出网盘路径下的文件)\n- [搜索文件](#搜索文件)\n- [显示文件内容](#显示文件内容)\n- [创建目录](#创建目录)\n- [移动文件](#移动文件)\n- [文件重命名](#文件重命名)\n- [拷贝文件](#拷贝文件)\n- [删除文件](#删除文件)\n- [下载文件](#下载文件)\n- [播放媒体文件](#播放媒体文件)\n- [上传文件](#上传文件)\n- [同步本地目录到远端](#同步本地目录到远端)\n\n#### 秒传相关命令\n\n- [关于秒传](#关于秒传)\n- [显示网盘中文件的秒传连接](#显示网盘中文件的秒传连接)\n- [列出保存的文件秒传信息](#列出保存的文件秒传信息)\n- [搜索保存的文件秒传信息](#搜索保存的文件秒传信息)\n- [用秒传连接或参数上传](#用秒传连接或参数上传)\n\n#### 分享相关命令\n\n- [分享文件](#分享文件)\n- [列出分享链接](#列出分享链接)\n- [取消分享链接](#取消分享链接)\n- [列出其他用户分享链接中的文件](#列出其他用户分享链接中的文件)\n- [保存其他用户分享的链接](#保存其他用户分享的链接)\n\n#### 离线下载相关命令\n\n- [添加离线下载任务](#添加离线下载任务)\n- [列出离线下载任务](#列出离线下载任务)\n- [清除已经下载完和下载失败的任务](#清除已经下载完和下载失败的任务)\n- [取消下载任务](#取消下载任务)\n- [删除所有离线下载任务](#删除所有离线下载任务)\n\n#### HTTP 服务\n\n- [开启 HTTP 服务](#开启-HTTP-服务)\n\n## 安装\n\n需要 Python 版本大于或等于 3.7\n\n```\npip3 install BaiduPCS-Py\n```\n\n## API\n\nBaiduPCS-Py 的百度网盘 API 只依赖 requests，方便用户开发自己的运用。\n\n```python\nfrom baidupcs_py.baidupcs import BaiduPCSApi\n\napi = BaiduPCSApi(bduss=bduss, cookies=cookies)\n```\n\n## 用法\n\n```\nBaiduPCS-Py --help\n```\n\n## 命令别名\n\n可以用下面的命令别名代替原来的命令名。\n\n| 别名 | 原名            |\n| ---- | --------------- |\n| w    | who             |\n| uu   | updateuser      |\n| su   | su              |\n| ul   | userlist        |\n| ua   | useradd         |\n| ep   | encryptpwd      |\n| ud   | userdel         |\n| l    | ls              |\n| f    | search          |\n| md   | mkdir           |\n| mv   | move            |\n| rn   | rename          |\n| cp   | copy            |\n| rm   | remove          |\n| d    | download        |\n| p    | play            |\n| u    | upload          |\n| sn   | sync            |\n| rl   | rplist          |\n| rs   | rpsearch        |\n| rp   | rp              |\n| S    | share           |\n| sl   | shared          |\n| cs   | cancelshared    |\n| lsp  | listsharedpaths |\n| s    | save            |\n| a    | add             |\n| t    | tasks           |\n| ct   | cleartasks      |\n| cct  | canceltasks     |\n| sv   | server          |\n\n## 对多个帐号进行相同操作\n\nBaiduPCS-Py 支持对多个帐号进行相同操作。比如，用相同关键字搜索多个帐号，上传相同的文件/目录到多个帐号，等等。\n\n使用者只需用 `--users` 选项来指定要操作的帐号名即可。\n\n`--users` 接受一个参数，这个参数是用“,”连接的要进行操作帐号名的部分字符。假设我们现在有 3 个帐号，帐号名分别是 `Tom`，`Peter`，`Joy`。\n现在我要同时对`Tom`和`Joy`进行关键字搜索。我们可以用下面的命令进行：\n\n```\nBaiduPCS-Py --users \'Tom,Joy\' search \'keyword\' / -R\n```\n\n或者给出帐号名的部分片段：\n\n```\nBaiduPCS-Py --users \'om,oy\' search \'keyword\' / -R\n```\n\n更简单可以用：\n\n```\n# Tom, Joy 都包含字符 "o"\nBaiduPCS-Py --users \'o\' search \'keyword\' / -R\n```\n\n如果要对所有帐号进行操作用 `--users \'\'`。\n\n如果不使用 `--users` 选项，默认只对当前帐号进行操作。\n\n以下命令支持对多个帐号进行操作：\n\n- pwd\n- ls\n- search\n- cat\n- mkdir\n- move\n- rename\n- copy\n- remove\n- download\n- play\n- upload\n- sync\n- rp\n- share\n- shared\n- cancelshared\n- save\n- add\n- tasks\n- cleartasks\n- canceltasks\n- purgetasks\n- server\n\n**注意**: `--users` 一定要跟在 `BaiduPCS-Py` 后，命令前。\n\n## 添加用户\n\nBaiduPCS-Py 目前不支持用帐号登录。需要使用者在 pan.baidu.com 登录后获取 cookies 和其中的 bduss 值，并用命令 `useradd` 为 BaiduPCS-Py 添加一个用户。\n\n使用者可以用下面的方式获取用户的 cookies 和 bduss 值。\n\n1. 登录 pan.baidu.com\n2. 打开浏览器的开发者工具(如 Chrome DevTools)。\n3. 然后选择开发者工具的 Network 面板。\n4. 在登录后的页面中任意点开一个文件夹。\n5. 在 Network 面板中找到 `list?....` 一行，然后在右侧的 Headers 部分找到 `Cookie:` 所在行，复制 `Cookie:` 后的所有内容作为 cookies 值，其中的 `BDUSS=...;` 的 `...` (没有最后的字符;)作为 bduss 值。\n\n![cookies](./imgs/cookies.png)\n\n现在找到了 cookies 和 bduss 值，我们可以用下面的命令添加一个用户。\n\n交互添加：\n\n```\nBaiduPCS-Py useradd\n```\n\n或者直接添加：\n\n```\nBaiduPCS-Py useradd --cookies "cookies 值" --bduss "bduss 值"\n```\n\n你也可以只添加 `bduss`，省去 `cookies` (或 `cookies` 中没有 `STOKEN` 值)，但这会让你无发使用 `share` 和 `save` 命令来转存其他用法的分享文件。\n\nBaiduPCS-Py 支持多用户，你只需一直用 `useradd` 来添加用户即可。\n\n## 设置文件加密密码\n\n> **注意**： `v0.5.17` 加密的文件格式(Version 2)不兼容以后的版本。\n\nBaiduPCS-Py 支持“无感的”文件加密。\n\nBaiduPCS-Py 可以加密上传文件，在下载的时候自动解密，让使用者感觉不到加密解密的过程。\n\n如果使用者需要将保密文件上传至百度网盘保存，可以使用这个方法。即使帐号被盗，攻击者也无法还原文件内容。\n\nBaiduPCS-Py 支持以下加密方法：\n\n- **Simple** 一种简单的加密算法。根据密钥生成一个字节对照表来加密解密文件。\n  速度快，但**不安全**，不建议加密重要文件。\n  因为这种算法加解密不需要知道上下文信息，所以，下载时支持分段下载，如果是媒体文件则支持拖动播放。\n  推荐用于加密不重要的媒体文件。\n- **ChaCha20** 工业级加密算法，速度快，推荐用于加密重要文件。不支持分段下载。\n- **AES256CBC** 工业级加密算法，推荐用于加密重要文件。不支持分段下载。\n\n**注意**：用命令 `encryptpwd` 设置的密码**只是为当前用户**的。\n\n为当前用户设置加密密码:\n\n交互添加：\n\n```\nBaiduPCS-Py encryptpwd\n```\n\n或者直接添加：\n\n```\nBaiduPCS-Py encryptpwd --encrypt-password \'my-encrypt-password\'\n```\n\n上传并加密文件：\n\n上传和同步文件时只需要指定加密算法就可。如果不指定就不加密。\n\n```\n# 默认使用上面设置的 `encrypt-password`\nBaiduPCS-Py upload some-file.mp4 some-dir/ /to/here --encrypt-type AES256CBC\n```\n\n下载并用上面设置的 `encrypt-password` 自动解密文件：\n\n```\nBaiduPCS-Py download /to/here/some-file.mp4 /to/here/some-dir/\n```\n\n也可以使用临时的 `encrypt-password`：\n\n```\nBaiduPCS-Py upload some-file.mp4 some-dir/ /to/here --encrypt-type Simple --encrypt-password \'onlyyou\'\n```\n\n但在使用临时的 `encrypt-password` 后，`cat`、下载和播放这些文件时需要指定 `encrypt-password`，但不需要指定加密算法，程序会自动检查加密算法：\n\n```\n# 下载\nBaiduPCS-Py download /to/here/some-file.mp4 /to/here/some-dir/  --encrypt-password \'onlyyou\'\n\n# 开启本地服务并播放\nBaiduPCS-Py play /to/here/some-file.mp4 --encrypt-password \'onlyyou\' --use-local-server\n```\n\n显示当前用户的密钥：\n\n```\nBaiduPCS-Py who --show-encrypt-password\n```\n\nBaiduPCS-Py 下载时默认会解密文件，如果想要下载但不解密文件，需要加 `--no-decrypt`\n\n```\nBaiduPCS-Py download some-file --no-decrypt\n```\n\n## 显示当前用户的信息\n\n```\nBaiduPCS-Py who\n```\n\n或者：\n\n```\nBaiduPCS-Py who user_id\n```\n\n指明显示用户 id 为 `user_id` 的用户信息。\n\n### 选项\n\n| Option                      | Description  |\n| --------------------------- | ------------ |\n| -K, --show-encrypt-password | 显示加密密码 |\n\n## 更新用户信息\n\n默认更新当前用户信息。\n\n```\nBaiduPCS-Py updateuser\n```\n\n也可指定多个 `user_id`\n\n```\nBaiduPCS-Py updateuser user_id\n```\n\n## 显示所有用户\n\n```\nBaiduPCS-Py userlist\n```\n\n## 切换当前用户\n\n```\nBaiduPCS-Py su\n```\n\n## 删除一个用户\n\n```\nBaiduPCS-Py userdel\n```\n\n## 文件操作\n\nBaiduPCS-Py 操作网盘中的文件可以使用文件的绝对路径或相对路径（相对与当前目录 pwd）。\n\n每一个用户都有自己的当前工作目录（pwd），默认为 `/` 根目录。\n\n使用者可以用 `cd` 命令来切换当前的工作目录（pwd）。\n\n下面所有涉及网盘路径的命令，其中如果网盘路径用的是相对路径，那么是相对于当前工作目录（pwd）的。\n如果是网盘路径用的是绝对路径，那么就是这个绝对路径。\n\n## 显示当前工作目录\n\n```\nBaiduPCS-Py pwd\n```\n\n## 切换当前工作目录\n\n切换到绝对路径：\n\n```\nBaiduPCS-Py cd /to/some/path\n```\n\n切换到相对路径：\n\n```\n# 切换到 (pwd)/../path\nBaiduPCS-Py cd ../path\n```\n\n## 列出网盘路径下的文件\n\n```\nBaiduPCS-Py ls [OPTIONS] [REMOTEPATHS]...\n\nBaiduPCS-Py ls /absolute/path\n\n# or\nBaiduPCS-Py ls relative/path\n```\n\n### 选项\n\n| Option                                               | Description                                           |\n| ---------------------------------------------------- | ----------------------------------------------------- |\n| -r, --desc                                           | 逆序排列文件                                          |\n| -n, --name                                           | 依名字排序                                            |\n| -t, --time                                           | 依时间排序                                            |\n| -s, --size                                           | 依文件大小排序                                        |\n| -R, --recursive                                      | 递归列出文件                                          |\n| -I, --include TEXT                                   | 筛选包含这个字符串的文件                              |\n| --include-regex, --IR TEXT                           | 筛选包含这个正则表达式的文件                          |\n| -E, --exclude TEXT                                   | 筛选 **不** 包含这个字符串的文件                      |\n| --exclude-regex, --ER TEXT                           | 筛选 **不** 包含这个正则表达式的文件                  |\n| -f, --is-file                                        | 筛选 **非** 目录文件                                  |\n| -d, --is-dir                                         | 筛选目录文件                                          |\n| --no-highlight, --NH                                 | 取消匹配高亮                                          |\n| -S, --show-size                                      | 显示文件大小                                          |\n| -D, --show-date                                      | 显示文件创建时间                                      |\n| -M, --show-md5                                       | 显示文件 md5                                          |\n| -A, --show-absolute-path                             | 显示文件绝对路径                                      |\n| --show-dl-link, --DL                                 | 显示文件下载连接                                      |\n| --show-hash-link, --HL                               | 显示文件秒传连接                                      |\n| --hash-link-protocol, --HLP [cs3l \\| short \\| bdpan] | 显示文件 hash 链接，并指定协议                        |\n| --no-check-md5, --NC                                 | 显示文件 cs3l:// 连接时不检查 md5                     |\n| --csv                                                | 用 csv 格式显示，单行显示，推荐和 --DL 或 --HL 一起用 |\n| --only-dl-link, --ODL                                | 只显示文件下载连接                                    |\n| --only-hash-link, --OHL                              | 只显示文件秒传连接                                    |\n\n## 搜索文件\n\n搜索包含 `keyword` 的文件\n\n```\nBaiduPCS-Py search [OPTIONS] KEYWORD [REMOTEDIR]\n\n# 在当前工作目录中搜索\nBaiduPCS-Py search keyword\n\n# or\nBaiduPCS-Py search keyword /absolute/path\n\n# or\nBaiduPCS-Py search keyword relative/path\n```\n\n### 选项\n\n| Option                     | Description                          |\n| -------------------------- | ------------------------------------ |\n| -R, --recursive            | 递归搜索文件                         |\n| -I, --include TEXT         | 筛选包含这个字符串的文件             |\n| --include-regex, --IR TEXT | 筛选包含这个正则表达式的文件         |\n| -E, --exclude TEXT         | 筛选 **不** 包含这个字符串的文件     |\n| --exclude-regex, --ER TEXT | 筛选 **不** 包含这个正则表达式的文件 |\n| -f, --is-file              | 筛选 **非** 目录文件                 |\n| -d, --is-dir               | 筛选目录文件                         |\n| --no-highlight, --NH       | 取消匹配高亮                         |\n| -S, --show-size            | 显示文件大小                         |\n| -D, --show-date            | 显示文件创建时间                     |\n| -M, --show-md5             | 显示文件 md5                         |\n\n## 显示文件内容\n\n```\nBaiduPCS-Py cat [OPTIONS] REMOTEPATH\n```\n\n### 选项\n\n| Option                        | Description                  |\n| ----------------------------- | ---------------------------- |\n| -e, --encoding TEXT           | 文件编码，默认自动解码       |\n| --no-decrypt, --ND            | 不解密                       |\n| --encrypt-password, --ep TEXT | 加密密码，默认使用用户设置的 |\n\n## 创建目录\n\n```\nBaiduPCS-Py mkdir [OPTIONS] [REMOTEDIRS]...\n```\n\n### 选项\n\n| Option     | Description |\n| ---------- | ----------- |\n| -S, --show | 显示目录    |\n\n## 移动文件\n\n移动一些文件到一个目录中。\n\n```\nBaiduPCS-Py move [OPTIONS] [REMOTEPATHS]... REMOTEDIR\n```\n\n### 选项\n\n| Option     | Description |\n| ---------- | ----------- |\n| -S, --show | 显示结果    |\n\n## 文件重命名\n\n```\nBaiduPCS-Py rename [OPTIONS] SOURCE DEST\n```\n\n### 选项\n\n| Option     | Description |\n| ---------- | ----------- |\n| -S, --show | 显示结果    |\n\n## 拷贝文件\n\n拷贝一些文件到一个目录中。\n\n```\nBaiduPCS-Py move [OPTIONS] [REMOTEPATHS]... REMOTEDIR\n```\n\n### 选项\n\n| Option     | Description |\n| ---------- | ----------- |\n| -S, --show | 显示结果    |\n\n## 删除文件\n\n```\nBaiduPCS-Py remove [OPTIONS] [REMOTEPATHS]...\n```\n\n## 下载文件\n\n```\nBaiduPCS-Py download [OPTIONS] [REMOTEPATHS]...\n```\n\n### 选项\n\n| Option                                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |\n| ------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| -o, --outdir TEXT                                      | 指定下载本地目录，默认为当前目录                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |\n| -R, --recursive                                        | 递归下载                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |\n| -f, --from-index INTEGER                               | 从所有目录中的第几个文件开始下载，默认为 0（第一个）                                                                                                                                                                                                                                                                                                                                                                                                                                                 |\n| -I, --include TEXT                                     | 筛选包含这个字符串的文件                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |\n| --include-regex, --IR TEXT                             | 筛选包含这个正则表达式的文件                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n| -E, --exclude TEXT                                     | 筛选 不 包含这个字符串的文件                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n| --exclude-regex, --ER TEXT                             | 筛选 不 包含这个正则表达式的文件                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |\n| -s, --concurrency INTEGER                              | 下载同步链接数，默认为 5。数子越大下载速度越快，但是容易被百度封锁                                                                                                                                                                                                                                                                                                                                                                                                                                   |\n| -k, --chunk-size TEXT                                  | 同步链接分块大小                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |\n| -q, --quiet                                            | 取消第三方下载应用输出                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |\n| --out-cmd, --OC                                        | 输出第三方下载应用命令                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |\n| -d, --downloader [ me \\| aget_py \\| aget_rs \\| aria2 ] | 指定下载应用<br> <br> 默认为 me (BaiduPCS-Py 自己的下载器，支持断续下载)<br> me 使用多文件并发下载。<br> <br> 除 me 外，其他下载器，不使用多文件并发下载，使用一个文件多链接下载。<br> 如果需要下载多个小文件推荐使用 me，如果需要下载少量大文件推荐使用其他下载器。对于 SVIP 用户，用哪个下载器都很快。<br> <br> aget_py (https://github.com/PeterDing/aget) 默认安装<br> aget_rs (下载 https://github.com/PeterDing/aget-rs/releases)<br> aria2 (下载 https://github.com/aria2/aria2/releases)<br> |\n| --encrypt-password, --ep TEXT                          | 加密密码，默认使用用户设置的                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |\n\n## 播放媒体文件\n\n```\nBaiduPCS-Py play [OPTIONS] [REMOTEPATHS]...\n```\n\n**注意**: 大于 **100MB** 的媒体文件无法直接播放，需要加 `-s` 使用本地服务器播放。\n\n`play` 命令默认播放带有媒体后缀的文件，如 `abc.mp4`, `abc.mp3`。如果需要播放的媒体文件没有用常规的媒体文件后缀，则需要加选项 `--ignore-ext`。\n\n### 选项\n\n| Option                        | Description                                                                   |\n| ----------------------------- | ----------------------------------------------------------------------------- |\n| -R, --recursive               | 递归播放                                                                      |\n| -f, --from-index INTEGER      | 从所有目录中的第几个文件开始播放，默认为 0（第一个）                          |\n| -I, --include TEXT            | 筛选包含这个字符串的文件                                                      |\n| --include-regex, --IR TEXT    | 筛选包含这个正则表达式的文件                                                  |\n| -E, --exclude TEXT            | 筛选 不 包含这个字符串的文件                                                  |\n| --exclude-regex, --ER TEXT    | 筛选 不 包含这个正则表达式的文件                                              |\n| --player-params, --PP TEXT    | 第三方播放器参数                                                              |\n| -m, --m3u8                    | 获取 m3u8 文件并播放                                                          |\n| -q, --quiet                   | 取消第三方播放器输出                                                          |\n| --shuffle, --sf               | 随机播放                                                                      |\n| --ignore-ext, --IE            | 不用文件名后缀名来判断媒体文件                                                |\n| --out-cmd, --OC               | 输出第三方播放器命令                                                          |\n| -p, --player [mpv]            | 指定第三方播放器<br><br>默认为 mpv (https://mpv.io)                           |\n| -s, --use-local-server        | 使用本地服务器播放。大于 100MB 的媒体文件无法直接播放，需要使用本地服务器播放 |\n| --encrypt-password, --ep TEXT | 加密密码，默认使用用户设置的                                                  |\n\n## 上传文件\n\n上传一些本地文件或目录到网盘目录。\n\nBaiduPCS-Py 首先会尝试秒传。如果秒传失败，会使用分片上传上传文件。\n\n上传过程中，按 “p” 可以暂停或继续上传。\n\n```\nBaiduPCS-Py upload [OPTIONS] [LOCALPATHS]... REMOTEDIR\n```\n\n### 选项\n\n| Option                                                     | Description                                                                                |\n| ---------------------------------------------------------- | ------------------------------------------------------------------------------------------ |\n| --encrypt-password, --ep TEXT                              | 加密密码，默认使用用户设置的                                                               |\n| -e, --encrypt-type [No \\| Simple \\| ChaCha20 \\| AES256CBC] | 文件加密方法，默认为 No 不加密                                                             |\n| -w, --max-workers INTEGER                                  | 同时上传文件数                                                                             |\n| --no-ignore-existing, --NI                                 | 上传已经存在的文件                                                                         |\n| --no-show-progress, --NP                                   | 不显示上传进度                                                                             |\n| --check-md5, --CM                                          | 分段上传后检查 md5。注意检查上传后大文件的 md5，可能会花数分中（2G 的文件需要大约 5 分钟） |\n\n## 同步本地目录到远端\n\n同步本地目录到远端。\n\n如果本地文件最后修改时间或大小和远端不同则上传文件。对于本地不存在的文件但远端存在则删除远端文件。\n\n```\nBaiduPCS-Py sync [OPTIONS] LOCALDIR REMOTEDIR\n```\n\n### 选项\n\n| Option                                                     | Description                                                                                |\n| ---------------------------------------------------------- | ------------------------------------------------------------------------------------------ |\n| --encrypt-password, --ep TEXT                              | 加密密码，默认使用用户设置的                                                               |\n| -e, --encrypt-type [No \\| Simple \\| ChaCha20 \\| AES256CBC] | 文件加密方法，默认为 No 不加密                                                             |\n| -w, --max-workers INTEGER                                  | 同时上传文件数                                                                             |\n| --no-show-progress, --NP                                   | 不显示上传进度                                                                             |\n| --check-md5, --CM                                          | 分段上传后检查 md5。注意检查上传后大文件的 md5，可能会花数分中（2G 的文件需要大约 5 分钟） |\n\n## 关于秒传\n\n百度网盘在服务器上对于一份文件只储存一份。如果一份文件已经存在于百度网盘的服务器中，用户无需重新上传源文件，只需要提供文件的特征参数就可完成上传，这种上传文件的方法百度叫做“**秒传**”。\n\n运用“秒传”的功能，我们将一份文件变成一组特征参数。只要获得这组特征参数，我们就可以在百度网盘中“生成”这组特征参数对应的唯一文件。\n\nBaiduPCS-Py 可以获取百度网盘中文件的特征参数，并将其转化为一串连接。使用这个连接，使用者可以在任何帐号中“生成”对应文件，达到文件分享的功能。\n\nBaiduPCS-Py 支持 3 种秒传连接(在 BaiduPCS-Py 叫 Hash Link)协议：\n\n1. `cs3l`\n\n`cs3l` 是 <b>C</b>ontent_md5 + <b>S</b>lice256k_md5 + content_crc<b>3</b>2 + content\\_<b>L</b>ength 的缩写。\n\n格式: `cs3l://<content_md5>#<slice_md5>#<content_crc32>#<content_length>#<filename>`\n\n例如: `cs3l://ced58db7aedce8e1c887754fccccde03#0d02589467f34bdd86d08221e93b2783#2518837112#33251183#test.gz`\n\nBaiduPCS-Py 默认使用 `cs3l` 协议连接。\n\n2. `short`\n\n`short` 是 `cs3l` 格式的缩写版。最早出自于[梦姬度盘标准提取码](https://blog.jixun.moe/du-code-gen)。\n\n格式: `<content_md5>#<slice_md5>#<content_length>#<filename>`\n\n例如: `ced58db7aedce8e1c887754fccccde03#0d02589467f34bdd86d08221e93b2783#33251183#test.gz`\n\n3. `bdpan`\n\n`bdpan` 是 pandownload 使用的协议连接。\n\n格式: `bdpan://{base64(<filename>|<content_length>|<content_md5>|<slice_md5>)}`\n\n例如: `bdpan://Q29udGVudHMtYW1kNjQuZ3p8MzMyNTExODN8Y2VkNThkYjdhZWRjZThlMWM4ODc3NTRmY2NjY2RlMDN8MGQwMjU4OTQ2N2YzNGJkZDg2ZDA4MjIxZTkzYjI3ODM=`\n\nBaiduPCS-Py 会将在命令 `ls`，`upload`，`sync`，`rp` 中遇到的文件特征参数存储于本地 sqlite3 数据库 `~/.baidupcs-py/rapiduploadinfo.sqlite3`。使用 `rplist`，`rpsearch` 命令可以查看这些信息。\n\n## 显示网盘中文件的秒传连接\n\n使用 `ls` 命令显示秒传连接默认会对文件进行秒传检查，已确认服务器是否已经将文件特征记录。\n\n对于才上传的大文件，服务器不会立刻计算完文件的特征参数，这个过程可能持续数天的时间。在此期间秒传无法进行。\n\n如果想略过秒传检查，用户可以用 `--no-check-md5` 选项。但这样生成的秒传连接可能是无效的。\n\n> 注意：显示秒传连接需要请求文件 256KB 的内容。如果用户是非 svip 且请求的文件很多，那么这个过程要花很长时间。BaidPCS-Py 使用 10 个线程来请求，如果是非 svip，每个文件请求可能要花 5 秒。\n\n```\n# 默认显示 cs3l 协议连接\nBaiduPCS-Py ls /path/to/file --show-hash-link\n\n# 或者用 --show-hash-link 缩写 --HL\nBaiduPCS-Py ls /path/to/file --HL\n```\n\n指定特定协议：\n\n```\nBaiduPCS-Py ls /path/to/file --show-hash-link --hash-link-protocol bdpan\n```\n\n如果连接过长，可以加选项 `--csv`，让输出变为 csv 格式。\n\n```\nBaiduPCS-Py ls /path/to/file --show-hash-link --csv\n```\n\n## 列出保存的文件秒传信息\n\n```\nBaiduPCS-Py rplist [OPTIONS] [IDS]...\n```\n\n如果不给出 ids，默认为对所有数据进行操作。\n\n### 选项\n\n| Option                                               | Description               |\n| ---------------------------------------------------- | ------------------------- |\n| -f, --filename                                       | 按文件名排序              |\n| -t, --time                                           | 按时间排序                |\n| -s, --size                                           | 按文件大小排序            |\n| -l, --localpath                                      | 按本地名排序              |\n| -r, --remotepath                                     | 按远端名排序              |\n| -u, --userid                                         | 按用户 id 排序            |\n| -n, --username                                       | 按用户名排序              |\n| -d, --desc                                           | 按逆序排序                |\n| -L, --limit INTEGER                                  | 限制列出文件个数          |\n| -O, --offset INTEGER                                 | 列出偏移位                |\n| --hash-link-protocol, --HLP [cs3l \\| short \\| bdpan] | hash link 协议, 默认 cs3l |\n| --show-all, -A                                       | 显示文件所有信息          |\n| --only-hash-link, --OHL                              | 只显示文件秒传连接        |\n\n## 搜索保存的文件秒传信息\n\n```\nBaiduPCS-Py rpsearch [OPTIONS] KEYWORD\n```\n\n### 选项\n\n| Option                                               | Description                                    |\n| ---------------------------------------------------- | ---------------------------------------------- |\n| --filename, --fn                                     | 在文件名中搜索                                 |\n| --localpath, --lp                                    | 在本地路径中搜索                               |\n| --remotepath, --rp                                   | 在远端路径中搜索                               |\n| --username, --un                                     | 在用户名中搜索                                 |\n| -m, --md5                                            | 在 md5 中搜索。注意保存的文件 md5 都是小写字符 |\n| --hash-link-protocol, --HLP [cs3l \\| short \\| bdpan] | hash link 协议, 默认 cs3l                      |\n| --show-all, -A                                       | 显示文件所有信息                               |\n| --only-hash-link, --OHL                              | 只显示文件秒传连接                             |\n\n## 用秒传连接或参数上传\n\n```\nBaiduPCS-Py rp [OPTIONS] [REMOTEDIR]\n```\n\n使用秒传连接：\n\n```\n# 将秒传连接指向的文件保存到远端路径 /path/to/save\nBaiduPCS-Py rp /path/to/save --link \'cs3l://ced58db7aedce8e1c887754fccccde03#0d02589467f34bdd86d08221e93b2783#2518837112#33251183#test.gz\'\n\nBaiduPCS-Py rp /path/to/save --link \'ced58db7aedce8e1c887754fccccde03#0d02589467f34bdd86d08221e93b2783#33251183#test.gz\'\n\nBaiduPCS-Py rp /path/to/save --link \'bdpan://Q29udGVudHMtYW1kNjQuZ3p8MzMyNTExODN8Y2VkNThkYjdhZWRjZThlMWM4ODc3NTRmY2NjY2RlMDN8MGQwMjU4OTQ2N2YzNGJkZDg2ZDA4MjIxZTkzYjI3ODM=\'\n```\n\n从指定文件获取要使用的秒传连接，文件中一行一个秒传连接。\n\n```\nBaiduPCS-Py rp /path/to/save --input-file links.txt --max-workers 5\n```\n\n使用特征参数：\n\n```\nBaiduPCS-Py rp /path/to/save \\\n    --content-md5 \'ced58db7aedce8e1c887754fccccde03\' \\\n    --slice-md5 \'0d02589467f34bdd86d08221e93b2783\' \\\n    --content-length \'33251183\' \\\n    --filename \'test.gz\'\n```\n\n如果同时有 `--link` 和 `--filename`，那么 `--filename` 值将代替 link 中的文件名。\n\n### 选项\n\n| Option                         | Description                                            |\n| ------------------------------ | ------------------------------------------------------ |\n| -l, --link TEXT                | cs3l:// 协议连接 或 简化连接                           |\n| -i, --input-file TEXT          | 从指定文件获取要使用的秒传连接；只能是一行一个秒传连接 |\n| --slice-md5, --sm TEXT         | 文件前 256KB md5                                       |\n| --content-md5, --cm TEXT       | 文件 md5                                               |\n| --content-crc32, --cc INTEGER  | 文件 crc32, 可以为空                                   |\n| --content-length, --cl INTEGER | 文件长度                                               |\n| --filename, --fn TEXT          | 文件名，如果这里设置了，将会覆盖 link 中的文件名       |\n| --no-ignore-existing, --NI     | 上传且覆盖已经存在的文件                               |\n| -w, --max-workers INTEGER      | 同时上传文件数                                         |\n\n## 分享文件\n\n**注意：使用这个命令需要 cookies 中含有 `STOKEN` 值。**\n\n```\nBaiduPCS-Py share [OPTIONS] [REMOTEPATHS]...\n```\n\n### 选项\n\n| Option              | Description                      |\n| ------------------- | -------------------------------- |\n| -p, --password TEXT | 设置秘密，4 个字符。默认没有秘密 |\n\n## 列出分享链接\n\n```\nBaiduPCS-Py shared\n```\n\n### 选项\n\n| Option         | Description                                  |\n| -------------- | -------------------------------------------- |\n| -A, --show-all | 显示所有分享的链接，默认只显示有效的分享链接 |\n\n## 取消分享链接\n\n```\nBaiduPCS-Py cancelshared [OPTIONS] [SHARE_IDS]...\n```\n\n## 列出其他用户分享链接中的文件\n\n**注意：使用这个命令需要 cookies 中含有 `STOKEN` 值。**\n\n```\nBaiduPCS-Py listsharedpaths [OPTIONS] SHARED_URL\n```\n\n### 选项\n\n| Option                | Description                        |\n| --------------------- | ---------------------------------- |\n| -p, --password TEXT   | 链接密码，如果没有不用设置         |\n| --no-show-vcode, --NV | 不显示验证码，如果需要验证码则报错 |\n\n## 保存其他用户分享的链接\n\n**注意：使用这个命令需要 cookies 中含有 `STOKEN` 值。**\n\n保存其他用户分享的链接到远端目录。\n\n```\nBaiduPCS-Py save [OPTIONS] SHARED_URL REMOTEDIR\n```\n\n### 选项\n\n| Option                | Description                        |\n| --------------------- | ---------------------------------- |\n| -p, --password TEXT   | 链接密码，如果没有不用设置         |\n| --no-show-vcode, --NV | 不显示验证码，如果需要验证码则报错 |\n\n## 添加离线下载任务\n\n```\nBaiduPCS-Py add [TASK_URLS]... REMOTEDIR\n```\n\n## 列出离线下载任务\n\n```\n# 列出所有离线下载任务\nBaiduPCS-Py tasks\n\n# 也可列出给定id的任务。\nBaiduPCS-Py tasks [TASK_IDS]...\n```\n\n## 清除已经下载完和下载失败的任务\n\n```\nBaiduPCS-Py cleartasks\n```\n\n## 取消下载任务\n\n```\nBaiduPCS-Py canceltasks [TASK_IDS]...\n```\n\n## 删除所有离线下载任务\n\n```\nBaiduPCS-Py purgetasks\n```\n\n### 选项\n\n| Option | Description    |\n| ------ | -------------- |\n| --yes  | 确认并直接运行 |\n\n## 开启 HTTP 服务\n\n在远端 `ROOT_DIR` 目录下开启 HTTP 服务。\n\n`ROOT_DIR` 默认为 `/`\n\n```\nBaiduPCS-Py BaiduPCS-Py server [OPTIONS] [ROOT_DIR]\n```\n\n如果需要设置认证，使用下面的选项设置用户名和密钥：\n\n```\nBaiduPCS-Py BaiduPCS-Py server [ROOT_DIR] --username \'foo\' --password \'bar\'\n```\n\n也可以指定服务路径：\n\n```\nBaiduPCS-Py BaiduPCS-Py server [ROOT_DIR] --path \'/my/pan\'\n\n# 访问 http://localhost:8000/my/pan/\n```\n\n### 选项\n\n| Option                        | Description                  |\n| ----------------------------- | ---------------------------- |\n| --path TEXT                   | 服务路径，默认为 “/”         |\n| -h, --host TEXT               | 监听 host                    |\n| -p, --port INTEGER            | 监听 port                    |\n| -w, --workers INTEGER         | 进程数                       |\n| --encrypt-password, --ep TEXT | 加密密码，默认使用用户设置的 |\n| --username TEXT               | HTTP Basic Auth 用户名       |\n| --password TEXT               | HTTP Basic Auth 密钥         |\n',
    'author': 'PeterDing',
    'author_email': 'dfhayst@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/PeterDing/BaiduPCS-Py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
