"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 *
 * @stability stable
 */
class Cache extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`
            .slice(-63)
            .toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = (_b = props.expiration) !== null && _b !== void 0 ? _b : core_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new aws_s3_1.Bucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.KMS_MANAGED,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            autoDeleteObjects: true,
            removalPolicy: core_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.0.132" };
//# sourceMappingURL=data:application/json;base64,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