import * as ec2 from '@aws-cdk/aws-ec2';
import { IResource, RemovalPolicy, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * Interface for a subnet group.
 *
 * @stability stable
 */
export interface ISubnetGroup extends IResource {
    /**
     * The name of the subnet group.
     *
     * @stability stable
     * @attribute true
     */
    readonly subnetGroupName: string;
}
/**
 * Properties for creating a SubnetGroup.
 *
 * @stability stable
 */
export interface SubnetGroupProps {
    /**
     * Description of the subnet group.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The VPC to place the subnet group in.
     *
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * The name of the subnet group.
     *
     * @default - a name is generated
     * @stability stable
     */
    readonly subnetGroupName?: string;
    /**
     * Which subnets within the VPC to associate with this group.
     *
     * @default - private subnets
     * @stability stable
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * The removal policy to apply when the subnet group are removed from the stack or replaced during an update.
     *
     * @default RemovalPolicy.DESTROY
     * @stability stable
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * Class for creating a RDS DB subnet group.
 *
 * @stability stable
 * @resource AWS::RDS::DBSubnetGroup
 */
export declare class SubnetGroup extends Resource implements ISubnetGroup {
    /**
     * Imports an existing subnet group by name.
     *
     * @stability stable
     */
    static fromSubnetGroupName(scope: Construct, id: string, subnetGroupName: string): ISubnetGroup;
    /**
     * The name of the subnet group.
     *
     * @stability stable
     */
    readonly subnetGroupName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SubnetGroupProps);
}
