import * as kms from '@aws-cdk/aws-kms';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import { Construct } from 'constructs';
/**
 * Construction properties for a DatabaseSecret.
 *
 * @stability stable
 */
export interface DatabaseSecretProps {
    /**
     * The username.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * The KMS key to use to encrypt the secret.
     *
     * @default default master key
     * @stability stable
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * The master secret which will be used to rotate this secret.
     *
     * @default - no master secret information will be included
     * @stability stable
     */
    readonly masterSecret?: secretsmanager.ISecret;
    /**
     * Characters to not include in the generated password.
     *
     * @default " %+~`#$&*()|[]{}:;<>?!'/
     * @stability stable
     * @ \"\\"
     */
    readonly excludeCharacters?: string;
    /**
     * Whether to replace this secret when the criteria for the password change.
     *
     * This is achieved by overriding the logical id of the AWS::SecretsManager::Secret
     * with a hash of the options that influence the password generation. This
     * way a new secret will be created when the password is regenerated and the
     * cluster or instance consuming this secret will have its credentials updated.
     *
     * @default false
     * @stability stable
     */
    readonly replaceOnPasswordCriteriaChanges?: boolean;
}
/**
 * A database secret.
 *
 * @stability stable
 * @resource AWS::SecretsManager::Secret
 */
export declare class DatabaseSecret extends secretsmanager.Secret {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: DatabaseSecretProps);
}
