"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Network = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
/**
 * Network settings for the manager and runners
 *
 *  All EC2 instances should belong to the same subnet, availability zone and vpc.
 */
class Network extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vpc =
            props?.vpc ??
                new aws_ec2_1.Vpc(scope, `Vpc`, {
                    maxAzs: 1,
                });
        this.subnet = this.findSubnet(this.vpc, props?.subnetSelection);
        this.availabilityZone = this.subnet.availabilityZone;
        if (!this.hasPrivateSubnets()) {
            aws_cdk_lib_1.Annotations.of(this).addWarning(`No private network found in ${this.vpc.vpcId}, using public addresses.`);
        }
    }
    hasPrivateSubnets() {
        return !!this.vpc.privateSubnets.length;
    }
    /**
     * Returns the first private or public subnet. Optionally filters by AZ.
     *
     * @exception Throws an error if no private or public is found.
     */
    findSubnet(vpc, subnetSelection) {
        const selectedSubnets = vpc.selectSubnets(subnetSelection || {
            subnetType: this.hasPrivateSubnets() ? aws_ec2_1.SubnetType.PRIVATE_WITH_NAT : aws_ec2_1.SubnetType.PUBLIC,
            availabilityZones: vpc.availabilityZones,
        });
        const subnet = selectedSubnets.subnets.find(() => true);
        if (!subnet) {
            throw new Error(`Neither a private nor a public subnet is found in ${vpc.vpcId}`);
        }
        return subnet;
    }
}
exports.Network = Network;
_a = JSII_RTTI_SYMBOL_1;
Network[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Network", version: "0.2.98" };
//# sourceMappingURL=data:application/json;base64,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