# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/trinoConnection.json
#   timestamp: 2022-05-04T16:14:16+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class TrinoType(Enum):
    Trino = 'Trino'


class TrinoScheme(Enum):
    trino = 'trino'


class TrinoConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TrinoType] = Field(
        TrinoType.Trino, description='Service Type', title='Service Type'
    )
    scheme: Optional[TrinoScheme] = Field(
        TrinoScheme.trino,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='username to connect to Trino. This user should have privileges to read all the metadata in Trino.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='password to connect to the Trino.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the data source.', title='Host and Port'
    )
    catalog: Optional[str] = Field(
        None, description='Catalog of the data source.', title='Catalog'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases in the selected catalog.',
        title='Database',
    )
    proxies: Optional[Dict[str, str]] = Field(
        None,
        description='Proxies for the connection to Trino data source',
        title='Proxies',
    )
    params: Optional[Dict[str, str]] = Field(
        None,
        description='URL parameters for connection to the Trino data source',
        title='URL Parameters',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
