# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2022-05-04T16:14:16+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TableauType] = Field(
        TableauType.Tableau, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(..., description='Tableau Server', title='Host and Port')
    username: Optional[str] = Field(
        None, description='username for the Tableau', title='Username'
    )
    password: Optional[SecretStr] = Field(
        None, description='password for the Tableau', title='Password'
    )
    apiVersion: str = Field(..., description='Tableau API version', title='API Version')
    siteName: str = Field(..., description='Tableau Site Name', title='Site Name')
    personalAccessTokenName: Optional[str] = Field(
        None, description='Personal Access Token Name', title='Personal Access Token'
    )
    personalAccessTokenSecret: Optional[str] = Field(
        None,
        description='Personal Access Token Secret',
        title='Personal Access Token Secret',
    )
    env: str = Field(
        ..., description='Tableau Environment Name', title='Tableau Environment'
    )
    dbServiceName: Optional[str] = Field(
        None, description='Database Service Name in order to create a lineage'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
