# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# Pip
from PIL import Image

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------- class: PositionedImage --------------------------------------------------------- #

class PositionedImage:

    # ------------------------------------------------------------- Init ------------------------------------------------------------- #

    def __init__(
        self,
        image: Image,
        x: int,
        y: int
    ):
        self.image = image
        self.x = x
        self.y = y

    # ------------------------------------------------------ Public properties ------------------------------------------------------- #

    @property
    def w(self) -> int:
        return self.image.size[0]

    # Alias
    width = w

    @property
    def h(self) -> int:
        return self.image.size[1]

    # Alias
    height = h

    @property
    def max_x(self) -> int:
        return self.x + self.w

    @property
    def max_y(self) -> int:
        return self.y + self.h

    @property
    def id(self) -> int:
        return str()

# ---------------------------------------------------------------------------------------------------------------------------------------- #