# flake8: noqa: W291
# pylint: disable=too-many-lines,trailing-whitespace

"""
AbstractAnnofabApiのヘッダ部分

Note:
    このファイルはopenapi-generatorで自動生成される。詳細は generate/README.mdを参照
"""

import abc
import warnings  # pylint: disable=unused-import
from typing import Any, Dict, List, Optional, Tuple, Union  # pylint: disable=unused-import

import requests

import annofabapi  # pylint: disable=unused-import


class AbstractAnnofabApi(abc.ABC):
    """
    AnnofabApiクラスの抽象クラス
    """

    @abc.abstractmethod
    def _request_wrapper(
        self,
        http_method: str,
        url_path: str,
        query_params: Optional[Dict[str, Any]] = None,
        header_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
    ) -> Tuple[Any, requests.Response]:
        pass

    #########################################
    # Public Method : AfAnnotationApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_annotations(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション一括更新
        https://annofab.com/docs/api/#operation/batchUpdateAnnotations


        authorizations: ProjectAccepter


        複数のアノテーションを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1つのリクエストで複数の更新や削除ができます。  APIの制約は以下の通りです。 * アノテーションラベルの以下の変更はできない   * 異なるアノテーションの種類のラベルへの変更   * 「全体」アノテーションラベルの変更   * 「塗りつぶしv2」アノテーションラベルの変更 * 受入完了タスクのアノテーションは、プロジェクトオーナーロールを持つユーザーのみ更新/削除できる。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_annotation_request_item (List[BatchAnnotationRequestItem]):  (required)

        Returns:
            Tuple[List[SingleAnnotation], requests.Response]


        """
        url_path = f"/projects/{project_id}/annotations"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation(
        self, project_id: str, task_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """Simpleアノテーションの取得
        https://annofab.com/docs/api/#operation/getAnnotation


        authorizations: AllProjectMember


        Simpleアノテーションを取得します。  [getAnnotationArchive](#operation/getAnnotationArchive) APIでダウンロードできるSimpleアノテーションZIPの一部を、取得することができます。  **注意:** このAPIでは、塗りつぶし画像をダウンロードするためのURLを取得できません。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[SimpleAnnotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation/simple"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_archive(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """SimpleアノテーションZIP取得
        https://annofab.com/docs/api/#operation/getAnnotationArchive


        authorizations: ProjectDataUser


        SimpleアノテーションZIPをダウンロードするための、認証済み一時URLを取得します。 取得したURLは1時間で失効します。  アノテーションZIPの更新中に、このAPIを実行すると409エラーが発生します。  SimpleアノテーションZIPのデータ構造については、[Simple Annotation ZIP](#section/Simple-Annotation-ZIP)を参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/archive/simple"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_list(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション一括取得
        https://annofab.com/docs/api/#operation/getAnnotationList


        authorizations: AllProjectMember


        アノテーションを一括で取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数
                aggregate_by_task_and_input (bool):  `true`を指定すると、「タスクIDと入力データIDの組」ごとに検索結果を集計します。
                no_aggregate_label_and_input (bool):  `true`を指定すると、ラベルIDによるアノテーション検索数の集約結果、および属性IDによるアノテーション検索数の集約結果を取得しません。  このパラメーターを`true`に指定することで集約計算は行われなくなるので、アノテーションの検索が速くなる可能性があります。
                query (str):  絞り込み条件([AnnotationQuery](#section/AnnotationQuery))をJSON形式で表した文字列。
                sort (str):  ソート順の指定。 以下のキーを使用できます。 * `task_id` * `input_data_id` * `detail.annotation_id` * `detail.account_id` * `detail.label_id` * `detail.data_holding_type` * `detail.created_datetime` * `detail.updated_datetime`   キーの先頭に`-`を付けると、降順でソートされます。  `,`でキーを区切ると、複数のキーでソートされます。先頭のキーから順に優先順位が割り振られます。

        Returns:
            Tuple[AnnotationList, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotations"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_archive_full_with_pro_id(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """FullアノテーションZIP取得
        https://annofab.com/docs/api/#operation/getArchiveFullWithProId

        .. deprecated:: X

        authorizations: ProjectDataUser


        FullアノテーションZIPをダウンロードするための、認証済み一時URLを取得します。 取得したURLは1時間で失効します。  アノテーションZIPの更新中に、このAPIを実行すると409エラーが発生します。  FullアノテーションZIPのデータ構造については、[Full Annotation ZIP](#section/Full-Annotation-ZIP)を参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_archive_full_with_pro_id() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/archive/full"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_editor_annotation(
        self, project_id: str, task_id: str, input_data_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーションの取得
        https://annofab.com/docs/api/#operation/getEditorAnnotation


        authorizations: AllProjectMember


        アノテーションを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            query_params (Dict[str, Any]): Query Parameters
                task_history_id (str):  過去のフェーズのアノテーションを取得する場合、タスク履歴IDを指定します。未指定時は最新のアノテーションを取得します。  過去のアノテーションデータは最後に保存してから30日前のデータまで取得できます。 30日より前のデータを取得しようとした場合はアノテーションデータは空リストとなります。

        Returns:
            Tuple[Annotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_annotation_archive_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """アノテーションZIP更新開始
        https://annofab.com/docs/api/#operation/postAnnotationArchiveUpdate


        authorizations: ProjectDataUser


        アノテーションZIPの更新を開始します。 アノテーションZIPの更新は、データ量によっては数十分以上かかる場合もあります。  アノテーションZIPは毎日AM03:00(JST)頃に自動更新されますが、本APIを用いると、自動更新を待たずにアノテーションZIPの更新を要求できます。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-annotation`）。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[PostAnnotationArchiveUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/archive/update"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_annotation(
        self, project_id: str, task_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション更新
        https://annofab.com/docs/api/#operation/putAnnotation


        authorizations: AllProjectMember


        アノテーションを更新します。  APIを実行できるユーザーは、以下の通りです。 * 過去に誰にも割り当てられていないタスク：プロジェクトオーナーロールを持つユーザー * 過去に誰かに割り当てられたことがあるタスク：タスクの現在の担当者  ただし、`is_protected`は、プロジェクトオーナーロールを持つユーザーのみ変更可能です。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            request_body (Any): Request Body
                put_annotation_request (PutAnnotationRequest):  (required)

        Returns:
            Tuple[Annotation, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/annotation"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfAnnotationSpecsApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_annotation_specs(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション仕様取得
        https://annofab.com/docs/api/#operation/getAnnotationSpecs


        authorizations: AllProjectMember


        アノテーション仕様を取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                history_id (str):  アノテーション仕様の履歴ID。過去のアノテーション仕様を取得する場合は、[getAnnotationSpecsHistories](#operation/getAnnotationSpecsHistories) APIで取得した `history_id` の値を指定してください。 未指定時は最新のアノテーション仕様を取得します。
                v (str):  取得するアノテーション仕様のフォーマットバージョンを指定します。`v=1`は将来廃止する予定なので、非推奨です。

        Returns:
            Tuple[AnnotationSpecs, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_annotation_specs_histories(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """アノテーション仕様履歴一括取得
        https://annofab.com/docs/api/#operation/getAnnotationSpecsHistories


        authorizations: AllProjectMember


        アノテーション仕様のすべての更新履歴を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[AnnotationSpecsHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs-histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_annotation_specs(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """アノテーション仕様更新
        https://annofab.com/docs/api/#operation/putAnnotationSpecs


        authorizations: ProjectOwner


        アノテーション仕様を更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                annotation_specs_request (AnnotationSpecsRequest):  (required)

        Returns:
            Tuple[AnnotationSpecsV2, requests.Response]


        """
        url_path = f"/projects/{project_id}/annotation-specs"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfCommentApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_comments(
        self,
        project_id: str,
        task_id: str,
        input_data_id: str,
        query_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
        **kwargs,
    ) -> Tuple[Any, requests.Response]:
        """コメント一括更新
        https://annofab.com/docs/api/#operation/batchUpdateComments


        authorizations: AllProjectMember


        コメントを一括更新します。 タスクの現在の担当者でない場合、またはタスクの状態が「作業中」でない場合は409エラーになります。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新（作成含む）」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の更新や削除ができます。  既に作成済みのコメントのうち、リクエストボディの配列に含まれないものは更新されません。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            query_params (Dict[str, Any]): Query Parameters
                v (str):  2 を指定した場合、検査コメントのデータも含めたコメントデータを返します。  パラメーターの指定がない、あるいは値が 2 以外の場合は検査コメントを除いたコメントデータを返します。
            request_body (Any): Request Body
                batch_comment_request_item (List[BatchCommentRequestItem]):  (required)

        Returns:
            Tuple[List[Comment], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/comments"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_comments(
        self, project_id: str, task_id: str, input_data_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """コメント一括取得
        https://annofab.com/docs/api/#operation/getComments


        authorizations: AllProjectMember


        指定されたタスクで、指定された入力データにつけられたコメントをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            query_params (Dict[str, Any]): Query Parameters
                v (str):  2 を指定した場合、検査コメントのデータも含めたコメントデータを返します。  パラメーターの指定がない、あるいは値が 2 以外の場合は検査コメントを除いたコメントデータを返します。

        Returns:
            Tuple[List[Comment], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/comments"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInputApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_inputs(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データの一括更新
        https://annofab.com/docs/api/#operation/batchUpdateInputs


        authorizations: ProjectOwner


        入力データを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、現在「削除」しかありません。 これら操作オブジェクトを複数含めることで、1個のリクエストで複数の削除ができます。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_input_data_request_item (List[BatchInputDataRequestItem]):  (required)

        Returns:
            Tuple[List[InputData], requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def create_temp_path(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """アップロード先URLの取得
        https://annofab.com/docs/api/#operation/createTempPath


        authorizations: AllProjectMember


        Annofabにファイルをアップロードするのに必要な情報を取得します。  このAPIは、Annofabにファイルをアップロードして、入力データや補助情報を作成する際に使用します。  Annofabにファイルをアップロードして入力データを作成する手順は、以下の通りです。  1. APIを実行して、ファイルのアップロードに必要な情報を取得する。  ``` $ curl --request POST 'https://annofab.com/api/v1/projects/{project_id}/create-temp-path' {   \"url\": \"https://s3.<REGION>.amazonaws.com/<ANNOFAB-TEMP-BUCKET>/<UUID>/<UUID>?param1=...&param2=...\",    \"path\": \"s3://<ANNOFAB-TEMPORARY-BUCKET-NAME>/<UUID>/<UUID>\" } ```  2. 手順1で取得した`url`に対して、HTTP PUTメソッドで、ファイルをアップロードする。  ``` $ curl --request PUT --header 'Content-Type: {CONTENT_TYPE_HERE}' --data-binary @/hoge.zip 'https://{手順1で取得したurl}' ```  3. 手順1で取得した`path`を、[putInputData](#operation/putInputData) APIのリクエストボディ`input_data_path`に指定して、putInputData APIを実行する。  ``` $ curl --request PUT --header 'Content-Type: text/json' \\  --data '{\"input_data_name\":\"{input_data_name}\", \"input_data_path\":\"{手順1で取得したpath}\" }' \\  'https://annofab.com/api/v1/projects/{project_id}/inputs/{input_data_id}' ```  #### 注意事項 * 手順2を実行してから24時間以内に、手順3の操作を完了させてください。手順2でアップロードしたファイルは、24時間経過すると削除されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[DataPath, requests.Response]


        """
        url_path = f"/projects/{project_id}/create-temp-path"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_input_data(self, project_id: str, input_data_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データの削除
        https://annofab.com/docs/api/#operation/deleteInputData


        authorizations: ProjectOwner


        入力データを削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data(self, project_id: str, input_data_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データの取得
        https://annofab.com/docs/api/#operation/getInputData


        authorizations: AllProjectMember


        入力データを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_list(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データの一括取得
        https://annofab.com/docs/api/#operation/getInputDataList


        authorizations: AllProjectMember


        入力データを一括で取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                input_data_id (str):  入力データIDでの部分一致検索で使用。大文字小文字は区別しません。
                input_data_name (str):  入力データ名での部分一致検索で使用。大文字小文字は区別しません。
                input_data_path (str):  入力データパスでの部分一致検索で使用。
                task_id (str):  入力データが紐づくタスクIDの部分一致検索で使用。大文字小文字は区別しません。条件に合致した先頭100件のタスクに使われている入力データを検索します。
                from (str):  指定した日時以降に更新された入力データを取得します。日時のフォーマットはISO 8601 拡張形式です。
                to (str):  指定した日時以前に更新された入力データを取得します。日時のフォーマットはISO 8601 拡張形式です。
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数

        Returns:
            Tuple[InputDataList, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_input_data(
        self, project_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データの作成/更新
        https://annofab.com/docs/api/#operation/putInputData


        authorizations: ProjectOwner


        入力データを作成または更新します。  Annofabにファイルをアップロードして入力データを作成する場合は、事前に[createTempPath](#operation/createTempPath) APIを実行してください。  ### 画像のリサイズ Annofabにアップロードした画像は、自動的に「長辺4096px以内」になるよう縮小されます。 アノテーションの座標値は、縮小前の画像サイズに対応する値に復元されます。  ### ZIPファイルで入力データをまとめて作成する 複数のファイルをZIPで圧縮してAnnofabにアップロードすると、入力データをまとめて作成できます。  パスパラメータの`input_data_id`、リクエストボディの`input_data_name`には、適当な値を指定してください。  ZIPファイルを入力データとして登録すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-inputs`）。  ZIPファイルの制限事項は、以下の通りです。 * アップロードできるZIPファイルのサイズは、最大5GBです。 * UTF-8エンコーディングのみ対応しています。 * ZIPファイル内の次の名前のファイルは、入力データとして登録されません。     * `Thumbs.db`     * `__MACOSX`     * `.DS_Store`     * `desktop.ini`     * 上記以外の、ファイル名先頭が `.`（ドット）で始まるファイル * ZIPファイル内の `.`（ドット）から始まるフォルダ以下のファイルは、入力データとして登録されません。  ### ストリーミング形式の動画を入力データとして登録する ストリーミング形式の動画をAnnofabにアップロードして、入力データとして登録できます。  ただし、ZIPで圧縮する必要があります。ZIPファイルには、m3u8ファイルとtsファイルの両方を含めてください。 m3u8ファイルに記述された相対パスでtsファイルは、参照可能である必要があります。  以下に、フォルダ構成のサンプルを記載します。  ```   hoge.zip/   ├── hoge.ts   ├── fuga/   │   ├── foo.m3u8    (hoge.ts, fuga/foo1.ts, fuga/foo2.tsを参照)   │   ├── foo1.ts   │   ├── foo2.ts   │   └── lib   ├── piyo1/   │   ├── piyo2   │   │   ├── bar.ts   │   ├── bar.m3u8    (hoge.ts, piyo1/piyo2/bar.tsを参照) ```  ### 注意事項 * `input_data_path`のスキーマが`https`の場合、`input_data_name`もしくは`input_data_path`の末尾にファイルの拡張子を含むようにしてください。 Annofabは拡張子からファイル形式を識別します。`input_data_name`と`input_data_path`の両方に拡張子が含まれている場合は、`input_data_name`の拡張子がファイル形式の識別に使われます。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                input_data_request (InputDataRequest):  (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInspectionApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def batch_update_inspections(
        self, project_id: str, task_id: str, input_data_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント一括更新
        https://annofab.com/docs/api/#operation/batchUpdateInspections

        .. deprecated:: X

        authorizations: AllProjectMember


        検査コメントを一括更新します。 タスクの現在の担当者でない場合、またはタスクの状態が「作業中」でない場合は409エラーになります。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、「更新（作成含む）」と「削除」の2通りがあり、それぞれJSONオブジェクト構造が異なります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の更新や削除ができます。  既に作成済みの検査コメントのうち、リクエストボディの配列に含まれないものは更新されません。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)
            request_body (Any): Request Body
                batch_inspection_request_item (List[BatchInspectionRequestItem]):  (required)

        Returns:
            Tuple[List[Inspection], requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.batch_update_inspections() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/inspections"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspections(
        self, project_id: str, task_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """検査コメント一括取得
        https://annofab.com/docs/api/#operation/getInspections

        .. deprecated:: X

        authorizations: AllProjectMember


        指定されたタスクで、指定された入力データにつけられた検査コメントをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[List[Inspection], requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_inspections() is deprecated and will be removed.", FutureWarning, stacklevel=2
        )
        url_path = f"/projects/{project_id}/tasks/{task_id}/inputs/{input_data_id}/inspections"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfInstructionApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_instruction_image(self, project_id: str, image_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像削除
        https://annofab.com/docs/api/#operation/deleteInstructionImage


        authorizations: ProjectAccepter, ProjectOwner


        作業ガイドの画像を削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            image_id (str):  作業ガイド画像ID (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images/{image_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの取得
        https://annofab.com/docs/api/#operation/getInstruction


        authorizations: AllProjectMember


        作業ガイドのHTMLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                history_id (str):  [getInstructionHistory](#operation/getInstructionHistory) APIで取得した、作業ガイドの履歴ID  (required)

        Returns:
            Tuple[Instruction, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_history(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの編集履歴の取得
        https://annofab.com/docs/api/#operation/getInstructionHistory


        authorizations: AllProjectMember


        作業ガイドの編集履歴を取得します。 取得される編集履歴は日付の新しい順にソートされます。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                limit (int):  取得する編集履歴の件数

        Returns:
            Tuple[List[InstructionHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-history"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_image_url_for_put(
        self, project_id: str, image_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像登録・更新用URL取得
        https://annofab.com/docs/api/#operation/getInstructionImageUrlForPut


        authorizations: ProjectAccepter, ProjectOwner


        プロジェクトの作業ガイドの画像を登録するためのput先URLを取得します。  作業ガイド画像の登録/更新方法は以下の通りです。 1. APIを実行して、ファイルアップロード用のURLを取得する。  ``` $ curl -X GET -H 'Content-Type: {CONTENT_TYPE_HERE}' 'https://annofab.com/api/v1/projects/{project_id}/instruction-images/{image_id}/put-url' ```  2. 手順1で取得したファイルアップロード用のURLに対して、登録/更新する作業ガイド画像ファイル(`hoge.jpg`)をPUTする。  ``` $ curl -X PUT -H 'Content-Type: {CONTENT_TYPE_HERE}' --data-binary @/hoge.jpg '{ファイルアップロード用のURL}' ```

        Args:
            project_id (str):  プロジェクトID (required)
            image_id (str):  作業ガイド画像ID (required)

        Returns:
            Tuple[InstructionImagePath, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images/{image_id}/put-url"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_instruction_images(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """作業ガイドの画像一覧の取得
        https://annofab.com/docs/api/#operation/getInstructionImages


        authorizations: AllProjectMember


        作業ガイドの画像一覧を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[InstructionImage], requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction-images"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_instruction(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """作業ガイドの更新
        https://annofab.com/docs/api/#operation/putInstruction


        authorizations: ProjectAccepter, ProjectOwner


        作業ガイドのHTMLを更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                put_instruction_request (PutInstructionRequest):  (required)

        Returns:
            Tuple[InstructionHistory, requests.Response]


        """
        url_path = f"/projects/{project_id}/instruction"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfJobApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_project_job(
        self, project_id: str, job_type: str, job_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトのバックグラウンドジョブ情報削除
        https://annofab.com/docs/api/#operation/deleteProjectJob


        authorizations: ProjectOwner


        プロジェクトのバックグラウンドジョブ情報を削除します。  なお、バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            project_id (str):  プロジェクトID (required)
            job_type (ProjectJobType):  ジョブの種別。[詳細はこちら](#section/ProjectJobType)。 (required)
            job_id (str):  ジョブID (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/jobs/{job_type}/{job_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_job(
        self, organization_name: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織のバックグラウンドジョブ情報取得
        https://annofab.com/docs/api/#operation/getOrganizationJob


        authorizations: AllOrganizationMember


        組織のバックグラウンドジョブの情報を取得します。  バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            organization_name (str):  組織名 (required)
            query_params (Dict[str, Any]): Query Parameters
                type (str):  取得するジョブの種別。[詳細はこちら](#section/OrganizationJobType)。
                limit (int):  1ページあたりの取得するデータ件数。 未指定時は1件のみ取得。
                exclusive_start_created_datetime (str):  作成日時が、指定した日付より古いジョブを取得します。

        Returns:
            Tuple[OrganizationJobInfoContainer, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/jobs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_job(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトのバックグラウンドジョブ情報取得
        https://annofab.com/docs/api/#operation/getProjectJob


        authorizations: AllProjectMember


        プロジェクトのバックグラウンドジョブの情報を取得します。  バックグラウンドジョブ情報は、完了(失敗含む)から14日経過後に自動で削除されます。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                type (ProjectJobType):  取得するジョブの種別。[詳細はこちら](#section/ProjectJobType)。
                limit (int):  1ページあたりの取得するデータ件数。 未指定時は1件のみ取得。
                exclusive_start_created_datetime (str):  作成日時が、指定した日付より古いジョブを取得します。

        Returns:
            Tuple[ProjectJobInfoContainer, requests.Response]


        """
        url_path = f"/projects/{project_id}/jobs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfMyApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def confirm_my_account_delete(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """アカウント削除step2（確定）
        https://annofab.com/docs/api/#operation/confirmMyAccountDelete


        authorizations: EveryoneRequestBody


        [受け取った確認コード](#operation/initiateMyAccountDelete)を使い、アカウントを削除します。

        Args:
            request_body (Any): Request Body
                confirm_account_delete_request (ConfirmAccountDeleteRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/my/account/delete-request/confirm"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_account(self, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のアカウント取得
        https://annofab.com/docs/api/#operation/getMyAccount


        authorizations: Everyone


        自分のアカウント情報を取得します。

        Args:

        Returns:
            Tuple[MyAccount, requests.Response]


        """
        url_path = f"/my/account"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_member_in_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のプロジェクトメンバー取得
        https://annofab.com/docs/api/#operation/getMyMemberInProject


        authorizations: AllProjectMember


        自分のプロジェクトメンバー情報を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/my/projects/{project_id}/member"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_organizations(self, **kwargs) -> Tuple[Any, requests.Response]:
        """所属組織の一括取得
        https://annofab.com/docs/api/#operation/getMyOrganizations


        authorizations: AllOrganizationMember


        自分が所属している組織を一括で取得します。

        Args:

        Returns:
            Tuple[MyOrganizationList, requests.Response]


        """
        url_path = f"/my/organizations"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_project_members(self, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のプロジェクトメンバー情報一括取得
        https://annofab.com/docs/api/#operation/getMyProjectMembers


        authorizations: Everyone


        自分が所属するプロジェクトのメンバー情報を一括で取得します。

        Args:

        Returns:
            Tuple[List[ProjectMember], requests.Response]


        """
        url_path = f"/my/project-members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_my_projects(self, query_params: Optional[Dict[str, Any]] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """所属プロジェクトの一括取得
        https://annofab.com/docs/api/#operation/getMyProjects


        authorizations: Everyone


        自分が所属しているプロジェクトを一括で取得します。

        Args:
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号
                limit (int):  1ページあたりの取得するデータ件数
                organization_id (str):  指定した組織に属するプロジェクトに絞り込む。
                title (str):  プロジェクトタイトルでの部分一致検索。大文字小文字は区別しません。
                status (ProjectStatus):  指定した状態のプロジェクトで絞り込む。
                input_data_type (InputDataType):  入力データの種類でプロジェクトを絞り込みます。[詳細はこちら](#section/InputDataType)を参照してください。
                sort_by (str):  `date` を指定することでプロジェクトの最新のタスク更新時間の順にソートして出力する。 未指定時はプロジェクト名でソートする。

        Returns:
            Tuple[ProjectContainer, requests.Response]


        """
        url_path = f"/my/projects"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_my_account_delete(self, **kwargs) -> Tuple[Any, requests.Response]:
        """アカウント削除step1（確認）
        https://annofab.com/docs/api/#operation/initiateMyAccountDelete


        authorizations: Everyone


        アカウント削除プロセスを開始します。  本人からの要求かどうかを検証するための確認コードがメールで送付されます。

        Args:

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/my/account/delete-request"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_my_account(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """自分のアカウント情報更新
        https://annofab.com/docs/api/#operation/putMyAccount


        authorizations: Everyone


        自分のアカウント情報を更新します。

        Args:
            request_body (Any): Request Body
                put_my_account_request (PutMyAccountRequest):  (required)

        Returns:
            Tuple[MyAccount, requests.Response]


        """
        url_path = f"/my/account"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def update_organization(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """組織名の変更
        https://annofab.com/docs/api/#operation/updateOrganization

        .. deprecated:: X

        authorizations: OrganizationOwner


        組織名を変更します。  2022/04/19以降に廃止する予定です。

        Args:
            request_body (Any): Request Body
                update_organization_name_request (UpdateOrganizationNameRequest):  (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.update_organization() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/my/organizations"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def create_new_organization(self, request_body: Optional[Any] = None, **kwargs) -> Tuple[Any, requests.Response]:
        """組織の作成
        https://annofab.com/docs/api/#operation/createNewOrganization


        authorizations: Everyone


        組織を作成します。  リクエストボディの`price_plan`には、`free`のみ指定できます。 ビジネスプランの組織を作成する場合は、[セールスチーム](https://annofab.com/docs/forms/contact-sales.html)までお問い合わせください。  既に存在する組織名をリクエストボディに指定すると、400エラーが発生します。

        Args:
            request_body (Any): Request Body
                organization_registration_request (OrganizationRegistrationRequest):  (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_organization(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織の削除
        https://annofab.com/docs/api/#operation/deleteOrganization


        authorizations: OrganizationOwner


        組織を完全に削除します。  組織内のプロジェクトが1件も存在しない場合のみ削除できます。 組織を削除したい場合は全てのプロジェクトを削除してください。   **削除された組織は元に戻せません。ご注意ください。**

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_name}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織の取得
        https://annofab.com/docs/api/#operation/getOrganization


        authorizations: AllOrganizationMember


        組織を取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_name}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_activity(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織の活動状況の取得
        https://annofab.com/docs/api/#operation/getOrganizationActivity


        authorizations: AllOrganizationMember


        Annofabストレージの使用量など、組織の活動状況を取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationActivity, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/activity"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_projects_of_organization(
        self, organization_name: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織配下プロジェクトの一括取得
        https://annofab.com/docs/api/#operation/getProjectsOfOrganization


        authorizations: AllOrganizationMember


        指定した組織のプロジェクトを一括で取得します。

        Args:
            organization_name (str):  組織名 (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  表示するページ番号
                limit (int):  1ページあたりの取得するデータ件数
                account_id (str):  指定したアカウントIDをメンバーに持つプロジェクトで絞り込む。
                except_account_id (str):  指定したアカウントIDをメンバーに持たないプロジェクトで絞り込む。
                title (str):  プロジェクトタイトルでの部分一致検索。大文字小文字は区別しません。
                status (ProjectStatus):  指定した状態のプロジェクトで絞り込む。
                plugin_id (str):  指定したプラグインIDを使用しているプロジェクトで絞り込む。
                input_data_type (InputDataType):  入力データの種類でプロジェクトを絞り込みます。[詳細はこちら](#section/InputDataType)を参照してください。
                sort_by (str):  `date` を指定することでプロジェクトの最新のタスク更新時間の順にソートして出力する。 未指定時はプロジェクト名でソートする。

        Returns:
            Tuple[ProjectList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/projects"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_organization(
        self, organization_name: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織の更新
        https://annofab.com/docs/api/#operation/putOrganization


        authorizations: OrganizationOwner


        組織を更新します。

        Args:
            organization_name (str):  組織名 (required)
            request_body (Any): Request Body
                put_organization_request (PutOrganizationRequest):  (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/organizations/{organization_name}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationInputApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_organization_input_data(
        self, organization_name: str, input_data_set_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット内の入力データの削除
        https://annofab.com/docs/api/#operation/deleteOrganizationInputData


        authorizations: OrganizationAdministrator, ProjectOwner


        入力データセットに含まれる入力データ情報を削除します。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs/{input_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_set(
        self, organization_name: str, input_data_set_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット情報取得
        https://annofab.com/docs/api/#operation/getInputDataSet


        authorizations: AllOrganizationMember


        入力データセットを取得します。  組織オーナーまたは組織管理者でない場合は、自身が所属するプロジェクトの入力データセットのみが取得できます。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)

        Returns:
            Tuple[InputDataSet, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_input_data_set_list(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データセットの一括取得
        https://annofab.com/docs/api/#operation/getInputDataSetList


        authorizations: OrganizationAdministrator, OrganizationOwner


        入力データセットを一括で取得します。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[List[InputDataSet], requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_input_data(
        self, organization_name: str, input_data_set_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット内の入力データの取得
        https://annofab.com/docs/api/#operation/getOrganizationInputData


        authorizations: AllOrganizationMember


        入力データセットに含まれる入力データを取得します。  組織オーナーまたは組織管理者でない場合は自身が所属するプロジェクトの入力データセット内の入力データのみが取得できます。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[InputData, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs/{input_data_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_input_data_list(
        self, organization_name: str, input_data_set_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセット内の入力データの一括取得
        https://annofab.com/docs/api/#operation/getOrganizationInputDataList


        authorizations: AllOrganizationMember


        入力データセットに含まれる入力データを一括で取得します。  組織オーナーまたは組織管理者でない場合は自身が所属するプロジェクトの入力データセット内の入力データのみが取得できます。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            query_params (Dict[str, Any]): Query Parameters
                input_data_id (str):  入力データIDでの部分一致検索で使用。
                input_data_name (str):  入力データ名での部分一致検索で使用。
                input_data_path (str):  入力データパスでの部分一致検索で使用。
                task_id (str):  入力データが紐づくタスクIDの部分一致検索で使用。条件に合致した先頭100件のタスクに使われている入力データを検索します。
                from (str):  指定した日時以降に更新された入力データを取得します。日時のフォーマットはISO 8601 拡張形式です。
                to (str):  指定した日時以前に更新された入力データを取得します。日時のフォーマットはISO 8601 拡張形式です。
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数

        Returns:
            Tuple[InputDataList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_input_data_set(
        self, organization_name: str, input_data_set_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """入力データセットの作成/更新
        https://annofab.com/docs/api/#operation/putInputDataSet


        authorizations: OrganizationAdministrator, OrganizationOwner


        入力データセットを作成または更新します。

        Args:
            organization_name (str):  組織名 (required)
            input_data_set_id (str):  入力データセットID (required)
            request_body (Any): Request Body
                put_input_data_set_request (PutInputDataSetRequest):

        Returns:
            Tuple[InputDataSet, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/input_data_set/{input_data_set_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationMemberApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def accept_organization_invitation(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織への招待の受諾
        https://annofab.com/docs/api/#operation/acceptOrganizationInvitation


        authorizations: EveryoneRequestBody


        組織への招待を受諾し、組織へのメンバー登録を完了します。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザーID (required)
            request_body (Any): Request Body
                accept_organization_invitation_request (AcceptOrganizationInvitationRequest):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/invitation/accept"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_organization_member(
        self, organization_name: str, user_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバーの削除
        https://annofab.com/docs/api/#operation/deleteOrganizationMember


        authorizations: OrganizationAdministrator


        組織メンバーを削除します。削除された組織メンバーの`status`は`inactive`になります。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザーID (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_member(self, organization_name: str, user_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織メンバー取得
        https://annofab.com/docs/api/#operation/getOrganizationMember


        authorizations: AllOrganizationMember


        組織メンバーを取得します。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザーID (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_members(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """組織メンバー一括取得
        https://annofab.com/docs/api/#operation/getOrganizationMembers


        authorizations: AllOrganizationMember


        組織メンバーを一括で取得します。  ただし、組織から脱退したメンバーは取得できません。

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationMemberList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def invite_organization_member(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ユーザーを組織に招待
        https://annofab.com/docs/api/#operation/inviteOrganizationMember


        authorizations: OrganizationAdministrator


        指定したユーザーを組織に招待します。招待されたユーザーにはメールが届きます。メールに記載されたURLにアクセスすることで組織に参加することができます。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザーID (required)
            request_body (Any): Request Body
                invite_organization_member_request (InviteOrganizationMemberRequest):  (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/invitation"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def update_organization_member_role(
        self, organization_name: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """組織メンバーのロール更新
        https://annofab.com/docs/api/#operation/updateOrganizationMemberRole


        authorizations: OrganizationOwner


        組織メンバーのロールを変更します。

        Args:
            organization_name (str):  組織名 (required)
            user_id (str):  ユーザーID (required)
            request_body (Any): Request Body
                put_organization_member_role_request (PutOrganizationMemberRoleRequest):  (required)

        Returns:
            Tuple[OrganizationMember, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/members/{user_id}/role"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfOrganizationPluginApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_organization_plugin(
        self, organization_name: str, plugin_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグインの削除
        https://annofab.com/docs/api/#operation/deleteOrganizationPlugin


        authorizations: OrganizationAdministrator, OrganizationOwner


        プラグインを削除します。  **この API は Annofab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_plugin(
        self, organization_name: str, plugin_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグインの取得
        https://annofab.com/docs/api/#operation/getOrganizationPlugin


        authorizations: AllOrganizationMember


        プラグインを取得します。  **この API は Annofab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_plugins(self, organization_name: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プラグインの一括取得
        https://annofab.com/docs/api/#operation/getOrganizationPlugins


        authorizations: AllOrganizationMember


        プラグインを一括で取得します。  **この API は Annofab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**

        Args:
            organization_name (str):  組織名 (required)

        Returns:
            Tuple[OrganizationPluginList, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_organization_plugin(
        self, organization_name: str, plugin_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プラグインの作成/更新
        https://annofab.com/docs/api/#operation/putOrganizationPlugin


        authorizations: OrganizationAdministrator, OrganizationOwner


        プラグインを作成または更新します。  **この API は Annofab に許可された組織だけで使用できます。またアルファ版につき、予告なく変更されることがあります。**

        Args:
            organization_name (str):  組織名 (required)
            plugin_id (str):  プラグインID (required)
            request_body (Any): Request Body
                put_organization_plugin_request (PutOrganizationPluginRequest):  (required)

        Returns:
            Tuple[OrganizationPlugin, requests.Response]


        """
        url_path = f"/organizations/{organization_name}/plugins/{plugin_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト削除
        https://annofab.com/docs/api/#operation/deleteProject


        authorizations: ProjectOwner


        プロジェクトを完全に削除します。 アノテーション仕様、タスク、入力データ、アノテーションなど、プロジェクト配下のリソースがすべて削除されます。  **削除されたプロジェクトは元に戻せません。** 完了したプロジェクトは削除せず、プロジェクトの状態を「停止中」に変更するのを推奨します。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`delete-project`）。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[DeleteProjectResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_organization_of_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトの所属組織取得
        https://annofab.com/docs/api/#operation/getOrganizationOfProject


        authorizations: AllProjectMember


        プロジェクトが所属する組織を取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Organization, requests.Response]


        """
        url_path = f"/projects/{project_id}/organization"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクト取得
        https://annofab.com/docs/api/#operation/getProject


        authorizations: AllProjectMember


        プロジェクトを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Project, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_comments_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """コメント全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectCommentsUrl


        authorizations: ProjectDataUser


        コメント全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  コメント全件ファイルは、すべてのコメントが記載されたJSONファイルです。 JSON構造は、[Comment](#section/Comment)の配列です。  毎日AM02:00(JST)頃に更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/comments"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_inputs_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データ情報全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectInputsUrl


        authorizations: ProjectDataUser


        入力データ全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  入力データ全件ファイルは、すべての入力データが記載されたJSONファイルです。SON構造は、[InputData](#section/InputData)の配列です。 ただしInputData中のurlは常にnullです。  毎日AM02:00(JST)頃に更新されます。 [postProjectInputsUpdate](#operation/postProjectInputsUpdate) APIを利用すれば、手動で入力データ全件ファイルを更新できます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/inputs"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_inspections_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """検査コメント全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectInspectionsUrl

        .. deprecated:: X

        authorizations: ProjectDataUser


        検査コメント全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  検査コメント全件ファイルには、すべての検査コメントが記載されたファイルです。 JSON構造は、[Inspection](#section/Inspection)の配列です。  毎日AM02:00(JST)頃に更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_project_inspections_url() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/rawdata/inspections"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_task_histories_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク履歴全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectTaskHistoriesUrl


        authorizations: ProjectDataUser


        タスク履歴全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。   タスク履歴イベント全件ファイルは、すべてのタスク履歴情報が記載されたJSONファイルです。JSON構造は、キーがタスクID、値が[TaskHistory](#section/TaskHistory)の配列となるマップです。  毎日AM02:00(JST)頃に更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/task_histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_task_history_events_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトのタスク履歴イベント全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectTaskHistoryEventsUrl

        .. deprecated:: X

        authorizations: ProjectDataUser


        タスク履歴イベント全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。   タスク履歴イベント全件ファイルは、すべてのタスク履歴イベント情報が記載されたJSONファイルです。 JSON構造は、[TaskHistoryEvent](#section/TaskHistoryEvent)の配列です。  毎日AM02:00(JST)頃に更新されます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        warnings.warn(
            "annofabapi.AnnofabApi.get_project_task_history_events_url() is deprecated and will be removed.",
            FutureWarning,
            stacklevel=2,
        )
        url_path = f"/projects/{project_id}/rawdata/task_history_events"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_tasks_url(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク全件ファイルの取得
        https://annofab.com/docs/api/#operation/getProjectTasksUrl


        authorizations: ProjectDataUser


        タスク全件ファイルにアクセスするための、認証済み一時URLを取得します。 取得したURLは1時間で失効し、アクセスできなくなります。  タスク全件ファイルは、すべてのタスクが記載されたJSONファイルです。JSON構造は、[Task](#section/Task)の配列です。  毎日AM02:00(JST)頃に更新されます。 [postProjectTasksUpdate](#operation/postProjectTasksUpdate) APIを利用すれば、手動でタスク全件ファイルを更新できます。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/tasks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_project_copy(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトのコピー
        https://annofab.com/docs/api/#operation/initiateProjectCopy


        authorizations: OrganizationAdministrator, ProjectOwner


        プロジェクトをコピーします。  以下のデータがコピーされます。 * プロジェクト設定 * プロジェクトメンバー * アノテーション仕様  オプションを指定することで、以下のデータもコピーできます。  |コピー対象のデータ|同時にコピーする必要があるデータ| |:--|:--| |入力データ|| |タスク|入力データ| |アノテーション|入力データ、タスク| |補助情報|入力データ| |作業ガイド|| |Webhook||  このAPIを利用するには、以下のロールが必要です。 * コピー元プロジェクトのプロジェクトオーナーロール * コピー元プロジェクトが所属している組織の組織管理者または組織オーナーロール  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`copy-project`）。

        Args:
            project_id (str):  コピー元となるプロジェクトID (required)
            request_body (Any): Request Body
                project_copy_request (ProjectCopyRequest):  (required)

        Returns:
            Tuple[ProjectCopyResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/copy"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_project_inputs_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """入力データ全件ファイルの更新開始
        https://annofab.com/docs/api/#operation/postProjectInputsUpdate


        authorizations: ProjectDataUser


        入力データ全件ファイルの更新を開始します。 ファイルの更新には、データ量に応じて数分～数十分程度かかります。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-inputs-list`）。  入力データ全件ファイルについては、[getProjectInputsUrl](#operation/getProjectInputsUrl) APIを参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[ProjectInputsUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/inputs"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def post_project_tasks_update(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク全件ファイルの更新開始
        https://annofab.com/docs/api/#operation/postProjectTasksUpdate


        authorizations: ProjectDataUser


        タスク全件ファイルの更新を開始します。 ファイルの更新には、データ量に応じて数分～数十分程度かかります。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-tasks-list`）。  タスク全件ファイルについては、[getProjectTasksUrl](#operation/getProjectTasksUrl) APIを参照ください。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[PostProjectTasksUpdateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/rawdata/tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_project(
        self,
        project_id: str,
        query_params: Optional[Dict[str, Any]] = None,
        request_body: Optional[Any] = None,
        **kwargs,
    ) -> Tuple[Any, requests.Response]:
        """プロジェクト作成/更新
        https://annofab.com/docs/api/#operation/putProject


        authorizations: OrganizationAdministrator, ProjectOwner


        プロジェクトを新規作成または更新します。  ### 新規作成する場合 ユーザーは、作成するプロジェクトをひもづける組織の [OrganizationAdministrator](#section/Authentication/OrganizationAdministrator) である必要があります。  ### 更新する場合 ユーザーは、更新するプロジェクトの [ProjectOwner](#section/Authentication/ProjectOwner) である必要があります。 また所属組織を変更する場合は、新しくひもづける組織の [OrganizationAdministrator](#section/Authentication/OrganizationAdministrator) である必要があります。  なお、プロジェクト状態を「停止中」にした場合、アノテーションZIPやタスク進捗状況などの集計情報は自動更新されなくなります。  所属組織が変更された場合バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`move-project`）。  APIの制限事項は、以下の通りです。  * `status`を`initializing`に変更できません。  * `status`が`initializing`のときは、所属組織を変更できません。

        Args:
            project_id (str):  プロジェクトID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            query_params (Dict[str, Any]): Query Parameters
                v (str):  APIの戻り型のバージョンを指定します。 値と戻り型の対応は以下です。 - \"1\"：Project - \"2\"：PutProjectResponse
            request_body (Any): Request Body
                put_project_request (PutProjectRequest):

        Returns:
            Tuple[Project, requests.Response]


        """
        url_path = f"/projects/{project_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfProjectMemberApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_project_member(self, project_id: str, user_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー取得
        https://annofab.com/docs/api/#operation/getProjectMember


        authorizations: AllProjectMember


        プロジェクトメンバーを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            user_id (str):  ユーザーID (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/projects/{project_id}/members/{user_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_project_members(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー一括取得
        https://annofab.com/docs/api/#operation/getProjectMembers


        authorizations: AllProjectMember


        プロジェクトメンバを一括で取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                include_inactive_member (str):  脱退したプロジェクトメンバーも取得する時に、キーのみ指定します（値は無視されます）。

        Returns:
            Tuple[ProjectMemberList, requests.Response]


        """
        url_path = f"/projects/{project_id}/members"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_project_member(
        self, project_id: str, user_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """プロジェクトメンバー追加/更新
        https://annofab.com/docs/api/#operation/putProjectMember


        authorizations: ProjectOwner


        プロジェクトにメンバーを新規に追加、または存在するメンバーの設定を変更します。

        Args:
            project_id (str):  プロジェクトID (required)
            user_id (str):  ユーザーID (required)
            request_body (Any): Request Body
                project_member_request (ProjectMemberRequest):  (required)

        Returns:
            Tuple[ProjectMember, requests.Response]


        """
        url_path = f"/projects/{project_id}/members/{user_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfStatisticsApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def get_account_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """メンバー別作業時間の取得
        https://annofab.com/docs/api/#operation/getAccountDailyStatistics


        authorizations: AllProjectMember


        プロジェクトメンバーごとの作業時間やタスクの提出回数を取得します。  * 作業時間 * 教師付フェーズのタスクを提出した回数、または検査/受入フェーズのタスクを合格/差戻にした回数 * 教師付フェーズを担当して提出したタスクが差し戻された回数、または受入フェーズを担当して合格にしたタスクが受入完了状態を取り消された回数  取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectAccountStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/accounts/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_inspection_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """ラベル別検査コメント数の取得
        https://annofab.com/docs/api/#operation/getInspectionDailyStatistics


        authorizations: AllProjectMember


        ラベルごとの検査コメント数を取得します。  取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[InspectionStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/inspections/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_label_statistics(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """ラベル別アノテーション数の取得
        https://annofab.com/docs/api/#operation/getLabelStatistics


        authorizations: AllProjectMember


        [ラベル別アノテーション数集計データ](#section/ArrayOfLabelStatistics) を取得するための認証済み一時URLを取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[TemporaryUrl, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/labels"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_markers(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """統計グラフマーカー一括取得
        https://annofab.com/docs/api/#operation/getMarkers


        authorizations: AllProjectMember


        統計グラフマーカーをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[Markers, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/markers"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_phase_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """フェーズ別作業時間の取得
        https://annofab.com/docs/api/#operation/getPhaseDailyStatistics


        authorizations: AllProjectMember


        フェーズごとの累積作業時間を取得します。  取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[TaskPhaseStatistics], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/task-phases/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_statistics_available_dates(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """統計情報の期間の取得
        https://annofab.com/docs/api/#operation/getStatisticsAvailableDates


        authorizations: AllProjectMember


        統計情報が存在する期間を取得します。  たとえば、プロジェクトの状態が以下のように変化したとします。  1. 2022/01/01にプロジェクトを作成した。 2. 2022/02/01にプロジェクトの状態を停止中にした。 3. 2022/03/01にプロジェクトの状態を進行中にした。 4. 2022/04/01にプロジェクトの状態を停止中にした。  このAPIを実行すると、以下のJSONが取得されます。  ``` [   {\"from\":\"2022-01-01\", \"to\":\"2022-02-01\"},   {\"from\":\"2022-03-01\", \"to\":\"2022-04-01\"} ] ```  プロジェクトを停止中にすると統計情報は記録されないので、統計情報が存在する期間は複数になります。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[DateRange], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/dates"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """フェーズ別タスク数の取得
        https://annofab.com/docs/api/#operation/getTaskDailyStatistics


        authorizations: AllProjectMember


        タスクのフェーズごと、タスクのステータスごとのタスク数などを取得します。  取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[List[ProjectTaskStatisticsHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/tasks/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """単位あたり作業時間の取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatistics


        authorizations: AllProjectMember


        プロジェクトの単位あたり作業時間情報を取得します。  以下の作業時間情報を取得できます。 * タスク1個あたりの作業時間情報 * 画像1枚あたりの作業時間情報（画像プロジェクトのみ） * 動画1分あたりの作業時間情報（動画プロジェクトのみ）          取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByProject, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_worktime_daily_statistics_by_account(
        self, project_id: str, account_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """メンバーの単位あたり作業時間の取得
        https://annofab.com/docs/api/#operation/getWorktimeDailyStatisticsByAccount


        authorizations: AllProjectMember


        プロジェクトメンバーの単位あたり作業時間情報を取得します。  以下の作業時間情報を取得できます。 * タスク1個あたりの作業時間情報 * 画像1枚あたりの作業時間情報（画像プロジェクトのみ） * 動画1分あたりの作業時間情報（動画プロジェクトのみ）          取得期間は最大3か月です。

        Args:
            project_id (str):  プロジェクトID (required)
            account_id (str):  アカウントID (required)
            query_params (Dict[str, Any]): Query Parameters
                from (str):  取得する統計の区間の開始日 - `YYYY-MM-DD` (required)
                to (str):  取得する統計の区間の終了日 - `YYYY-MM-DD` 。この日は含まれます。 (required)

        Returns:
            Tuple[WorktimeStatisticsByAccount, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/worktimes-by-account/{account_id}/daily"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_markers(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """統計グラフマーカー更新
        https://annofab.com/docs/api/#operation/putMarkers


        authorizations: ProjectOwner


        統計グラフマーカーを更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                put_markers_request (PutMarkersRequest):  (required)

        Returns:
            Tuple[Markers, requests.Response]


        """
        url_path = f"/projects/{project_id}/statistics/markers"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfSupplementaryApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_supplementary_data(
        self, project_id: str, input_data_id: str, supplementary_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """補助情報削除
        https://annofab.com/docs/api/#operation/deleteSupplementaryData


        authorizations: ProjectOwner


        補助情報を削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)
            supplementary_data_id (str):  補助情報ID (required)

        Returns:
            Tuple[, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data/{supplementary_data_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_supplementary_data_list(
        self, project_id: str, input_data_id: str, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """補助情報一括取得
        https://annofab.com/docs/api/#operation/getSupplementaryDataList


        authorizations: AllProjectMember


        入力データに紐付けられた補助情報をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)

        Returns:
            Tuple[List[SupplementaryData], requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_supplementary_data(
        self,
        project_id: str,
        input_data_id: str,
        supplementary_data_id: str,
        request_body: Optional[Any] = None,
        **kwargs,
    ) -> Tuple[Any, requests.Response]:
        """補助情報作成/更新
        https://annofab.com/docs/api/#operation/putSupplementaryData


        authorizations: ProjectOwner


        補助情報を作成または更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            input_data_id (str):  入力データID (required)
            supplementary_data_id (str):  補助情報ID (required)
            request_body (Any): Request Body
                supplementary_data_request (SupplementaryDataRequest):  (required)

        Returns:
            Tuple[SupplementaryData, requests.Response]


        """
        url_path = f"/projects/{project_id}/inputs/{input_data_id}/supplementary-data/{supplementary_data_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfTaskApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def assign_tasks(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク割当
        https://annofab.com/docs/api/#operation/assignTasks


        authorizations: AllProjectMember


        自分自身またはメンバーにタスクを割り当てます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                task_assign_request (TaskAssignRequest):  (required)

        Returns:
            Tuple[List[Task], requests.Response]


        """
        url_path = f"/projects/{project_id}/assign-tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def batch_update_tasks(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク一括更新
        https://annofab.com/docs/api/#operation/batchUpdateTasks


        authorizations: ProjectOwner


        タスクを一括更新します。  リクエストボディは、1個以上の「操作」オブジェクトを含むJSON配列になります。 操作オブジェクトには、現在「削除」の1通りのみがあります。 これら操作オブジェクトを複数含めることで、1リクエストで複数の削除ができます。  複数の操作のうち、1つでも失敗するとAPIのレスポンス全体としては失敗になります。 成功した部分までは反映されます。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                batch_task_request_item (List[BatchTaskRequestItem]):  (required)

        Returns:
            Tuple[List[Task], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def delete_task(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク削除
        https://annofab.com/docs/api/#operation/deleteTask


        authorizations: ProjectOwner


        タスクを削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク取得
        https://annofab.com/docs/api/#operation/getTask


        authorizations: AllProjectMember


        タスクを取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_task_histories(self, project_id: str, task_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """タスク履歴一括取得
        https://annofab.com/docs/api/#operation/getTaskHistories


        authorizations: AllProjectMember


        タスクの作業履歴をすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)

        Returns:
            Tuple[List[TaskHistory], requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/histories"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_tasks(
        self, project_id: str, query_params: Optional[Dict[str, Any]] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスクの一括取得
        https://annofab.com/docs/api/#operation/getTasks


        authorizations: AllProjectMember


        タスクを一括で取得します。

        Args:
            project_id (str):  プロジェクトID (required)
            query_params (Dict[str, Any]): Query Parameters
                page (int):  検索結果のうち、取得したいページの番号(1始まり）
                limit (int):  1ページあたりの取得するデータ件数
                task_id (str):  タスクIDでの部分一致検索で使用。大文字小文字は区別しません
                input_data_ids (str):  指定された入力データIDを使用しているタスクを絞り込みます。カンマ区切りで複数の入力データIDを指定可能です。大文字小文字は区別しません
                phase (TaskPhase):  絞り込み条件となるフェーズ名
                phase_stage (int):  絞り込み条件となるステージ
                status (TaskStatus):  絞り込み条件となる状態名
                account_id (str):  絞り込み条件となる作業中のアカウントID
                no_user (str):  未割り当てのタスクを絞り込む時に、キーのみ指定します（値は無視されます）。
                previous_account_id (str):  そのタスクをこれまでに担当したことのあるユーザー（現在の担当者含む）のアカウントID
                previous_phase (TaskPhase):  そのタスクがこれまでに遷移したことのあるフェーズ名（現在のフェーズ含む）
                previous_phase_stage (int):  そのタスクがこれまでに遷移したことのあるステージ（現在のステージ含む）
                rejected_only (str):  差し戻されたタスクだけを絞り込む時に、キーのみ指定します（値は無視されます）。
                auto_accepted_only (str):  「抜取検査の対象外となり、自動受入されたタスク」だけを絞り込む時に、キーのみ指定します（値は無視されます）。
                metadata (str):  メタデータからタスクを検索できます。  例えば、 `priority` (数値) や `assignable` (真偽値) といったメタデータを個々のタスクに登録していたとします。 その場合、次のように検索できます。  ``` // priorityが5のタスクを検索 priority:5  // priorityが5以外のタスクを検索 -priority:5  // priorityが1より大きいタスクを検索 priority:>1  // priorityが1以上のタスクを検索 priority:>=1  // priorityが100未満のタスクを検索 priority:<100  // priorityが100以下のタスクを検索 priority:<=100  // priorityが1~100のタスクを検索 (複数の検索条件は半角スペースで区切ります) priority:>=1 priority:<=100  // priorityが1以上、且つ、assignableがtrueのタスクを検索 priority:>=1 assignable:true ```  (注意) これらの例は、説明の都合上「URLエンコード」を施していません。実際には、URLエンコードを施してください。
                sort (str):  ソート順の指定。以下のキーを使用できます。 * `task_id` * `updated_datetime` * `number_of_rejections` * `phase` * `phase_stage` * `account_id` * `metadata.{メタデータのキー}`   * キーの先頭に`-`を付けると、降順でソートされます。 * `,`でキーを区切ると、複数のキーでソートされます。先頭のキーから順に優先順位が割り振られます。
                annotation (str):  アノテーションの絞り込み条件をJSON形式([AnnotationQuery](#section/AnnotationQuery))で指定したもの。指定した条件に合致するアノテーションを持つタスクを絞り込む際に指定する。

        Returns:
            Tuple[TaskList, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {
            "query_params": query_params,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def initiate_tasks_generation(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク一括作成
        https://annofab.com/docs/api/#operation/initiateTasksGeneration


        authorizations: ProjectOwner


        タスク作成ルールに基づいて、タスクを一括で作成します。  タスク作成ルールは、以下の3つです。  * `ByCount`：1つのタスクに割り当てる入力データの個数を指定してタスクを生成します。この作成ルールは、画像を同じ枚数均等にタスクに割り振りたい場合に便利です。 * `ByDirectory`：入力データ名をファイルパスに見立て、ディレクトリ単位でタスクを生成します。この作成ルールは、動画などから切り出した画像をディレクトリ別に格納し、その動画（ディレクトリ）の単位でタスクを作りたい場合に便利です。 * `ByInputDataCsv`：入力データを各タスクに割り振ったCSVへのS3パスを指定してタスクを生成できます。この作成ルールは、特定のデータの組み合わせを持ったタスクを作成したい場合に便利です。  本APIを実行すると、バックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます（ジョブ種別は`gen-tasks`）。  #### ByDirectory: ディレクトリ単位でのタスク一括生成の使い方 例えば、次のような `input_data_name` の入力データが登録されているとします。  * a.zip/dir1/image1.png * a.zip/dir1/image2.png * a.zip/dir1/subdir/image3.png * a.zip/dir1/subdir/image4.png * a.zip/dir1/subdir/image5.png * b.zip/dir2/subdir1/image6.png * b.zip/dir2/subdir1/image7.png * b.zip/dir2/subdir1/image8.png * b.zip/dir2/subdir2/image9.png * b.zip/dir2/subdir2/image10.png  ここで、`input_data_name_prefix`フィールド に `a.zip` を指定すると、次の2タスクが生成されます。  1. タスク: `{task_id_prefix}_a.zip_dir1`   * a.zip/dir1/image1.png   * a.zip/dir1/image2.png 2. タスク: `{task_id_prefix}_a.zip_dir1_subdir`   * a.zip/dir1/subdir/image3.png   * a.zip/dir1/subdir/image4.png   * a.zip/dir1/subdir/image5.png  次に、`input_data_name_prefix` に `b.zip/dir2` を指定すると、次の2タスクが生成されます。  1. タスク: `{task_id_prefix}_b.zip_dir2_subdir1`   * b.zip/dir2/subdir1/image6.png   * b.zip/dir2/subdir1/image7.png   * b.zip/dir2/subdir1/image8.png 2. タスク: `{task_id_prefix}_b.zip_dir2_subdir2`   * b.zip/dir2/subdir2/image9.png   * b.zip/dir2/subdir2/image10.png  `input_data_name_prefix` が未指定の時は、全ディレクトリごとにタスクが作成されます。つまり次のように4つのタスクが生成されます。  1. タスク: `{task_id_prefix}_a.zip_dir1`   * a.zip/dir1/image1.png   * a.zip/dir1/image2.png 2. タスク: `{task_id_prefix}_a.zip_dir1_subdir`   * a.zip/dir1/subdir/image3.png   * a.zip/dir1/subdir/image4.png   * a.zip/dir1/subdir/image5.png 3. タスク: `{task_id_prefix}_b.zip_dir2_subdir1`   * b.zip/dir2/subdir1/image6.png   * b.zip/dir2/subdir1/image7.png   * b.zip/dir2/subdir1/image8.png 4. タスク: `{task_id_prefix}_b.zip_dir2_subdir2`   * b.zip/dir2/subdir2/image9.png   * b.zip/dir2/subdir2/image10.png  タスクに割り当てられる「ディレクトリ内の入力データ」の順序は、名前の昇順となります。  **注意:** `ByDirectory`では、入力データ名がファイルパス形式になっていない入力データはタスクの作成対象になりません。 例えば、`foo/bar.png` はタスクの作成対象になりますが、ディレクトリを含まない`bar.png` や、最後がディレクトリになっている`foo/bar.png/` は対象になりません。  **注意:** `ByDirectory`では、一つのディレクトリに200ファイルより多くの入力データがある場合、複数のタスクに分かれます。 例えば、`foo/` の中に201ファイルがある場合、fooから２つのタスクが作成されます。１つ目は最初の200ファイルを割り当て、２つ目は最後の１ファイルのタスクに分かれます。 分かれたタスクは、 `{上述のタスクIDの付与則}_連番` の形式でタスクIDが付与されます。連番は、対象の入力データ数の桁数まで0埋めされます。  **注意:** 動画プロジェクトの場合、ディレクトリに含まれる動画の入力データは1つに制限してください。 これが守られない場合、作成されたタスクで動画を再生できない場合があります。  #### ByInputDataCsv: CSVによるタスク一括生成の使い方 以下のように「タスクID,入力データ名,入力データID」を1行毎に指定したCSVを作成します。  ``` task_1,a001.jpg,ca0cb2f9-fec5-49b4-98df-dc34490f9785 task_1,a002.jpg,5ac1987e-ca7c-42a0-9c19-b5b23a41836b task_1,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee task_2,b001.jpg,4f2ae4d0-7a38-4f9a-be6f-170ba76aba73 task_2,b002.jpg,45ac5852-f20c-4938-9ee9-cc0274401df7 task_2,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee task_3,c001.jpg,3260c7a0-4820-424d-a26e-db7e91dbc139 task_3,centinel.jpg,81d6407b-2172-4fa8-8525-2e43c49267ee ``` CSVのエンコーディングは UTF-8(BOM付き)、UTF-8(BOMなし)、UTF-16(BOM付きLE) のいずれかのみ対応しています。  リクエストボディの`csv_data_path`には、[createTempPath](#operation/createTempPath) APIで取得したS3パスを指定してください。[createTempPath](#operation/createTempPath) APIで取得したURLに、事前にCSVファイルをアップロードする必要があります。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                task_generate_request (TaskGenerateRequest):  (required)

        Returns:
            Tuple[TaskGenerateResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/generate-tasks"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def operate_task(
        self, project_id: str, task_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク状態変更
        https://annofab.com/docs/api/#operation/operateTask


        authorizations: AllProjectMember


        タスクのステータスやフェーズ、担当者を変更できます。  ユースケースごとのリクエストボディのサンプルを、以下に記載します。  ### タスクのステータスを作業中に変更  ``` {\"status\": \"working\", \"account_id\": \"{現在の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、現在のタスクの担当者 * 現在のタスクのステータスが`not_started`, `break`, `on_hold` のいずれか  ### タスクのステータスを休憩中に変更  ``` {\"status\": \"break\", \"account_id\": \"{現在の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、現在のタスクの担当者 * 現在のタスクのステータスが`working`  ### タスクのステータスを保留中に変更  ``` {\"status\": \"on_hold\", \"account_id\": \"{現在の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、現在のタスクの担当者 * 現在のタスクのステータスが`working`   ### タスクの提出  ``` {\"status\": \"complete\", \"account_id\": \"{現在の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、現在のタスクの担当者 * 現在のタスクのステータスが`working`  ### タスクの提出取り消し  ``` {\"status\": \"cancelled\", \"account_id\": \"{タスクを提出したユーザーのアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、タスクを提出したユーザー * 現在のタスクのステータスが`not_started` * 現在のタスクのフェーズが`inspection`または`acceptance` * タスクの提出後に、検査/受入(抜取含む)等の作業が一切行われていない  ### タスクの差し戻し  ``` {\"status\": \"rejected\", \"account_id\": \"{現在の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、現在のタスクの担当者 * 現在のタスクのステータスが`working` * 現在のタスクのフェーズが`inspection`または`acceptance`   ### タスクの強制差し戻し  ``` {\"status\": \"rejected\", \"force\": true, \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  「強制差し戻し」は、通常の「差し戻し」と比較して以下の点が異なります。 * 現在のタスクのステータスやフェーズに関わらず、タスクを差し戻せる * 差し戻し後のタスクの担当者は、直前の教師付けフェーズの担当者 * 抜取検査・抜取受入のスキップ判定に影響を及ぼさない   APIの制約は以下の通りです。 * API実行者は、プロジェクトオーナーロールを持つ  ### タスクの受入取り消し  ``` {\"status\": \"not_started\", \"account_id\": \"{受入取り消し後の担当者のアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  APIの制約は以下の通りです。 * API実行者は、プロジェクトオーナーロールを持つ * 現在のタスクのステータスが`completed` * 現在のタスクのフェーズが`acceptance`  ### タスクの担当者の変更  ``` {\"status\": \"not_started\", \"account_id\": \"{担当させるユーザーのアカウントID}\", \"last_updated_datetime\": \"2018-08-14T19:01:51.775+09:00\"} ```  タスクに担当者を割り当てない場合は、`account_id`を未指定にしてください。  このAPIは、メンバー1人に割り当てられるタスク数の上限を無視して、担当者を変更できます。  APIの制約は以下の通りです。 * API実行者は、プロジェクトオーナーまたはチェッカーロールを持つ

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID (required)
            request_body (Any): Request Body
                task_operation (TaskOperation):  (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}/operate"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def patch_tasks_metadata(
        self, project_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスクメタデータの一括更新
        https://annofab.com/docs/api/#operation/patchTasksMetadata


        authorizations: ProjectDataUser


        複数のタスクのメタデータを一括で更新します。

        Args:
            project_id (str):  プロジェクトID (required)
            request_body (Any): Request Body
                request_body (dict(str, dict)):  (required)

        Returns:
            Tuple[Message, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/metadata"
        http_method = "PATCH"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_task(
        self, project_id: str, task_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """タスク作成/更新
        https://annofab.com/docs/api/#operation/putTask


        authorizations: ProjectOwner


        タスクを作成または更新します。  大量のタスクを一括で生成する場合は、[initiateTasksGeneration](#operation/initiateTasksGeneration) APIの使用を検討してください。

        Args:
            project_id (str):  プロジェクトID (required)
            task_id (str):  タスクID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                task_request (TaskRequest):  (required)

        Returns:
            Tuple[Task, requests.Response]


        """
        url_path = f"/projects/{project_id}/tasks/{task_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    #########################################
    # Public Method : AfWebhookApi
    # NOTE: This method is auto generated by OpenAPI Generator
    #########################################

    def delete_webhook(self, project_id: str, webhook_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """Webhookの削除
        https://annofab.com/docs/api/#operation/deleteWebhook


        authorizations: ProjectOwner


        Webhookを削除します。

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID (required)

        Returns:
            Tuple[Webhook, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}"
        http_method = "DELETE"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def get_webhooks(self, project_id: str, **kwargs) -> Tuple[Any, requests.Response]:
        """Webhookの一括取得
        https://annofab.com/docs/api/#operation/getWebhooks


        authorizations: ProjectOwner


        Webhookをすべて取得します。

        Args:
            project_id (str):  プロジェクトID (required)

        Returns:
            Tuple[List[Webhook], requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks"
        http_method = "GET"
        keyword_params: Dict[str, Any] = {}
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def put_webhook(
        self, project_id: str, webhook_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """Webhookの作成/更新
        https://annofab.com/docs/api/#operation/putWebhook


        authorizations: ProjectOwner


        Webhookを新規作成/更新します。  Webhookが送信するHTTPリクエストのボディには、以下のプレースホルダーを含めることができます。  * task-completed   * {{PROJECT_ID}} :  プロジェクトID   * {{TASK_ID}} : タスクID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00   * {{LAST_ACCOUNT}} : 最終作業者のアカウントID  * annotation-archive-updated   * {{PROJECT_ID}} :  プロジェクトID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00  * input-data-zip-registered   * {{PROJECT_ID}} :  プロジェクトID   * {{PROJECT_TITLE}} : プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00   * {{ZIP_NAME}} : ZIPファイル名     * 例 : input_data.zip  * project-copy-completed   * {{PROJECT_ID}} :  プロジェクトID   * {{DEST_PROJECT_ID}} :  コピー先プロジェクトID   * {{DEST_PROJECT_TITLE}} : コピー先プロジェクトタイトル   * {{COMPLETE_DATETIME}} : 完了日時     * 例 : 2019-05-08T10:00:00.000+09:00  Webhookが起動されると、ジョブ種別が`invoke-hook`のバックグラウンドジョブが登録されます。ジョブは [getProjectJob](#operation/getProjectJob) APIで確認できます。

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID。[値の制約についてはこちら。](#section/API-Convention/APIID)  (required)
            request_body (Any): Request Body
                put_webhook_request (PutWebhookRequest):  (required)

        Returns:
            Tuple[Webhook, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}"
        http_method = "PUT"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)

    def test_webhook(
        self, project_id: str, webhook_id: str, request_body: Optional[Any] = None, **kwargs
    ) -> Tuple[Any, requests.Response]:
        """Webhookのテスト実行
        https://annofab.com/docs/api/#operation/testWebhook


        authorizations: ProjectOwner


        Webhookが実際にHTTPリクエストを送信します。  Webhookが送信するHTTPリクエストのボディに含まれるプレースホルダーは、このAPIで指定されたプレースホルダーの値に置き換えられます。

        Args:
            project_id (str):  プロジェクトID (required)
            webhook_id (str):  WebhookID (required)
            request_body (Any): Request Body
                webhook_test_request (WebhookTestRequest):  (required)

        Returns:
            Tuple[WebhookTestResponse, requests.Response]


        """
        url_path = f"/projects/{project_id}/webhooks/{webhook_id}/test"
        http_method = "POST"
        keyword_params: Dict[str, Any] = {
            "request_body": request_body,
        }
        keyword_params.update(**kwargs)
        return self._request_wrapper(http_method, url_path, **keyword_params)
